/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.config;

import java.util.Collection;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.annotation.Configuration;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.config.MutateConfig;
import org.neo4j.gds.core.StringIdentifierValidations;
import org.neo4j.gds.utils.StringFormatting;

public interface MutatePropertyConfig
extends MutateConfig {
    public static final String MUTATE_PROPERTY_KEY = "mutateProperty";

    @Configuration.ConvertWith(value="validateProperty")
    @Configuration.Key(value="mutateProperty")
    public String mutateProperty();

    @Nullable
    public static String validateProperty(String input) {
        return StringIdentifierValidations.validateNoWhiteCharacter((String)StringIdentifierValidations.emptyToNull((String)input), (String)MUTATE_PROPERTY_KEY);
    }

    @Configuration.GraphStoreValidationCheck
    default public void validateMutateProperty(GraphStore graphStore, Collection<NodeLabel> selectedLabels, Collection<RelationshipType> selectedRelationshipTypes) {
        if (this.mutateProperty() != null && graphStore.hasNodeProperty(selectedLabels, this.mutateProperty())) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Node property `%s` already exists in the in-memory graph.", (Object[])new Object[]{this.mutateProperty()}));
        }
    }
}

