/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.config;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.NodeProjections;
import org.neo4j.gds.Orientation;
import org.neo4j.gds.RelationshipProjections;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.beta.generator.RelationshipDistribution;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.GraphProjectConfig;
import org.neo4j.gds.config.JobIdConfig;
import org.neo4j.gds.config.RandomGraphGeneratorConfig;
import org.neo4j.gds.core.Aggregation;
import org.neo4j.gds.core.utils.progress.JobId;

@ParametersAreNonnullByDefault
@Generated(from="RandomGraphGeneratorConfig", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableRandomGraphGeneratorConfig
implements RandomGraphGeneratorConfig {
    @javax.annotation.Nullable
    private final String usernameOverride;
    private final boolean sudo;
    private final Collection<String> configKeys;
    private final transient Map<String, Object> toMap;
    private final JobId jobId;
    private final String username;
    private final String graphName;
    private final int readConcurrency;
    private final long relationshipCount;
    private final transient ZonedDateTime creationTime;
    private final boolean validateRelationships;
    private final long nodeCount;
    private final long averageDegree;
    private final Aggregation aggregation;
    private final Orientation orientation;
    private final boolean allowSelfLoops;
    private final RelationshipDistribution relationshipDistribution;
    @Nullable
    private final Long relationshipSeed;
    private final NodeProjections nodeProjections;
    private final RelationshipType relationshipType;
    private final RelationshipProjections relationshipProjections;
    private final transient Set<String> outputFieldDenylist;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableRandomGraphGeneratorConfig(String username, String graphName, long nodeCount, long averageDegree, Aggregation aggregation, Orientation orientation, boolean allowSelfLoops, RelationshipDistribution relationshipDistribution, @Nullable Long relationshipSeed, NodeProjections nodeProjections, RelationshipType relationshipType, RelationshipProjections relationshipProjections) {
        this.initShim.username(Objects.requireNonNull(username, "username"));
        this.graphName = Objects.requireNonNull(graphName, "graphName");
        this.nodeCount = nodeCount;
        this.averageDegree = averageDegree;
        this.initShim.aggregation(Objects.requireNonNull(aggregation, "aggregation"));
        this.initShim.orientation(Objects.requireNonNull(orientation, "orientation"));
        this.initShim.allowSelfLoops(allowSelfLoops);
        this.initShim.relationshipDistribution(Objects.requireNonNull(relationshipDistribution, "relationshipDistribution"));
        this.initShim.relationshipSeed(relationshipSeed);
        this.initShim.nodeProjections(Objects.requireNonNull(nodeProjections, "nodeProjections"));
        this.initShim.relationshipType(Objects.requireNonNull(relationshipType, "relationshipType"));
        this.initShim.relationshipProjections(Objects.requireNonNull(relationshipProjections, "relationshipProjections"));
        this.usernameOverride = null;
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.jobId = this.initShim.jobId();
        this.username = this.initShim.username();
        this.readConcurrency = this.initShim.readConcurrency();
        this.relationshipCount = this.initShim.relationshipCount();
        this.creationTime = this.initShim.creationTime();
        this.validateRelationships = this.initShim.validateRelationships();
        this.aggregation = this.initShim.aggregation();
        this.orientation = this.initShim.orientation();
        this.allowSelfLoops = this.initShim.allowSelfLoops();
        this.relationshipDistribution = this.initShim.relationshipDistribution();
        this.relationshipSeed = this.initShim.relationshipSeed();
        this.nodeProjections = this.initShim.nodeProjections();
        this.relationshipType = this.initShim.relationshipType();
        this.relationshipProjections = this.initShim.relationshipProjections();
        this.outputFieldDenylist = this.initShim.outputFieldDenylist();
        this.initShim = null;
    }

    private ImmutableRandomGraphGeneratorConfig(Builder builder) {
        this.usernameOverride = builder.usernameOverride;
        this.graphName = builder.graphName;
        this.nodeCount = builder.nodeCount;
        this.averageDegree = builder.averageDegree;
        if (builder.sudoIsSet()) {
            this.initShim.sudo(builder.sudo);
        }
        if (builder.configKeys != null) {
            this.initShim.configKeys(builder.configKeys);
        }
        if (builder.jobId != null) {
            this.initShim.jobId(builder.jobId);
        }
        if (builder.username != null) {
            this.initShim.username(builder.username);
        }
        if (builder.readConcurrencyIsSet()) {
            this.initShim.readConcurrency(builder.readConcurrency);
        }
        if (builder.relationshipCountIsSet()) {
            this.initShim.relationshipCount(builder.relationshipCount);
        }
        if (builder.validateRelationshipsIsSet()) {
            this.initShim.validateRelationships(builder.validateRelationships);
        }
        if (builder.aggregation != null) {
            this.initShim.aggregation(builder.aggregation);
        }
        if (builder.orientation != null) {
            this.initShim.orientation(builder.orientation);
        }
        if (builder.allowSelfLoopsIsSet()) {
            this.initShim.allowSelfLoops(builder.allowSelfLoops);
        }
        if (builder.relationshipDistribution != null) {
            this.initShim.relationshipDistribution(builder.relationshipDistribution);
        }
        if (builder.relationshipSeedIsSet()) {
            this.initShim.relationshipSeed(builder.relationshipSeed);
        }
        if (builder.nodeProjections != null) {
            this.initShim.nodeProjections(builder.nodeProjections);
        }
        if (builder.relationshipType != null) {
            this.initShim.relationshipType(builder.relationshipType);
        }
        if (builder.relationshipProjections != null) {
            this.initShim.relationshipProjections(builder.relationshipProjections);
        }
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.jobId = this.initShim.jobId();
        this.username = this.initShim.username();
        this.readConcurrency = this.initShim.readConcurrency();
        this.relationshipCount = this.initShim.relationshipCount();
        this.creationTime = this.initShim.creationTime();
        this.validateRelationships = this.initShim.validateRelationships();
        this.aggregation = this.initShim.aggregation();
        this.orientation = this.initShim.orientation();
        this.allowSelfLoops = this.initShim.allowSelfLoops();
        this.relationshipDistribution = this.initShim.relationshipDistribution();
        this.relationshipSeed = this.initShim.relationshipSeed();
        this.nodeProjections = this.initShim.nodeProjections();
        this.relationshipType = this.initShim.relationshipType();
        this.relationshipProjections = this.initShim.relationshipProjections();
        this.outputFieldDenylist = this.initShim.outputFieldDenylist();
        this.initShim = null;
    }

    private ImmutableRandomGraphGeneratorConfig(@javax.annotation.Nullable String usernameOverride, boolean sudo, Collection<String> configKeys, JobId jobId, String username, String graphName, int readConcurrency, long relationshipCount, boolean validateRelationships, long nodeCount, long averageDegree, Aggregation aggregation, Orientation orientation, boolean allowSelfLoops, RelationshipDistribution relationshipDistribution, @Nullable Long relationshipSeed, NodeProjections nodeProjections, RelationshipType relationshipType, RelationshipProjections relationshipProjections) {
        this.usernameOverride = usernameOverride;
        this.initShim.sudo(sudo);
        this.initShim.configKeys(configKeys);
        this.initShim.jobId(jobId);
        this.initShim.username(username);
        this.graphName = graphName;
        this.initShim.readConcurrency(readConcurrency);
        this.initShim.relationshipCount(relationshipCount);
        this.initShim.validateRelationships(validateRelationships);
        this.nodeCount = nodeCount;
        this.averageDegree = averageDegree;
        this.initShim.aggregation(aggregation);
        this.initShim.orientation(orientation);
        this.initShim.allowSelfLoops(allowSelfLoops);
        this.initShim.relationshipDistribution(relationshipDistribution);
        this.initShim.relationshipSeed(relationshipSeed);
        this.initShim.nodeProjections(nodeProjections);
        this.initShim.relationshipType(relationshipType);
        this.initShim.relationshipProjections(relationshipProjections);
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.jobId = this.initShim.jobId();
        this.username = this.initShim.username();
        this.readConcurrency = this.initShim.readConcurrency();
        this.relationshipCount = this.initShim.relationshipCount();
        this.creationTime = this.initShim.creationTime();
        this.validateRelationships = this.initShim.validateRelationships();
        this.aggregation = this.initShim.aggregation();
        this.orientation = this.initShim.orientation();
        this.allowSelfLoops = this.initShim.allowSelfLoops();
        this.relationshipDistribution = this.initShim.relationshipDistribution();
        this.relationshipSeed = this.initShim.relationshipSeed();
        this.nodeProjections = this.initShim.nodeProjections();
        this.relationshipType = this.initShim.relationshipType();
        this.relationshipProjections = this.initShim.relationshipProjections();
        this.outputFieldDenylist = this.initShim.outputFieldDenylist();
        this.initShim = null;
    }

    private boolean sudoInitialize() {
        return RandomGraphGeneratorConfig.super.sudo();
    }

    private Collection<String> configKeysInitialize() {
        return RandomGraphGeneratorConfig.super.configKeys();
    }

    private Map<String, Object> toMapInitialize() {
        return RandomGraphGeneratorConfig.super.toMap();
    }

    private JobId jobIdInitialize() {
        return RandomGraphGeneratorConfig.super.jobId();
    }

    private String usernameInitialize() {
        return RandomGraphGeneratorConfig.super.username();
    }

    private int readConcurrencyInitialize() {
        return RandomGraphGeneratorConfig.super.readConcurrency();
    }

    private long relationshipCountInitialize() {
        return RandomGraphGeneratorConfig.super.relationshipCount();
    }

    private ZonedDateTime creationTimeInitialize() {
        return RandomGraphGeneratorConfig.super.creationTime();
    }

    private boolean validateRelationshipsInitialize() {
        return RandomGraphGeneratorConfig.super.validateRelationships();
    }

    private Aggregation aggregationInitialize() {
        return RandomGraphGeneratorConfig.super.aggregation();
    }

    private Orientation orientationInitialize() {
        return RandomGraphGeneratorConfig.super.orientation();
    }

    private boolean allowSelfLoopsInitialize() {
        return RandomGraphGeneratorConfig.super.allowSelfLoops();
    }

    private RelationshipDistribution relationshipDistributionInitialize() {
        return RandomGraphGeneratorConfig.super.relationshipDistribution();
    }

    @Nullable
    private Long relationshipSeedInitialize() {
        return RandomGraphGeneratorConfig.super.relationshipSeed();
    }

    private NodeProjections nodeProjectionsInitialize() {
        return RandomGraphGeneratorConfig.super.nodeProjections();
    }

    private RelationshipType relationshipTypeInitialize() {
        return RandomGraphGeneratorConfig.super.relationshipType();
    }

    private RelationshipProjections relationshipProjectionsInitialize() {
        return RandomGraphGeneratorConfig.super.relationshipProjections();
    }

    private Set<String> outputFieldDenylistInitialize() {
        return RandomGraphGeneratorConfig.super.outputFieldDenylist();
    }

    public Optional<String> usernameOverride() {
        return Optional.ofNullable(this.usernameOverride);
    }

    public boolean sudo() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sudo() : this.sudo;
    }

    public Collection<String> configKeys() {
        InitShim shim = this.initShim;
        return shim != null ? shim.configKeys() : this.configKeys;
    }

    public Map<String, Object> toMap() {
        InitShim shim = this.initShim;
        return shim != null ? shim.toMap() : this.toMap;
    }

    @Override
    public JobId jobId() {
        InitShim shim = this.initShim;
        return shim != null ? shim.jobId() : this.jobId;
    }

    @Override
    public String username() {
        InitShim shim = this.initShim;
        return shim != null ? shim.username() : this.username;
    }

    @Override
    public String graphName() {
        return this.graphName;
    }

    @Override
    public int readConcurrency() {
        InitShim shim = this.initShim;
        return shim != null ? shim.readConcurrency() : this.readConcurrency;
    }

    @Override
    public long relationshipCount() {
        InitShim shim = this.initShim;
        return shim != null ? shim.relationshipCount() : this.relationshipCount;
    }

    @Override
    public ZonedDateTime creationTime() {
        InitShim shim = this.initShim;
        return shim != null ? shim.creationTime() : this.creationTime;
    }

    @Override
    public boolean validateRelationships() {
        InitShim shim = this.initShim;
        return shim != null ? shim.validateRelationships() : this.validateRelationships;
    }

    @Override
    public long nodeCount() {
        return this.nodeCount;
    }

    @Override
    public long averageDegree() {
        return this.averageDegree;
    }

    @Override
    public Aggregation aggregation() {
        InitShim shim = this.initShim;
        return shim != null ? shim.aggregation() : this.aggregation;
    }

    @Override
    public Orientation orientation() {
        InitShim shim = this.initShim;
        return shim != null ? shim.orientation() : this.orientation;
    }

    @Override
    public boolean allowSelfLoops() {
        InitShim shim = this.initShim;
        return shim != null ? shim.allowSelfLoops() : this.allowSelfLoops;
    }

    @Override
    public RelationshipDistribution relationshipDistribution() {
        InitShim shim = this.initShim;
        return shim != null ? shim.relationshipDistribution() : this.relationshipDistribution;
    }

    @Override
    @Nullable
    public Long relationshipSeed() {
        InitShim shim = this.initShim;
        return shim != null ? shim.relationshipSeed() : this.relationshipSeed;
    }

    @Override
    public NodeProjections nodeProjections() {
        InitShim shim = this.initShim;
        return shim != null ? shim.nodeProjections() : this.nodeProjections;
    }

    @Override
    public RelationshipType relationshipType() {
        InitShim shim = this.initShim;
        return shim != null ? shim.relationshipType() : this.relationshipType;
    }

    @Override
    public RelationshipProjections relationshipProjections() {
        InitShim shim = this.initShim;
        return shim != null ? shim.relationshipProjections() : this.relationshipProjections;
    }

    @Override
    public Set<String> outputFieldDenylist() {
        InitShim shim = this.initShim;
        return shim != null ? shim.outputFieldDenylist() : this.outputFieldDenylist;
    }

    public final ImmutableRandomGraphGeneratorConfig withUsernameOverride(@javax.annotation.Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.usernameOverride, newValue)) {
            return this;
        }
        return ImmutableRandomGraphGeneratorConfig.validate(new ImmutableRandomGraphGeneratorConfig(newValue, this.sudo, this.configKeys, this.jobId, this.username, this.graphName, this.readConcurrency, this.relationshipCount, this.validateRelationships, this.nodeCount, this.averageDegree, this.aggregation, this.orientation, this.allowSelfLoops, this.relationshipDistribution, this.relationshipSeed, this.nodeProjections, this.relationshipType, this.relationshipProjections));
    }

    public final ImmutableRandomGraphGeneratorConfig withUsernameOverride(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.usernameOverride, value)) {
            return this;
        }
        return ImmutableRandomGraphGeneratorConfig.validate(new ImmutableRandomGraphGeneratorConfig(value, this.sudo, this.configKeys, this.jobId, this.username, this.graphName, this.readConcurrency, this.relationshipCount, this.validateRelationships, this.nodeCount, this.averageDegree, this.aggregation, this.orientation, this.allowSelfLoops, this.relationshipDistribution, this.relationshipSeed, this.nodeProjections, this.relationshipType, this.relationshipProjections));
    }

    public final ImmutableRandomGraphGeneratorConfig withSudo(boolean value) {
        if (this.sudo == value) {
            return this;
        }
        return ImmutableRandomGraphGeneratorConfig.validate(new ImmutableRandomGraphGeneratorConfig(this.usernameOverride, value, this.configKeys, this.jobId, this.username, this.graphName, this.readConcurrency, this.relationshipCount, this.validateRelationships, this.nodeCount, this.averageDegree, this.aggregation, this.orientation, this.allowSelfLoops, this.relationshipDistribution, this.relationshipSeed, this.nodeProjections, this.relationshipType, this.relationshipProjections));
    }

    public final ImmutableRandomGraphGeneratorConfig withConfigKeys(Collection<String> value) {
        if (this.configKeys == value) {
            return this;
        }
        Collection<String> newValue = Objects.requireNonNull(value, "configKeys");
        return ImmutableRandomGraphGeneratorConfig.validate(new ImmutableRandomGraphGeneratorConfig(this.usernameOverride, this.sudo, newValue, this.jobId, this.username, this.graphName, this.readConcurrency, this.relationshipCount, this.validateRelationships, this.nodeCount, this.averageDegree, this.aggregation, this.orientation, this.allowSelfLoops, this.relationshipDistribution, this.relationshipSeed, this.nodeProjections, this.relationshipType, this.relationshipProjections));
    }

    public final ImmutableRandomGraphGeneratorConfig withJobId(JobId value) {
        if (this.jobId == value) {
            return this;
        }
        JobId newValue = Objects.requireNonNull(value, "jobId");
        return ImmutableRandomGraphGeneratorConfig.validate(new ImmutableRandomGraphGeneratorConfig(this.usernameOverride, this.sudo, this.configKeys, newValue, this.username, this.graphName, this.readConcurrency, this.relationshipCount, this.validateRelationships, this.nodeCount, this.averageDegree, this.aggregation, this.orientation, this.allowSelfLoops, this.relationshipDistribution, this.relationshipSeed, this.nodeProjections, this.relationshipType, this.relationshipProjections));
    }

    public final ImmutableRandomGraphGeneratorConfig withUsername(String value) {
        String newValue = Objects.requireNonNull(value, "username");
        if (this.username.equals(newValue)) {
            return this;
        }
        return ImmutableRandomGraphGeneratorConfig.validate(new ImmutableRandomGraphGeneratorConfig(this.usernameOverride, this.sudo, this.configKeys, this.jobId, newValue, this.graphName, this.readConcurrency, this.relationshipCount, this.validateRelationships, this.nodeCount, this.averageDegree, this.aggregation, this.orientation, this.allowSelfLoops, this.relationshipDistribution, this.relationshipSeed, this.nodeProjections, this.relationshipType, this.relationshipProjections));
    }

    public final ImmutableRandomGraphGeneratorConfig withGraphName(String value) {
        String newValue = Objects.requireNonNull(value, "graphName");
        if (this.graphName.equals(newValue)) {
            return this;
        }
        return ImmutableRandomGraphGeneratorConfig.validate(new ImmutableRandomGraphGeneratorConfig(this.usernameOverride, this.sudo, this.configKeys, this.jobId, this.username, newValue, this.readConcurrency, this.relationshipCount, this.validateRelationships, this.nodeCount, this.averageDegree, this.aggregation, this.orientation, this.allowSelfLoops, this.relationshipDistribution, this.relationshipSeed, this.nodeProjections, this.relationshipType, this.relationshipProjections));
    }

    public final ImmutableRandomGraphGeneratorConfig withReadConcurrency(int value) {
        if (this.readConcurrency == value) {
            return this;
        }
        return ImmutableRandomGraphGeneratorConfig.validate(new ImmutableRandomGraphGeneratorConfig(this.usernameOverride, this.sudo, this.configKeys, this.jobId, this.username, this.graphName, value, this.relationshipCount, this.validateRelationships, this.nodeCount, this.averageDegree, this.aggregation, this.orientation, this.allowSelfLoops, this.relationshipDistribution, this.relationshipSeed, this.nodeProjections, this.relationshipType, this.relationshipProjections));
    }

    public final ImmutableRandomGraphGeneratorConfig withRelationshipCount(long value) {
        if (this.relationshipCount == value) {
            return this;
        }
        return ImmutableRandomGraphGeneratorConfig.validate(new ImmutableRandomGraphGeneratorConfig(this.usernameOverride, this.sudo, this.configKeys, this.jobId, this.username, this.graphName, this.readConcurrency, value, this.validateRelationships, this.nodeCount, this.averageDegree, this.aggregation, this.orientation, this.allowSelfLoops, this.relationshipDistribution, this.relationshipSeed, this.nodeProjections, this.relationshipType, this.relationshipProjections));
    }

    public final ImmutableRandomGraphGeneratorConfig withValidateRelationships(boolean value) {
        if (this.validateRelationships == value) {
            return this;
        }
        return ImmutableRandomGraphGeneratorConfig.validate(new ImmutableRandomGraphGeneratorConfig(this.usernameOverride, this.sudo, this.configKeys, this.jobId, this.username, this.graphName, this.readConcurrency, this.relationshipCount, value, this.nodeCount, this.averageDegree, this.aggregation, this.orientation, this.allowSelfLoops, this.relationshipDistribution, this.relationshipSeed, this.nodeProjections, this.relationshipType, this.relationshipProjections));
    }

    public final ImmutableRandomGraphGeneratorConfig withNodeCount(long value) {
        if (this.nodeCount == value) {
            return this;
        }
        return ImmutableRandomGraphGeneratorConfig.validate(new ImmutableRandomGraphGeneratorConfig(this.usernameOverride, this.sudo, this.configKeys, this.jobId, this.username, this.graphName, this.readConcurrency, this.relationshipCount, this.validateRelationships, value, this.averageDegree, this.aggregation, this.orientation, this.allowSelfLoops, this.relationshipDistribution, this.relationshipSeed, this.nodeProjections, this.relationshipType, this.relationshipProjections));
    }

    public final ImmutableRandomGraphGeneratorConfig withAverageDegree(long value) {
        if (this.averageDegree == value) {
            return this;
        }
        return ImmutableRandomGraphGeneratorConfig.validate(new ImmutableRandomGraphGeneratorConfig(this.usernameOverride, this.sudo, this.configKeys, this.jobId, this.username, this.graphName, this.readConcurrency, this.relationshipCount, this.validateRelationships, this.nodeCount, value, this.aggregation, this.orientation, this.allowSelfLoops, this.relationshipDistribution, this.relationshipSeed, this.nodeProjections, this.relationshipType, this.relationshipProjections));
    }

    public final ImmutableRandomGraphGeneratorConfig withAggregation(Aggregation value) {
        if (this.aggregation == value) {
            return this;
        }
        Aggregation newValue = Objects.requireNonNull(value, "aggregation");
        if (this.aggregation.equals((Object)newValue)) {
            return this;
        }
        return ImmutableRandomGraphGeneratorConfig.validate(new ImmutableRandomGraphGeneratorConfig(this.usernameOverride, this.sudo, this.configKeys, this.jobId, this.username, this.graphName, this.readConcurrency, this.relationshipCount, this.validateRelationships, this.nodeCount, this.averageDegree, newValue, this.orientation, this.allowSelfLoops, this.relationshipDistribution, this.relationshipSeed, this.nodeProjections, this.relationshipType, this.relationshipProjections));
    }

    public final ImmutableRandomGraphGeneratorConfig withOrientation(Orientation value) {
        if (this.orientation == value) {
            return this;
        }
        Orientation newValue = Objects.requireNonNull(value, "orientation");
        if (this.orientation.equals((Object)newValue)) {
            return this;
        }
        return ImmutableRandomGraphGeneratorConfig.validate(new ImmutableRandomGraphGeneratorConfig(this.usernameOverride, this.sudo, this.configKeys, this.jobId, this.username, this.graphName, this.readConcurrency, this.relationshipCount, this.validateRelationships, this.nodeCount, this.averageDegree, this.aggregation, newValue, this.allowSelfLoops, this.relationshipDistribution, this.relationshipSeed, this.nodeProjections, this.relationshipType, this.relationshipProjections));
    }

    public final ImmutableRandomGraphGeneratorConfig withAllowSelfLoops(boolean value) {
        if (this.allowSelfLoops == value) {
            return this;
        }
        return ImmutableRandomGraphGeneratorConfig.validate(new ImmutableRandomGraphGeneratorConfig(this.usernameOverride, this.sudo, this.configKeys, this.jobId, this.username, this.graphName, this.readConcurrency, this.relationshipCount, this.validateRelationships, this.nodeCount, this.averageDegree, this.aggregation, this.orientation, value, this.relationshipDistribution, this.relationshipSeed, this.nodeProjections, this.relationshipType, this.relationshipProjections));
    }

    public final ImmutableRandomGraphGeneratorConfig withRelationshipDistribution(RelationshipDistribution value) {
        if (this.relationshipDistribution == value) {
            return this;
        }
        RelationshipDistribution newValue = Objects.requireNonNull(value, "relationshipDistribution");
        if (this.relationshipDistribution.equals((Object)newValue)) {
            return this;
        }
        return ImmutableRandomGraphGeneratorConfig.validate(new ImmutableRandomGraphGeneratorConfig(this.usernameOverride, this.sudo, this.configKeys, this.jobId, this.username, this.graphName, this.readConcurrency, this.relationshipCount, this.validateRelationships, this.nodeCount, this.averageDegree, this.aggregation, this.orientation, this.allowSelfLoops, newValue, this.relationshipSeed, this.nodeProjections, this.relationshipType, this.relationshipProjections));
    }

    public final ImmutableRandomGraphGeneratorConfig withRelationshipSeed(@Nullable Long value) {
        if (Objects.equals(this.relationshipSeed, value)) {
            return this;
        }
        return ImmutableRandomGraphGeneratorConfig.validate(new ImmutableRandomGraphGeneratorConfig(this.usernameOverride, this.sudo, this.configKeys, this.jobId, this.username, this.graphName, this.readConcurrency, this.relationshipCount, this.validateRelationships, this.nodeCount, this.averageDegree, this.aggregation, this.orientation, this.allowSelfLoops, this.relationshipDistribution, value, this.nodeProjections, this.relationshipType, this.relationshipProjections));
    }

    public final ImmutableRandomGraphGeneratorConfig withNodeProjections(NodeProjections value) {
        if (this.nodeProjections == value) {
            return this;
        }
        NodeProjections newValue = Objects.requireNonNull(value, "nodeProjections");
        return ImmutableRandomGraphGeneratorConfig.validate(new ImmutableRandomGraphGeneratorConfig(this.usernameOverride, this.sudo, this.configKeys, this.jobId, this.username, this.graphName, this.readConcurrency, this.relationshipCount, this.validateRelationships, this.nodeCount, this.averageDegree, this.aggregation, this.orientation, this.allowSelfLoops, this.relationshipDistribution, this.relationshipSeed, newValue, this.relationshipType, this.relationshipProjections));
    }

    public final ImmutableRandomGraphGeneratorConfig withRelationshipType(RelationshipType value) {
        if (this.relationshipType == value) {
            return this;
        }
        RelationshipType newValue = Objects.requireNonNull(value, "relationshipType");
        return ImmutableRandomGraphGeneratorConfig.validate(new ImmutableRandomGraphGeneratorConfig(this.usernameOverride, this.sudo, this.configKeys, this.jobId, this.username, this.graphName, this.readConcurrency, this.relationshipCount, this.validateRelationships, this.nodeCount, this.averageDegree, this.aggregation, this.orientation, this.allowSelfLoops, this.relationshipDistribution, this.relationshipSeed, this.nodeProjections, newValue, this.relationshipProjections));
    }

    public final ImmutableRandomGraphGeneratorConfig withRelationshipProjections(RelationshipProjections value) {
        if (this.relationshipProjections == value) {
            return this;
        }
        RelationshipProjections newValue = Objects.requireNonNull(value, "relationshipProjections");
        return ImmutableRandomGraphGeneratorConfig.validate(new ImmutableRandomGraphGeneratorConfig(this.usernameOverride, this.sudo, this.configKeys, this.jobId, this.username, this.graphName, this.readConcurrency, this.relationshipCount, this.validateRelationships, this.nodeCount, this.averageDegree, this.aggregation, this.orientation, this.allowSelfLoops, this.relationshipDistribution, this.relationshipSeed, this.nodeProjections, this.relationshipType, newValue));
    }

    public boolean equals(@javax.annotation.Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRandomGraphGeneratorConfig && this.equalTo((ImmutableRandomGraphGeneratorConfig)another);
    }

    private boolean equalTo(ImmutableRandomGraphGeneratorConfig another) {
        return Objects.equals(this.usernameOverride, another.usernameOverride) && this.sudo == another.sudo && this.jobId.equals(another.jobId) && this.username.equals(another.username) && this.graphName.equals(another.graphName) && this.readConcurrency == another.readConcurrency && this.relationshipCount == another.relationshipCount && this.validateRelationships == another.validateRelationships && this.nodeCount == another.nodeCount && this.averageDegree == another.averageDegree && this.aggregation.equals((Object)another.aggregation) && this.orientation.equals((Object)another.orientation) && this.allowSelfLoops == another.allowSelfLoops && this.relationshipDistribution.equals((Object)another.relationshipDistribution) && Objects.equals(this.relationshipSeed, another.relationshipSeed) && this.nodeProjections.equals((Object)another.nodeProjections) && this.relationshipType.equals((Object)another.relationshipType) && this.relationshipProjections.equals((Object)another.relationshipProjections) && this.outputFieldDenylist.equals(another.outputFieldDenylist);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.usernameOverride);
        h += (h << 5) + Boolean.hashCode(this.sudo);
        h += (h << 5) + this.jobId.hashCode();
        h += (h << 5) + this.username.hashCode();
        h += (h << 5) + this.graphName.hashCode();
        h += (h << 5) + this.readConcurrency;
        h += (h << 5) + Long.hashCode(this.relationshipCount);
        h += (h << 5) + Boolean.hashCode(this.validateRelationships);
        h += (h << 5) + Long.hashCode(this.nodeCount);
        h += (h << 5) + Long.hashCode(this.averageDegree);
        h += (h << 5) + this.aggregation.hashCode();
        h += (h << 5) + this.orientation.hashCode();
        h += (h << 5) + Boolean.hashCode(this.allowSelfLoops);
        h += (h << 5) + this.relationshipDistribution.hashCode();
        h += (h << 5) + Objects.hashCode(this.relationshipSeed);
        h += (h << 5) + this.nodeProjections.hashCode();
        h += (h << 5) + this.relationshipType.hashCode();
        h += (h << 5) + this.relationshipProjections.hashCode();
        h += (h << 5) + this.outputFieldDenylist.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("RandomGraphGeneratorConfig{");
        if (this.usernameOverride != null) {
            builder.append("usernameOverride=").append(this.usernameOverride);
        }
        if (builder.length() > 27) {
            builder.append(", ");
        }
        builder.append("sudo=").append(this.sudo);
        builder.append(", ");
        builder.append("jobId=").append(this.jobId);
        builder.append(", ");
        builder.append("username=").append(this.username);
        builder.append(", ");
        builder.append("graphName=").append(this.graphName);
        builder.append(", ");
        builder.append("readConcurrency=").append(this.readConcurrency);
        builder.append(", ");
        builder.append("relationshipCount=").append(this.relationshipCount);
        builder.append(", ");
        builder.append("validateRelationships=").append(this.validateRelationships);
        builder.append(", ");
        builder.append("nodeCount=").append(this.nodeCount);
        builder.append(", ");
        builder.append("averageDegree=").append(this.averageDegree);
        builder.append(", ");
        builder.append("aggregation=").append(this.aggregation);
        builder.append(", ");
        builder.append("orientation=").append(this.orientation);
        builder.append(", ");
        builder.append("allowSelfLoops=").append(this.allowSelfLoops);
        builder.append(", ");
        builder.append("relationshipDistribution=").append((Object)this.relationshipDistribution);
        if (this.relationshipSeed != null) {
            builder.append(", ");
            builder.append("relationshipSeed=").append(this.relationshipSeed);
        }
        builder.append(", ");
        builder.append("nodeProjections=").append(this.nodeProjections);
        builder.append(", ");
        builder.append("relationshipType=").append(this.relationshipType);
        builder.append(", ");
        builder.append("relationshipProjections=").append(this.relationshipProjections);
        builder.append(", ");
        builder.append("outputFieldDenylist=").append(this.outputFieldDenylist);
        return builder.append("}").toString();
    }

    public static RandomGraphGeneratorConfig of(String username, String graphName, long nodeCount, long averageDegree, Aggregation aggregation, Orientation orientation, boolean allowSelfLoops, RelationshipDistribution relationshipDistribution, @Nullable Long relationshipSeed, NodeProjections nodeProjections, RelationshipType relationshipType, RelationshipProjections relationshipProjections) {
        return ImmutableRandomGraphGeneratorConfig.validate(new ImmutableRandomGraphGeneratorConfig(username, graphName, nodeCount, averageDegree, aggregation, orientation, allowSelfLoops, relationshipDistribution, relationshipSeed, nodeProjections, relationshipType, relationshipProjections));
    }

    private static ImmutableRandomGraphGeneratorConfig validate(ImmutableRandomGraphGeneratorConfig instance) {
        instance.validateReadConcurrency();
        return instance;
    }

    public static RandomGraphGeneratorConfig copyOf(RandomGraphGeneratorConfig instance) {
        if (instance instanceof ImmutableRandomGraphGeneratorConfig) {
            return (ImmutableRandomGraphGeneratorConfig)instance;
        }
        return ImmutableRandomGraphGeneratorConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="RandomGraphGeneratorConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_GRAPH_NAME = 1L;
        private static final long INIT_BIT_NODE_COUNT = 2L;
        private static final long INIT_BIT_AVERAGE_DEGREE = 4L;
        private static final long OPT_BIT_SUDO = 1L;
        private static final long OPT_BIT_READ_CONCURRENCY = 2L;
        private static final long OPT_BIT_RELATIONSHIP_COUNT = 4L;
        private static final long OPT_BIT_VALIDATE_RELATIONSHIPS = 8L;
        private static final long OPT_BIT_ALLOW_SELF_LOOPS = 16L;
        private static final long OPT_BIT_RELATIONSHIP_SEED = 32L;
        private long initBits = 7L;
        private long optBits;
        @javax.annotation.Nullable
        private String usernameOverride;
        private boolean sudo;
        @javax.annotation.Nullable
        private Collection<String> configKeys;
        @javax.annotation.Nullable
        private JobId jobId;
        @javax.annotation.Nullable
        private String username;
        @javax.annotation.Nullable
        private String graphName;
        private int readConcurrency;
        private long relationshipCount;
        private boolean validateRelationships;
        private long nodeCount;
        private long averageDegree;
        @javax.annotation.Nullable
        private Aggregation aggregation;
        @javax.annotation.Nullable
        private Orientation orientation;
        private boolean allowSelfLoops;
        @javax.annotation.Nullable
        private RelationshipDistribution relationshipDistribution;
        @javax.annotation.Nullable
        private Long relationshipSeed;
        @javax.annotation.Nullable
        private NodeProjections nodeProjections;
        @javax.annotation.Nullable
        private RelationshipType relationshipType;
        @javax.annotation.Nullable
        private RelationshipProjections relationshipProjections;

        private Builder() {
        }

        public final Builder from(GraphProjectConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(JobIdConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(RandomGraphGeneratorConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            JobIdConfig instance;
            long bits = 0L;
            if (object instanceof GraphProjectConfig) {
                instance = (GraphProjectConfig)object;
                this.graphName(instance.graphName());
                if ((bits & 1L) == 0L) {
                    this.nodeCount(instance.nodeCount());
                    bits |= 1L;
                }
                this.readConcurrency(instance.readConcurrency());
                this.validateRelationships(instance.validateRelationships());
                this.relationshipCount(instance.relationshipCount());
                this.username(instance.username());
            }
            if (object instanceof JobIdConfig) {
                instance = (JobIdConfig)object;
                this.jobId(instance.jobId());
            }
            if (object instanceof RandomGraphGeneratorConfig) {
                instance = (RandomGraphGeneratorConfig)object;
                this.orientation(instance.orientation());
                this.allowSelfLoops(instance.allowSelfLoops());
                this.relationshipType(instance.relationshipType());
                this.averageDegree(instance.averageDegree());
                this.nodeProjections(instance.nodeProjections());
                this.aggregation(instance.aggregation());
                if ((bits & 1L) == 0L) {
                    this.nodeCount(instance.nodeCount());
                    bits |= 1L;
                }
                this.relationshipProjections(instance.relationshipProjections());
                this.relationshipDistribution(instance.relationshipDistribution());
                @Nullable Long relationshipSeedValue = instance.relationshipSeed();
                if (relationshipSeedValue != null) {
                    this.relationshipSeed(relationshipSeedValue);
                }
            }
            if (object instanceof BaseConfig) {
                instance = (BaseConfig)object;
                Optional usernameOverrideOptional = instance.usernameOverride();
                if (usernameOverrideOptional.isPresent()) {
                    this.usernameOverride(usernameOverrideOptional);
                }
                this.configKeys(instance.configKeys());
                this.sudo(instance.sudo());
            }
        }

        public final Builder usernameOverride(@javax.annotation.Nullable String usernameOverride) {
            this.usernameOverride = usernameOverride;
            return this;
        }

        public final Builder usernameOverride(Optional<String> usernameOverride) {
            this.usernameOverride = usernameOverride.orElse(null);
            return this;
        }

        public final Builder sudo(boolean sudo) {
            this.sudo = sudo;
            this.optBits |= 1L;
            return this;
        }

        public final Builder configKeys(Collection<String> configKeys) {
            this.configKeys = Objects.requireNonNull(configKeys, "configKeys");
            return this;
        }

        public final Builder jobId(JobId jobId) {
            this.jobId = Objects.requireNonNull(jobId, "jobId");
            return this;
        }

        public final Builder username(String username) {
            this.username = Objects.requireNonNull(username, "username");
            return this;
        }

        public final Builder graphName(String graphName) {
            this.graphName = Objects.requireNonNull(graphName, "graphName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder readConcurrency(int readConcurrency) {
            this.readConcurrency = readConcurrency;
            this.optBits |= 2L;
            return this;
        }

        public final Builder relationshipCount(long relationshipCount) {
            this.relationshipCount = relationshipCount;
            this.optBits |= 4L;
            return this;
        }

        public final Builder validateRelationships(boolean validateRelationships) {
            this.validateRelationships = validateRelationships;
            this.optBits |= 8L;
            return this;
        }

        public final Builder nodeCount(long nodeCount) {
            this.nodeCount = nodeCount;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder averageDegree(long averageDegree) {
            this.averageDegree = averageDegree;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder aggregation(Aggregation aggregation) {
            this.aggregation = Objects.requireNonNull(aggregation, "aggregation");
            return this;
        }

        public final Builder orientation(Orientation orientation) {
            this.orientation = Objects.requireNonNull(orientation, "orientation");
            return this;
        }

        public final Builder allowSelfLoops(boolean allowSelfLoops) {
            this.allowSelfLoops = allowSelfLoops;
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder relationshipDistribution(RelationshipDistribution relationshipDistribution) {
            this.relationshipDistribution = Objects.requireNonNull(relationshipDistribution, "relationshipDistribution");
            return this;
        }

        public final Builder relationshipSeed(@Nullable Long relationshipSeed) {
            this.relationshipSeed = relationshipSeed;
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder nodeProjections(NodeProjections nodeProjections) {
            this.nodeProjections = Objects.requireNonNull(nodeProjections, "nodeProjections");
            return this;
        }

        public final Builder relationshipType(RelationshipType relationshipType) {
            this.relationshipType = Objects.requireNonNull(relationshipType, "relationshipType");
            return this;
        }

        public final Builder relationshipProjections(RelationshipProjections relationshipProjections) {
            this.relationshipProjections = Objects.requireNonNull(relationshipProjections, "relationshipProjections");
            return this;
        }

        public Builder clear() {
            this.initBits = 7L;
            this.optBits = 0L;
            this.usernameOverride = null;
            this.sudo = false;
            this.configKeys = null;
            this.jobId = null;
            this.username = null;
            this.graphName = null;
            this.readConcurrency = 0;
            this.relationshipCount = 0L;
            this.validateRelationships = false;
            this.nodeCount = 0L;
            this.averageDegree = 0L;
            this.aggregation = null;
            this.orientation = null;
            this.allowSelfLoops = false;
            this.relationshipDistribution = null;
            this.relationshipSeed = null;
            this.nodeProjections = null;
            this.relationshipType = null;
            this.relationshipProjections = null;
            return this;
        }

        public RandomGraphGeneratorConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableRandomGraphGeneratorConfig.validate(new ImmutableRandomGraphGeneratorConfig(this));
        }

        private boolean sudoIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean readConcurrencyIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean relationshipCountIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean validateRelationshipsIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean allowSelfLoopsIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean relationshipSeedIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("graphName");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("nodeCount");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("averageDegree");
            }
            return "Cannot build RandomGraphGeneratorConfig, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="RandomGraphGeneratorConfig", generator="Immutables")
    private final class InitShim {
        private byte sudoBuildStage = 0;
        private boolean sudo;
        private byte configKeysBuildStage = 0;
        private Collection<String> configKeys;
        private byte toMapBuildStage = 0;
        private Map<String, Object> toMap;
        private byte jobIdBuildStage = 0;
        private JobId jobId;
        private byte usernameBuildStage = 0;
        private String username;
        private byte readConcurrencyBuildStage = 0;
        private int readConcurrency;
        private byte relationshipCountBuildStage = 0;
        private long relationshipCount;
        private byte creationTimeBuildStage = 0;
        private ZonedDateTime creationTime;
        private byte validateRelationshipsBuildStage = 0;
        private boolean validateRelationships;
        private byte aggregationBuildStage = 0;
        private Aggregation aggregation;
        private byte orientationBuildStage = 0;
        private Orientation orientation;
        private byte allowSelfLoopsBuildStage = 0;
        private boolean allowSelfLoops;
        private byte relationshipDistributionBuildStage = 0;
        private RelationshipDistribution relationshipDistribution;
        private byte relationshipSeedBuildStage = 0;
        private Long relationshipSeed;
        private byte nodeProjectionsBuildStage = 0;
        private NodeProjections nodeProjections;
        private byte relationshipTypeBuildStage = 0;
        private RelationshipType relationshipType;
        private byte relationshipProjectionsBuildStage = 0;
        private RelationshipProjections relationshipProjections;
        private byte outputFieldDenylistBuildStage = 0;
        private Set<String> outputFieldDenylist;

        private InitShim() {
        }

        boolean sudo() {
            if (this.sudoBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sudoBuildStage == 0) {
                this.sudoBuildStage = (byte)-1;
                this.sudo = ImmutableRandomGraphGeneratorConfig.this.sudoInitialize();
                this.sudoBuildStage = 1;
            }
            return this.sudo;
        }

        void sudo(boolean sudo) {
            this.sudo = sudo;
            this.sudoBuildStage = 1;
        }

        Collection<String> configKeys() {
            if (this.configKeysBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.configKeysBuildStage == 0) {
                this.configKeysBuildStage = (byte)-1;
                this.configKeys = Objects.requireNonNull(ImmutableRandomGraphGeneratorConfig.this.configKeysInitialize(), "configKeys");
                this.configKeysBuildStage = 1;
            }
            return this.configKeys;
        }

        void configKeys(Collection<String> configKeys) {
            this.configKeys = configKeys;
            this.configKeysBuildStage = 1;
        }

        Map<String, Object> toMap() {
            if (this.toMapBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.toMapBuildStage == 0) {
                this.toMapBuildStage = (byte)-1;
                this.toMap = Objects.requireNonNull(ImmutableRandomGraphGeneratorConfig.this.toMapInitialize(), "toMap");
                this.toMapBuildStage = 1;
            }
            return this.toMap;
        }

        JobId jobId() {
            if (this.jobIdBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.jobIdBuildStage == 0) {
                this.jobIdBuildStage = (byte)-1;
                this.jobId = Objects.requireNonNull(ImmutableRandomGraphGeneratorConfig.this.jobIdInitialize(), "jobId");
                this.jobIdBuildStage = 1;
            }
            return this.jobId;
        }

        void jobId(JobId jobId) {
            this.jobId = jobId;
            this.jobIdBuildStage = 1;
        }

        String username() {
            if (this.usernameBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.usernameBuildStage == 0) {
                this.usernameBuildStage = (byte)-1;
                this.username = Objects.requireNonNull(ImmutableRandomGraphGeneratorConfig.this.usernameInitialize(), "username");
                this.usernameBuildStage = 1;
            }
            return this.username;
        }

        void username(String username) {
            this.username = username;
            this.usernameBuildStage = 1;
        }

        int readConcurrency() {
            if (this.readConcurrencyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.readConcurrencyBuildStage == 0) {
                this.readConcurrencyBuildStage = (byte)-1;
                this.readConcurrency = ImmutableRandomGraphGeneratorConfig.this.readConcurrencyInitialize();
                this.readConcurrencyBuildStage = 1;
            }
            return this.readConcurrency;
        }

        void readConcurrency(int readConcurrency) {
            this.readConcurrency = readConcurrency;
            this.readConcurrencyBuildStage = 1;
        }

        long relationshipCount() {
            if (this.relationshipCountBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relationshipCountBuildStage == 0) {
                this.relationshipCountBuildStage = (byte)-1;
                this.relationshipCount = ImmutableRandomGraphGeneratorConfig.this.relationshipCountInitialize();
                this.relationshipCountBuildStage = 1;
            }
            return this.relationshipCount;
        }

        void relationshipCount(long relationshipCount) {
            this.relationshipCount = relationshipCount;
            this.relationshipCountBuildStage = 1;
        }

        ZonedDateTime creationTime() {
            if (this.creationTimeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.creationTimeBuildStage == 0) {
                this.creationTimeBuildStage = (byte)-1;
                this.creationTime = Objects.requireNonNull(ImmutableRandomGraphGeneratorConfig.this.creationTimeInitialize(), "creationTime");
                this.creationTimeBuildStage = 1;
            }
            return this.creationTime;
        }

        boolean validateRelationships() {
            if (this.validateRelationshipsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.validateRelationshipsBuildStage == 0) {
                this.validateRelationshipsBuildStage = (byte)-1;
                this.validateRelationships = ImmutableRandomGraphGeneratorConfig.this.validateRelationshipsInitialize();
                this.validateRelationshipsBuildStage = 1;
            }
            return this.validateRelationships;
        }

        void validateRelationships(boolean validateRelationships) {
            this.validateRelationships = validateRelationships;
            this.validateRelationshipsBuildStage = 1;
        }

        Aggregation aggregation() {
            if (this.aggregationBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.aggregationBuildStage == 0) {
                this.aggregationBuildStage = (byte)-1;
                this.aggregation = Objects.requireNonNull(ImmutableRandomGraphGeneratorConfig.this.aggregationInitialize(), "aggregation");
                this.aggregationBuildStage = 1;
            }
            return this.aggregation;
        }

        void aggregation(Aggregation aggregation) {
            this.aggregation = aggregation;
            this.aggregationBuildStage = 1;
        }

        Orientation orientation() {
            if (this.orientationBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.orientationBuildStage == 0) {
                this.orientationBuildStage = (byte)-1;
                this.orientation = Objects.requireNonNull(ImmutableRandomGraphGeneratorConfig.this.orientationInitialize(), "orientation");
                this.orientationBuildStage = 1;
            }
            return this.orientation;
        }

        void orientation(Orientation orientation) {
            this.orientation = orientation;
            this.orientationBuildStage = 1;
        }

        boolean allowSelfLoops() {
            if (this.allowSelfLoopsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.allowSelfLoopsBuildStage == 0) {
                this.allowSelfLoopsBuildStage = (byte)-1;
                this.allowSelfLoops = ImmutableRandomGraphGeneratorConfig.this.allowSelfLoopsInitialize();
                this.allowSelfLoopsBuildStage = 1;
            }
            return this.allowSelfLoops;
        }

        void allowSelfLoops(boolean allowSelfLoops) {
            this.allowSelfLoops = allowSelfLoops;
            this.allowSelfLoopsBuildStage = 1;
        }

        RelationshipDistribution relationshipDistribution() {
            if (this.relationshipDistributionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relationshipDistributionBuildStage == 0) {
                this.relationshipDistributionBuildStage = (byte)-1;
                this.relationshipDistribution = Objects.requireNonNull(ImmutableRandomGraphGeneratorConfig.this.relationshipDistributionInitialize(), "relationshipDistribution");
                this.relationshipDistributionBuildStage = 1;
            }
            return this.relationshipDistribution;
        }

        void relationshipDistribution(RelationshipDistribution relationshipDistribution) {
            this.relationshipDistribution = relationshipDistribution;
            this.relationshipDistributionBuildStage = 1;
        }

        Long relationshipSeed() {
            if (this.relationshipSeedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relationshipSeedBuildStage == 0) {
                this.relationshipSeedBuildStage = (byte)-1;
                this.relationshipSeed = ImmutableRandomGraphGeneratorConfig.this.relationshipSeedInitialize();
                this.relationshipSeedBuildStage = 1;
            }
            return this.relationshipSeed;
        }

        void relationshipSeed(Long relationshipSeed) {
            this.relationshipSeed = relationshipSeed;
            this.relationshipSeedBuildStage = 1;
        }

        NodeProjections nodeProjections() {
            if (this.nodeProjectionsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nodeProjectionsBuildStage == 0) {
                this.nodeProjectionsBuildStage = (byte)-1;
                this.nodeProjections = Objects.requireNonNull(ImmutableRandomGraphGeneratorConfig.this.nodeProjectionsInitialize(), "nodeProjections");
                this.nodeProjectionsBuildStage = 1;
            }
            return this.nodeProjections;
        }

        void nodeProjections(NodeProjections nodeProjections) {
            this.nodeProjections = nodeProjections;
            this.nodeProjectionsBuildStage = 1;
        }

        RelationshipType relationshipType() {
            if (this.relationshipTypeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relationshipTypeBuildStage == 0) {
                this.relationshipTypeBuildStage = (byte)-1;
                this.relationshipType = Objects.requireNonNull(ImmutableRandomGraphGeneratorConfig.this.relationshipTypeInitialize(), "relationshipType");
                this.relationshipTypeBuildStage = 1;
            }
            return this.relationshipType;
        }

        void relationshipType(RelationshipType relationshipType) {
            this.relationshipType = relationshipType;
            this.relationshipTypeBuildStage = 1;
        }

        RelationshipProjections relationshipProjections() {
            if (this.relationshipProjectionsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relationshipProjectionsBuildStage == 0) {
                this.relationshipProjectionsBuildStage = (byte)-1;
                this.relationshipProjections = Objects.requireNonNull(ImmutableRandomGraphGeneratorConfig.this.relationshipProjectionsInitialize(), "relationshipProjections");
                this.relationshipProjectionsBuildStage = 1;
            }
            return this.relationshipProjections;
        }

        void relationshipProjections(RelationshipProjections relationshipProjections) {
            this.relationshipProjections = relationshipProjections;
            this.relationshipProjectionsBuildStage = 1;
        }

        Set<String> outputFieldDenylist() {
            if (this.outputFieldDenylistBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.outputFieldDenylistBuildStage == 0) {
                this.outputFieldDenylistBuildStage = (byte)-1;
                this.outputFieldDenylist = Objects.requireNonNull(ImmutableRandomGraphGeneratorConfig.this.outputFieldDenylistInitialize(), "outputFieldDenylist");
                this.outputFieldDenylistBuildStage = 1;
            }
            return this.outputFieldDenylist;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.sudoBuildStage == -1) {
                attributes.add("sudo");
            }
            if (this.configKeysBuildStage == -1) {
                attributes.add("configKeys");
            }
            if (this.toMapBuildStage == -1) {
                attributes.add("toMap");
            }
            if (this.jobIdBuildStage == -1) {
                attributes.add("jobId");
            }
            if (this.usernameBuildStage == -1) {
                attributes.add("username");
            }
            if (this.readConcurrencyBuildStage == -1) {
                attributes.add("readConcurrency");
            }
            if (this.relationshipCountBuildStage == -1) {
                attributes.add("relationshipCount");
            }
            if (this.creationTimeBuildStage == -1) {
                attributes.add("creationTime");
            }
            if (this.validateRelationshipsBuildStage == -1) {
                attributes.add("validateRelationships");
            }
            if (this.aggregationBuildStage == -1) {
                attributes.add("aggregation");
            }
            if (this.orientationBuildStage == -1) {
                attributes.add("orientation");
            }
            if (this.allowSelfLoopsBuildStage == -1) {
                attributes.add("allowSelfLoops");
            }
            if (this.relationshipDistributionBuildStage == -1) {
                attributes.add("relationshipDistribution");
            }
            if (this.relationshipSeedBuildStage == -1) {
                attributes.add("relationshipSeed");
            }
            if (this.nodeProjectionsBuildStage == -1) {
                attributes.add("nodeProjections");
            }
            if (this.relationshipTypeBuildStage == -1) {
                attributes.add("relationshipType");
            }
            if (this.relationshipProjectionsBuildStage == -1) {
                attributes.add("relationshipProjections");
            }
            if (this.outputFieldDenylistBuildStage == -1) {
                attributes.add("outputFieldDenylist");
            }
            return "Cannot build RandomGraphGeneratorConfig, attribute initializers form cycle " + attributes;
        }
    }
}

