/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.config;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.GraphStreamRelationshipsConfig;

@ParametersAreNonnullByDefault
@Generated(from="GraphStreamRelationshipsConfig", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableGraphStreamRelationshipsConfig
implements GraphStreamRelationshipsConfig {
    @Nullable
    private final String usernameOverride;
    private final boolean sudo;
    private final Collection<String> configKeys;
    private final transient Map<String, Object> toMap;
    @Nullable
    private final String graphName;
    private final List<String> relationshipTypes;
    private final int concurrency;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableGraphStreamRelationshipsConfig(Optional<String> graphName, Iterable<String> relationshipTypes, int concurrency) {
        this.graphName = graphName.orElse(null);
        this.initShim.relationshipTypes(ImmutableGraphStreamRelationshipsConfig.createUnmodifiableList(false, ImmutableGraphStreamRelationshipsConfig.createSafeList(relationshipTypes, true, false)));
        this.initShim.concurrency(concurrency);
        this.usernameOverride = null;
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.concurrency = this.initShim.concurrency();
        this.initShim = null;
    }

    private ImmutableGraphStreamRelationshipsConfig(@Nullable String graphName, Iterable<String> relationshipTypes, int concurrency) {
        this.graphName = graphName;
        this.initShim.relationshipTypes(ImmutableGraphStreamRelationshipsConfig.createUnmodifiableList(false, ImmutableGraphStreamRelationshipsConfig.createSafeList(relationshipTypes, true, false)));
        this.initShim.concurrency(concurrency);
        this.usernameOverride = null;
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.concurrency = this.initShim.concurrency();
        this.initShim = null;
    }

    private ImmutableGraphStreamRelationshipsConfig(Builder builder) {
        this.usernameOverride = builder.usernameOverride;
        this.graphName = builder.graphName;
        if (builder.sudoIsSet()) {
            this.initShim.sudo(builder.sudo);
        }
        if (builder.configKeys != null) {
            this.initShim.configKeys(builder.configKeys);
        }
        if (builder.relationshipTypesIsSet()) {
            this.initShim.relationshipTypes(builder.relationshipTypes == null ? Collections.emptyList() : ImmutableGraphStreamRelationshipsConfig.createUnmodifiableList(true, builder.relationshipTypes));
        }
        if (builder.concurrencyIsSet()) {
            this.initShim.concurrency(builder.concurrency);
        }
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.concurrency = this.initShim.concurrency();
        this.initShim = null;
    }

    private ImmutableGraphStreamRelationshipsConfig(@Nullable String usernameOverride, boolean sudo, Collection<String> configKeys, @Nullable String graphName, List<String> relationshipTypes, int concurrency) {
        this.usernameOverride = usernameOverride;
        this.initShim.sudo(sudo);
        this.initShim.configKeys(configKeys);
        this.graphName = graphName;
        this.initShim.relationshipTypes(relationshipTypes);
        this.initShim.concurrency(concurrency);
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.concurrency = this.initShim.concurrency();
        this.initShim = null;
    }

    private boolean sudoInitialize() {
        return GraphStreamRelationshipsConfig.super.sudo();
    }

    private Collection<String> configKeysInitialize() {
        return GraphStreamRelationshipsConfig.super.configKeys();
    }

    private Map<String, Object> toMapInitialize() {
        return GraphStreamRelationshipsConfig.super.toMap();
    }

    private List<String> relationshipTypesInitialize() {
        return GraphStreamRelationshipsConfig.super.relationshipTypes();
    }

    private int concurrencyInitialize() {
        return GraphStreamRelationshipsConfig.super.concurrency();
    }

    public Optional<String> usernameOverride() {
        return Optional.ofNullable(this.usernameOverride);
    }

    public boolean sudo() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sudo() : this.sudo;
    }

    public Collection<String> configKeys() {
        InitShim shim = this.initShim;
        return shim != null ? shim.configKeys() : this.configKeys;
    }

    public Map<String, Object> toMap() {
        InitShim shim = this.initShim;
        return shim != null ? shim.toMap() : this.toMap;
    }

    @Override
    public Optional<String> graphName() {
        return Optional.ofNullable(this.graphName);
    }

    @Override
    public List<String> relationshipTypes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.relationshipTypes() : this.relationshipTypes;
    }

    @Override
    public int concurrency() {
        InitShim shim = this.initShim;
        return shim != null ? shim.concurrency() : this.concurrency;
    }

    public final ImmutableGraphStreamRelationshipsConfig withUsernameOverride(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.usernameOverride, newValue)) {
            return this;
        }
        return new ImmutableGraphStreamRelationshipsConfig(newValue, this.sudo, this.configKeys, this.graphName, this.relationshipTypes, this.concurrency);
    }

    public final ImmutableGraphStreamRelationshipsConfig withUsernameOverride(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.usernameOverride, value)) {
            return this;
        }
        return new ImmutableGraphStreamRelationshipsConfig(value, this.sudo, this.configKeys, this.graphName, this.relationshipTypes, this.concurrency);
    }

    public final ImmutableGraphStreamRelationshipsConfig withSudo(boolean value) {
        if (this.sudo == value) {
            return this;
        }
        return new ImmutableGraphStreamRelationshipsConfig(this.usernameOverride, value, this.configKeys, this.graphName, this.relationshipTypes, this.concurrency);
    }

    public final ImmutableGraphStreamRelationshipsConfig withConfigKeys(Collection<String> value) {
        if (this.configKeys == value) {
            return this;
        }
        Collection<String> newValue = Objects.requireNonNull(value, "configKeys");
        return new ImmutableGraphStreamRelationshipsConfig(this.usernameOverride, this.sudo, newValue, this.graphName, this.relationshipTypes, this.concurrency);
    }

    public final ImmutableGraphStreamRelationshipsConfig withGraphName(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.graphName, newValue)) {
            return this;
        }
        return new ImmutableGraphStreamRelationshipsConfig(this.usernameOverride, this.sudo, this.configKeys, newValue, this.relationshipTypes, this.concurrency);
    }

    public final ImmutableGraphStreamRelationshipsConfig withGraphName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.graphName, value)) {
            return this;
        }
        return new ImmutableGraphStreamRelationshipsConfig(this.usernameOverride, this.sudo, this.configKeys, value, this.relationshipTypes, this.concurrency);
    }

    public final ImmutableGraphStreamRelationshipsConfig withRelationshipTypes(String ... elements) {
        List<String> newValue = ImmutableGraphStreamRelationshipsConfig.createUnmodifiableList(false, ImmutableGraphStreamRelationshipsConfig.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableGraphStreamRelationshipsConfig(this.usernameOverride, this.sudo, this.configKeys, this.graphName, newValue, this.concurrency);
    }

    public final ImmutableGraphStreamRelationshipsConfig withRelationshipTypes(Iterable<String> elements) {
        if (this.relationshipTypes == elements) {
            return this;
        }
        List<String> newValue = ImmutableGraphStreamRelationshipsConfig.createUnmodifiableList(false, ImmutableGraphStreamRelationshipsConfig.createSafeList(elements, true, false));
        return new ImmutableGraphStreamRelationshipsConfig(this.usernameOverride, this.sudo, this.configKeys, this.graphName, newValue, this.concurrency);
    }

    public final ImmutableGraphStreamRelationshipsConfig withConcurrency(int value) {
        if (this.concurrency == value) {
            return this;
        }
        return new ImmutableGraphStreamRelationshipsConfig(this.usernameOverride, this.sudo, this.configKeys, this.graphName, this.relationshipTypes, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGraphStreamRelationshipsConfig && this.equalTo((ImmutableGraphStreamRelationshipsConfig)another);
    }

    private boolean equalTo(ImmutableGraphStreamRelationshipsConfig another) {
        return Objects.equals(this.usernameOverride, another.usernameOverride) && this.sudo == another.sudo && Objects.equals(this.graphName, another.graphName) && this.relationshipTypes.equals(another.relationshipTypes) && this.concurrency == another.concurrency;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.usernameOverride);
        h += (h << 5) + Boolean.hashCode(this.sudo);
        h += (h << 5) + Objects.hashCode(this.graphName);
        h += (h << 5) + this.relationshipTypes.hashCode();
        h += (h << 5) + this.concurrency;
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("GraphStreamRelationshipsConfig{");
        if (this.usernameOverride != null) {
            builder.append("usernameOverride=").append(this.usernameOverride);
        }
        if (builder.length() > 31) {
            builder.append(", ");
        }
        builder.append("sudo=").append(this.sudo);
        if (this.graphName != null) {
            builder.append(", ");
            builder.append("graphName=").append(this.graphName);
        }
        builder.append(", ");
        builder.append("relationshipTypes=").append(this.relationshipTypes);
        builder.append(", ");
        builder.append("concurrency=").append(this.concurrency);
        return builder.append("}").toString();
    }

    public static GraphStreamRelationshipsConfig of(Optional<String> graphName, List<String> relationshipTypes, int concurrency) {
        return ImmutableGraphStreamRelationshipsConfig.of(graphName, relationshipTypes, concurrency);
    }

    public static GraphStreamRelationshipsConfig of(Optional<String> graphName, Iterable<String> relationshipTypes, int concurrency) {
        return new ImmutableGraphStreamRelationshipsConfig(graphName, relationshipTypes, concurrency);
    }

    public static GraphStreamRelationshipsConfig of(@Nullable String graphName, Iterable<String> relationshipTypes, int concurrency) {
        return new ImmutableGraphStreamRelationshipsConfig(graphName, relationshipTypes, concurrency);
    }

    public static GraphStreamRelationshipsConfig copyOf(GraphStreamRelationshipsConfig instance) {
        if (instance instanceof ImmutableGraphStreamRelationshipsConfig) {
            return (ImmutableGraphStreamRelationshipsConfig)instance;
        }
        return ImmutableGraphStreamRelationshipsConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="GraphStreamRelationshipsConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_SUDO = 1L;
        private static final long OPT_BIT_RELATIONSHIP_TYPES = 2L;
        private static final long OPT_BIT_CONCURRENCY = 4L;
        private long optBits;
        @Nullable
        private String usernameOverride;
        private boolean sudo;
        @Nullable
        private Collection<String> configKeys;
        @Nullable
        private String graphName;
        private List<String> relationshipTypes = null;
        private int concurrency;

        private Builder() {
        }

        public final Builder from(GraphStreamRelationshipsConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GraphStreamRelationshipsConfig instance;
            if (object instanceof GraphStreamRelationshipsConfig) {
                instance = (GraphStreamRelationshipsConfig)object;
                this.addAllRelationshipTypes(instance.relationshipTypes());
                Optional<String> graphNameOptional = instance.graphName();
                if (graphNameOptional.isPresent()) {
                    this.graphName(graphNameOptional);
                }
                this.concurrency(instance.concurrency());
            }
            if (object instanceof BaseConfig) {
                instance = (BaseConfig)object;
                Optional usernameOverrideOptional = instance.usernameOverride();
                if (usernameOverrideOptional.isPresent()) {
                    this.usernameOverride(usernameOverrideOptional);
                }
                this.configKeys(instance.configKeys());
                this.sudo(instance.sudo());
            }
        }

        public final Builder usernameOverride(@Nullable String usernameOverride) {
            this.usernameOverride = usernameOverride;
            return this;
        }

        public final Builder usernameOverride(Optional<String> usernameOverride) {
            this.usernameOverride = usernameOverride.orElse(null);
            return this;
        }

        public final Builder sudo(boolean sudo) {
            this.sudo = sudo;
            this.optBits |= 1L;
            return this;
        }

        public final Builder configKeys(Collection<String> configKeys) {
            this.configKeys = Objects.requireNonNull(configKeys, "configKeys");
            return this;
        }

        public final Builder graphName(@Nullable String graphName) {
            this.graphName = graphName;
            return this;
        }

        public final Builder graphName(Optional<String> graphName) {
            this.graphName = graphName.orElse(null);
            return this;
        }

        public final Builder addRelationshipType(String element) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            this.optBits |= 2L;
            return this;
        }

        public final Builder addRelationshipTypes(String ... elements) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 2L;
            return this;
        }

        public final Builder relationshipTypes(Iterable<String> elements) {
            this.relationshipTypes = new ArrayList<String>();
            return this.addAllRelationshipTypes(elements);
        }

        public final Builder addAllRelationshipTypes(Iterable<String> elements) {
            Objects.requireNonNull(elements, "relationshipTypes element");
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 2L;
            return this;
        }

        public final Builder concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.optBits |= 4L;
            return this;
        }

        public Builder clear() {
            this.optBits = 0L;
            this.usernameOverride = null;
            this.sudo = false;
            this.configKeys = null;
            this.graphName = null;
            if (this.relationshipTypes != null) {
                this.relationshipTypes.clear();
            }
            this.concurrency = 0;
            return this;
        }

        public GraphStreamRelationshipsConfig build() {
            return new ImmutableGraphStreamRelationshipsConfig(this);
        }

        private boolean sudoIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean relationshipTypesIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean concurrencyIsSet() {
            return (this.optBits & 4L) != 0L;
        }
    }

    @Generated(from="GraphStreamRelationshipsConfig", generator="Immutables")
    private final class InitShim {
        private byte sudoBuildStage = 0;
        private boolean sudo;
        private byte configKeysBuildStage = 0;
        private Collection<String> configKeys;
        private byte toMapBuildStage = 0;
        private Map<String, Object> toMap;
        private byte relationshipTypesBuildStage = 0;
        private List<String> relationshipTypes;
        private byte concurrencyBuildStage = 0;
        private int concurrency;

        private InitShim() {
        }

        boolean sudo() {
            if (this.sudoBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sudoBuildStage == 0) {
                this.sudoBuildStage = (byte)-1;
                this.sudo = ImmutableGraphStreamRelationshipsConfig.this.sudoInitialize();
                this.sudoBuildStage = 1;
            }
            return this.sudo;
        }

        void sudo(boolean sudo) {
            this.sudo = sudo;
            this.sudoBuildStage = 1;
        }

        Collection<String> configKeys() {
            if (this.configKeysBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.configKeysBuildStage == 0) {
                this.configKeysBuildStage = (byte)-1;
                this.configKeys = Objects.requireNonNull(ImmutableGraphStreamRelationshipsConfig.this.configKeysInitialize(), "configKeys");
                this.configKeysBuildStage = 1;
            }
            return this.configKeys;
        }

        void configKeys(Collection<String> configKeys) {
            this.configKeys = configKeys;
            this.configKeysBuildStage = 1;
        }

        Map<String, Object> toMap() {
            if (this.toMapBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.toMapBuildStage == 0) {
                this.toMapBuildStage = (byte)-1;
                this.toMap = Objects.requireNonNull(ImmutableGraphStreamRelationshipsConfig.this.toMapInitialize(), "toMap");
                this.toMapBuildStage = 1;
            }
            return this.toMap;
        }

        List<String> relationshipTypes() {
            if (this.relationshipTypesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relationshipTypesBuildStage == 0) {
                this.relationshipTypesBuildStage = (byte)-1;
                this.relationshipTypes = ImmutableGraphStreamRelationshipsConfig.createUnmodifiableList(false, ImmutableGraphStreamRelationshipsConfig.createSafeList(ImmutableGraphStreamRelationshipsConfig.this.relationshipTypesInitialize(), true, false));
                this.relationshipTypesBuildStage = 1;
            }
            return this.relationshipTypes;
        }

        void relationshipTypes(List<String> relationshipTypes) {
            this.relationshipTypes = relationshipTypes;
            this.relationshipTypesBuildStage = 1;
        }

        int concurrency() {
            if (this.concurrencyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.concurrencyBuildStage == 0) {
                this.concurrencyBuildStage = (byte)-1;
                this.concurrency = ImmutableGraphStreamRelationshipsConfig.this.concurrencyInitialize();
                this.concurrencyBuildStage = 1;
            }
            return this.concurrency;
        }

        void concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.concurrencyBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.sudoBuildStage == -1) {
                attributes.add("sudo");
            }
            if (this.configKeysBuildStage == -1) {
                attributes.add("configKeys");
            }
            if (this.toMapBuildStage == -1) {
                attributes.add("toMap");
            }
            if (this.relationshipTypesBuildStage == -1) {
                attributes.add("relationshipTypes");
            }
            if (this.concurrencyBuildStage == -1) {
                attributes.add("concurrency");
            }
            return "Cannot build GraphStreamRelationshipsConfig, attribute initializers form cycle " + attributes;
        }
    }
}

