/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.config;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.GraphAccessGraphPropertiesConfig;
import org.neo4j.gds.config.GraphRemoveGraphPropertiesConfig;

@ParametersAreNonnullByDefault
@Generated(from="GraphRemoveGraphPropertiesConfig", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableGraphRemoveGraphPropertiesConfig
implements GraphRemoveGraphPropertiesConfig {
    @Nullable
    private final String usernameOverride;
    private final boolean sudo;
    private final Collection<String> configKeys;
    private final transient Map<String, Object> toMap;
    @Nullable
    private final String graphName;
    private final String graphProperty;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableGraphRemoveGraphPropertiesConfig(Optional<String> graphName, String graphProperty) {
        this.graphName = graphName.orElse(null);
        this.graphProperty = Objects.requireNonNull(graphProperty, "graphProperty");
        this.usernameOverride = null;
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.initShim = null;
    }

    private ImmutableGraphRemoveGraphPropertiesConfig(@Nullable String graphName, String graphProperty) {
        this.graphName = graphName;
        this.graphProperty = Objects.requireNonNull(graphProperty, "graphProperty");
        this.usernameOverride = null;
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.initShim = null;
    }

    private ImmutableGraphRemoveGraphPropertiesConfig(Builder builder) {
        this.usernameOverride = builder.usernameOverride;
        this.graphName = builder.graphName;
        this.graphProperty = builder.graphProperty;
        if (builder.sudoIsSet()) {
            this.initShim.sudo(builder.sudo);
        }
        if (builder.configKeys != null) {
            this.initShim.configKeys(builder.configKeys);
        }
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.initShim = null;
    }

    private ImmutableGraphRemoveGraphPropertiesConfig(@Nullable String usernameOverride, boolean sudo, Collection<String> configKeys, @Nullable String graphName, String graphProperty) {
        this.usernameOverride = usernameOverride;
        this.initShim.sudo(sudo);
        this.initShim.configKeys(configKeys);
        this.graphName = graphName;
        this.graphProperty = graphProperty;
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.initShim = null;
    }

    private boolean sudoInitialize() {
        return GraphRemoveGraphPropertiesConfig.super.sudo();
    }

    private Collection<String> configKeysInitialize() {
        return GraphRemoveGraphPropertiesConfig.super.configKeys();
    }

    private Map<String, Object> toMapInitialize() {
        return GraphRemoveGraphPropertiesConfig.super.toMap();
    }

    public Optional<String> usernameOverride() {
        return Optional.ofNullable(this.usernameOverride);
    }

    public boolean sudo() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sudo() : this.sudo;
    }

    public Collection<String> configKeys() {
        InitShim shim = this.initShim;
        return shim != null ? shim.configKeys() : this.configKeys;
    }

    public Map<String, Object> toMap() {
        InitShim shim = this.initShim;
        return shim != null ? shim.toMap() : this.toMap;
    }

    @Override
    public Optional<String> graphName() {
        return Optional.ofNullable(this.graphName);
    }

    @Override
    public String graphProperty() {
        return this.graphProperty;
    }

    public final ImmutableGraphRemoveGraphPropertiesConfig withUsernameOverride(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.usernameOverride, newValue)) {
            return this;
        }
        return new ImmutableGraphRemoveGraphPropertiesConfig(newValue, this.sudo, this.configKeys, this.graphName, this.graphProperty);
    }

    public final ImmutableGraphRemoveGraphPropertiesConfig withUsernameOverride(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.usernameOverride, value)) {
            return this;
        }
        return new ImmutableGraphRemoveGraphPropertiesConfig(value, this.sudo, this.configKeys, this.graphName, this.graphProperty);
    }

    public final ImmutableGraphRemoveGraphPropertiesConfig withSudo(boolean value) {
        if (this.sudo == value) {
            return this;
        }
        return new ImmutableGraphRemoveGraphPropertiesConfig(this.usernameOverride, value, this.configKeys, this.graphName, this.graphProperty);
    }

    public final ImmutableGraphRemoveGraphPropertiesConfig withConfigKeys(Collection<String> value) {
        if (this.configKeys == value) {
            return this;
        }
        Collection<String> newValue = Objects.requireNonNull(value, "configKeys");
        return new ImmutableGraphRemoveGraphPropertiesConfig(this.usernameOverride, this.sudo, newValue, this.graphName, this.graphProperty);
    }

    public final ImmutableGraphRemoveGraphPropertiesConfig withGraphName(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.graphName, newValue)) {
            return this;
        }
        return new ImmutableGraphRemoveGraphPropertiesConfig(this.usernameOverride, this.sudo, this.configKeys, newValue, this.graphProperty);
    }

    public final ImmutableGraphRemoveGraphPropertiesConfig withGraphName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.graphName, value)) {
            return this;
        }
        return new ImmutableGraphRemoveGraphPropertiesConfig(this.usernameOverride, this.sudo, this.configKeys, value, this.graphProperty);
    }

    public final ImmutableGraphRemoveGraphPropertiesConfig withGraphProperty(String value) {
        String newValue = Objects.requireNonNull(value, "graphProperty");
        if (this.graphProperty.equals(newValue)) {
            return this;
        }
        return new ImmutableGraphRemoveGraphPropertiesConfig(this.usernameOverride, this.sudo, this.configKeys, this.graphName, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGraphRemoveGraphPropertiesConfig && this.equalTo((ImmutableGraphRemoveGraphPropertiesConfig)another);
    }

    private boolean equalTo(ImmutableGraphRemoveGraphPropertiesConfig another) {
        return Objects.equals(this.usernameOverride, another.usernameOverride) && this.sudo == another.sudo && Objects.equals(this.graphName, another.graphName) && this.graphProperty.equals(another.graphProperty);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.usernameOverride);
        h += (h << 5) + Boolean.hashCode(this.sudo);
        h += (h << 5) + Objects.hashCode(this.graphName);
        h += (h << 5) + this.graphProperty.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("GraphRemoveGraphPropertiesConfig{");
        if (this.usernameOverride != null) {
            builder.append("usernameOverride=").append(this.usernameOverride);
        }
        if (builder.length() > 33) {
            builder.append(", ");
        }
        builder.append("sudo=").append(this.sudo);
        if (this.graphName != null) {
            builder.append(", ");
            builder.append("graphName=").append(this.graphName);
        }
        builder.append(", ");
        builder.append("graphProperty=").append(this.graphProperty);
        return builder.append("}").toString();
    }

    public static GraphRemoveGraphPropertiesConfig of(Optional<String> graphName, String graphProperty) {
        return new ImmutableGraphRemoveGraphPropertiesConfig(graphName, graphProperty);
    }

    public static GraphRemoveGraphPropertiesConfig of(@Nullable String graphName, String graphProperty) {
        return new ImmutableGraphRemoveGraphPropertiesConfig(graphName, graphProperty);
    }

    public static GraphRemoveGraphPropertiesConfig copyOf(GraphRemoveGraphPropertiesConfig instance) {
        if (instance instanceof ImmutableGraphRemoveGraphPropertiesConfig) {
            return (ImmutableGraphRemoveGraphPropertiesConfig)instance;
        }
        return ImmutableGraphRemoveGraphPropertiesConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="GraphRemoveGraphPropertiesConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_GRAPH_PROPERTY = 1L;
        private static final long OPT_BIT_SUDO = 1L;
        private long initBits = 1L;
        private long optBits;
        @Nullable
        private String usernameOverride;
        private boolean sudo;
        @Nullable
        private Collection<String> configKeys;
        @Nullable
        private String graphName;
        @Nullable
        private String graphProperty;

        private Builder() {
        }

        public final Builder from(BaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(GraphAccessGraphPropertiesConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(GraphRemoveGraphPropertiesConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            BaseConfig instance;
            if (object instanceof BaseConfig) {
                instance = (BaseConfig)object;
                Optional usernameOverrideOptional = instance.usernameOverride();
                if (usernameOverrideOptional.isPresent()) {
                    this.usernameOverride(usernameOverrideOptional);
                }
                this.configKeys(instance.configKeys());
                this.sudo(instance.sudo());
            }
            if (object instanceof GraphAccessGraphPropertiesConfig) {
                instance = (GraphAccessGraphPropertiesConfig)object;
                Optional<String> graphNameOptional = instance.graphName();
                if (graphNameOptional.isPresent()) {
                    this.graphName(graphNameOptional);
                }
                this.graphProperty(instance.graphProperty());
            }
        }

        public final Builder usernameOverride(@Nullable String usernameOverride) {
            this.usernameOverride = usernameOverride;
            return this;
        }

        public final Builder usernameOverride(Optional<String> usernameOverride) {
            this.usernameOverride = usernameOverride.orElse(null);
            return this;
        }

        public final Builder sudo(boolean sudo) {
            this.sudo = sudo;
            this.optBits |= 1L;
            return this;
        }

        public final Builder configKeys(Collection<String> configKeys) {
            this.configKeys = Objects.requireNonNull(configKeys, "configKeys");
            return this;
        }

        public final Builder graphName(@Nullable String graphName) {
            this.graphName = graphName;
            return this;
        }

        public final Builder graphName(Optional<String> graphName) {
            this.graphName = graphName.orElse(null);
            return this;
        }

        public final Builder graphProperty(String graphProperty) {
            this.graphProperty = Objects.requireNonNull(graphProperty, "graphProperty");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public Builder clear() {
            this.initBits = 1L;
            this.optBits = 0L;
            this.usernameOverride = null;
            this.sudo = false;
            this.configKeys = null;
            this.graphName = null;
            this.graphProperty = null;
            return this;
        }

        public GraphRemoveGraphPropertiesConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGraphRemoveGraphPropertiesConfig(this);
        }

        private boolean sudoIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("graphProperty");
            }
            return "Cannot build GraphRemoveGraphPropertiesConfig, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="GraphRemoveGraphPropertiesConfig", generator="Immutables")
    private final class InitShim {
        private byte sudoBuildStage = 0;
        private boolean sudo;
        private byte configKeysBuildStage = 0;
        private Collection<String> configKeys;
        private byte toMapBuildStage = 0;
        private Map<String, Object> toMap;

        private InitShim() {
        }

        boolean sudo() {
            if (this.sudoBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sudoBuildStage == 0) {
                this.sudoBuildStage = (byte)-1;
                this.sudo = ImmutableGraphRemoveGraphPropertiesConfig.this.sudoInitialize();
                this.sudoBuildStage = 1;
            }
            return this.sudo;
        }

        void sudo(boolean sudo) {
            this.sudo = sudo;
            this.sudoBuildStage = 1;
        }

        Collection<String> configKeys() {
            if (this.configKeysBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.configKeysBuildStage == 0) {
                this.configKeysBuildStage = (byte)-1;
                this.configKeys = Objects.requireNonNull(ImmutableGraphRemoveGraphPropertiesConfig.this.configKeysInitialize(), "configKeys");
                this.configKeysBuildStage = 1;
            }
            return this.configKeys;
        }

        void configKeys(Collection<String> configKeys) {
            this.configKeys = configKeys;
            this.configKeysBuildStage = 1;
        }

        Map<String, Object> toMap() {
            if (this.toMapBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.toMapBuildStage == 0) {
                this.toMapBuildStage = (byte)-1;
                this.toMap = Objects.requireNonNull(ImmutableGraphRemoveGraphPropertiesConfig.this.toMapInitialize(), "toMap");
                this.toMapBuildStage = 1;
            }
            return this.toMap;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.sudoBuildStage == -1) {
                attributes.add("sudo");
            }
            if (this.configKeysBuildStage == -1) {
                attributes.add("configKeys");
            }
            if (this.toMapBuildStage == -1) {
                attributes.add("toMap");
            }
            return "Cannot build GraphRemoveGraphPropertiesConfig, attribute initializers form cycle " + attributes;
        }
    }
}

