/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.config;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.NodeProjections;
import org.neo4j.gds.PropertyMappings;
import org.neo4j.gds.RelationshipProjections;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.GraphProjectConfig;
import org.neo4j.gds.config.GraphProjectFromStoreConfig;
import org.neo4j.gds.config.JobIdConfig;
import org.neo4j.gds.core.utils.progress.JobId;

@ParametersAreNonnullByDefault
@Generated(from="GraphProjectFromStoreConfig", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableGraphProjectFromStoreConfig
implements GraphProjectFromStoreConfig {
    @Nullable
    private final String usernameOverride;
    private final boolean sudo;
    private final Collection<String> configKeys;
    private final transient Map<String, Object> toMap;
    private final JobId jobId;
    private final String username;
    private final String graphName;
    private final int readConcurrency;
    private final long nodeCount;
    private final long relationshipCount;
    private final transient ZonedDateTime creationTime;
    private final boolean validateRelationships;
    private final NodeProjections nodeProjections;
    private final RelationshipProjections relationshipProjections;
    private final PropertyMappings nodeProperties;
    private final PropertyMappings relationshipProperties;
    private final transient Set<String> outputFieldDenylist;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableGraphProjectFromStoreConfig(String username, String graphName, NodeProjections nodeProjections, RelationshipProjections relationshipProjections) {
        this.initShim.username(Objects.requireNonNull(username, "username"));
        this.graphName = Objects.requireNonNull(graphName, "graphName");
        this.nodeProjections = Objects.requireNonNull(nodeProjections, "nodeProjections");
        this.relationshipProjections = Objects.requireNonNull(relationshipProjections, "relationshipProjections");
        this.usernameOverride = null;
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.jobId = this.initShim.jobId();
        this.username = this.initShim.username();
        this.readConcurrency = this.initShim.readConcurrency();
        this.nodeCount = this.initShim.nodeCount();
        this.relationshipCount = this.initShim.relationshipCount();
        this.creationTime = this.initShim.creationTime();
        this.validateRelationships = this.initShim.validateRelationships();
        this.nodeProperties = this.initShim.nodeProperties();
        this.relationshipProperties = this.initShim.relationshipProperties();
        this.outputFieldDenylist = this.initShim.outputFieldDenylist();
        this.initShim = null;
    }

    private ImmutableGraphProjectFromStoreConfig(Builder builder) {
        this.usernameOverride = builder.usernameOverride;
        this.graphName = builder.graphName;
        this.nodeProjections = builder.nodeProjections;
        this.relationshipProjections = builder.relationshipProjections;
        if (builder.sudoIsSet()) {
            this.initShim.sudo(builder.sudo);
        }
        if (builder.configKeys != null) {
            this.initShim.configKeys(builder.configKeys);
        }
        if (builder.jobId != null) {
            this.initShim.jobId(builder.jobId);
        }
        if (builder.username != null) {
            this.initShim.username(builder.username);
        }
        if (builder.readConcurrencyIsSet()) {
            this.initShim.readConcurrency(builder.readConcurrency);
        }
        if (builder.nodeCountIsSet()) {
            this.initShim.nodeCount(builder.nodeCount);
        }
        if (builder.relationshipCountIsSet()) {
            this.initShim.relationshipCount(builder.relationshipCount);
        }
        if (builder.validateRelationshipsIsSet()) {
            this.initShim.validateRelationships(builder.validateRelationships);
        }
        if (builder.nodeProperties != null) {
            this.initShim.nodeProperties(builder.nodeProperties);
        }
        if (builder.relationshipProperties != null) {
            this.initShim.relationshipProperties(builder.relationshipProperties);
        }
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.jobId = this.initShim.jobId();
        this.username = this.initShim.username();
        this.readConcurrency = this.initShim.readConcurrency();
        this.nodeCount = this.initShim.nodeCount();
        this.relationshipCount = this.initShim.relationshipCount();
        this.creationTime = this.initShim.creationTime();
        this.validateRelationships = this.initShim.validateRelationships();
        this.nodeProperties = this.initShim.nodeProperties();
        this.relationshipProperties = this.initShim.relationshipProperties();
        this.outputFieldDenylist = this.initShim.outputFieldDenylist();
        this.initShim = null;
    }

    private ImmutableGraphProjectFromStoreConfig(@Nullable String usernameOverride, boolean sudo, Collection<String> configKeys, JobId jobId, String username, String graphName, int readConcurrency, long nodeCount, long relationshipCount, boolean validateRelationships, NodeProjections nodeProjections, RelationshipProjections relationshipProjections, PropertyMappings nodeProperties, PropertyMappings relationshipProperties) {
        this.usernameOverride = usernameOverride;
        this.initShim.sudo(sudo);
        this.initShim.configKeys(configKeys);
        this.initShim.jobId(jobId);
        this.initShim.username(username);
        this.graphName = graphName;
        this.initShim.readConcurrency(readConcurrency);
        this.initShim.nodeCount(nodeCount);
        this.initShim.relationshipCount(relationshipCount);
        this.initShim.validateRelationships(validateRelationships);
        this.nodeProjections = nodeProjections;
        this.relationshipProjections = relationshipProjections;
        this.initShim.nodeProperties(nodeProperties);
        this.initShim.relationshipProperties(relationshipProperties);
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.jobId = this.initShim.jobId();
        this.username = this.initShim.username();
        this.readConcurrency = this.initShim.readConcurrency();
        this.nodeCount = this.initShim.nodeCount();
        this.relationshipCount = this.initShim.relationshipCount();
        this.creationTime = this.initShim.creationTime();
        this.validateRelationships = this.initShim.validateRelationships();
        this.nodeProperties = this.initShim.nodeProperties();
        this.relationshipProperties = this.initShim.relationshipProperties();
        this.outputFieldDenylist = this.initShim.outputFieldDenylist();
        this.initShim = null;
    }

    private boolean sudoInitialize() {
        return GraphProjectFromStoreConfig.super.sudo();
    }

    private Collection<String> configKeysInitialize() {
        return GraphProjectFromStoreConfig.super.configKeys();
    }

    private Map<String, Object> toMapInitialize() {
        return GraphProjectFromStoreConfig.super.toMap();
    }

    private JobId jobIdInitialize() {
        return GraphProjectFromStoreConfig.super.jobId();
    }

    private String usernameInitialize() {
        return GraphProjectFromStoreConfig.super.username();
    }

    private int readConcurrencyInitialize() {
        return GraphProjectFromStoreConfig.super.readConcurrency();
    }

    private long nodeCountInitialize() {
        return GraphProjectFromStoreConfig.super.nodeCount();
    }

    private long relationshipCountInitialize() {
        return GraphProjectFromStoreConfig.super.relationshipCount();
    }

    private ZonedDateTime creationTimeInitialize() {
        return GraphProjectFromStoreConfig.super.creationTime();
    }

    private boolean validateRelationshipsInitialize() {
        return GraphProjectFromStoreConfig.super.validateRelationships();
    }

    private PropertyMappings nodePropertiesInitialize() {
        return GraphProjectFromStoreConfig.super.nodeProperties();
    }

    private PropertyMappings relationshipPropertiesInitialize() {
        return GraphProjectFromStoreConfig.super.relationshipProperties();
    }

    private Set<String> outputFieldDenylistInitialize() {
        return GraphProjectFromStoreConfig.super.outputFieldDenylist();
    }

    public Optional<String> usernameOverride() {
        return Optional.ofNullable(this.usernameOverride);
    }

    public boolean sudo() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sudo() : this.sudo;
    }

    public Collection<String> configKeys() {
        InitShim shim = this.initShim;
        return shim != null ? shim.configKeys() : this.configKeys;
    }

    public Map<String, Object> toMap() {
        InitShim shim = this.initShim;
        return shim != null ? shim.toMap() : this.toMap;
    }

    @Override
    public JobId jobId() {
        InitShim shim = this.initShim;
        return shim != null ? shim.jobId() : this.jobId;
    }

    @Override
    public String username() {
        InitShim shim = this.initShim;
        return shim != null ? shim.username() : this.username;
    }

    @Override
    public String graphName() {
        return this.graphName;
    }

    @Override
    public int readConcurrency() {
        InitShim shim = this.initShim;
        return shim != null ? shim.readConcurrency() : this.readConcurrency;
    }

    @Override
    public long nodeCount() {
        InitShim shim = this.initShim;
        return shim != null ? shim.nodeCount() : this.nodeCount;
    }

    @Override
    public long relationshipCount() {
        InitShim shim = this.initShim;
        return shim != null ? shim.relationshipCount() : this.relationshipCount;
    }

    @Override
    public ZonedDateTime creationTime() {
        InitShim shim = this.initShim;
        return shim != null ? shim.creationTime() : this.creationTime;
    }

    @Override
    public boolean validateRelationships() {
        InitShim shim = this.initShim;
        return shim != null ? shim.validateRelationships() : this.validateRelationships;
    }

    @Override
    public NodeProjections nodeProjections() {
        return this.nodeProjections;
    }

    @Override
    public RelationshipProjections relationshipProjections() {
        return this.relationshipProjections;
    }

    @Override
    public PropertyMappings nodeProperties() {
        InitShim shim = this.initShim;
        return shim != null ? shim.nodeProperties() : this.nodeProperties;
    }

    @Override
    public PropertyMappings relationshipProperties() {
        InitShim shim = this.initShim;
        return shim != null ? shim.relationshipProperties() : this.relationshipProperties;
    }

    @Override
    public Set<String> outputFieldDenylist() {
        InitShim shim = this.initShim;
        return shim != null ? shim.outputFieldDenylist() : this.outputFieldDenylist;
    }

    public final ImmutableGraphProjectFromStoreConfig withUsernameOverride(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.usernameOverride, newValue)) {
            return this;
        }
        return ImmutableGraphProjectFromStoreConfig.validate(new ImmutableGraphProjectFromStoreConfig(newValue, this.sudo, this.configKeys, this.jobId, this.username, this.graphName, this.readConcurrency, this.nodeCount, this.relationshipCount, this.validateRelationships, this.nodeProjections, this.relationshipProjections, this.nodeProperties, this.relationshipProperties));
    }

    public final ImmutableGraphProjectFromStoreConfig withUsernameOverride(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.usernameOverride, value)) {
            return this;
        }
        return ImmutableGraphProjectFromStoreConfig.validate(new ImmutableGraphProjectFromStoreConfig(value, this.sudo, this.configKeys, this.jobId, this.username, this.graphName, this.readConcurrency, this.nodeCount, this.relationshipCount, this.validateRelationships, this.nodeProjections, this.relationshipProjections, this.nodeProperties, this.relationshipProperties));
    }

    public final ImmutableGraphProjectFromStoreConfig withSudo(boolean value) {
        if (this.sudo == value) {
            return this;
        }
        return ImmutableGraphProjectFromStoreConfig.validate(new ImmutableGraphProjectFromStoreConfig(this.usernameOverride, value, this.configKeys, this.jobId, this.username, this.graphName, this.readConcurrency, this.nodeCount, this.relationshipCount, this.validateRelationships, this.nodeProjections, this.relationshipProjections, this.nodeProperties, this.relationshipProperties));
    }

    public final ImmutableGraphProjectFromStoreConfig withConfigKeys(Collection<String> value) {
        if (this.configKeys == value) {
            return this;
        }
        Collection<String> newValue = Objects.requireNonNull(value, "configKeys");
        return ImmutableGraphProjectFromStoreConfig.validate(new ImmutableGraphProjectFromStoreConfig(this.usernameOverride, this.sudo, newValue, this.jobId, this.username, this.graphName, this.readConcurrency, this.nodeCount, this.relationshipCount, this.validateRelationships, this.nodeProjections, this.relationshipProjections, this.nodeProperties, this.relationshipProperties));
    }

    public final ImmutableGraphProjectFromStoreConfig withJobId(JobId value) {
        if (this.jobId == value) {
            return this;
        }
        JobId newValue = Objects.requireNonNull(value, "jobId");
        return ImmutableGraphProjectFromStoreConfig.validate(new ImmutableGraphProjectFromStoreConfig(this.usernameOverride, this.sudo, this.configKeys, newValue, this.username, this.graphName, this.readConcurrency, this.nodeCount, this.relationshipCount, this.validateRelationships, this.nodeProjections, this.relationshipProjections, this.nodeProperties, this.relationshipProperties));
    }

    public final ImmutableGraphProjectFromStoreConfig withUsername(String value) {
        String newValue = Objects.requireNonNull(value, "username");
        if (this.username.equals(newValue)) {
            return this;
        }
        return ImmutableGraphProjectFromStoreConfig.validate(new ImmutableGraphProjectFromStoreConfig(this.usernameOverride, this.sudo, this.configKeys, this.jobId, newValue, this.graphName, this.readConcurrency, this.nodeCount, this.relationshipCount, this.validateRelationships, this.nodeProjections, this.relationshipProjections, this.nodeProperties, this.relationshipProperties));
    }

    public final ImmutableGraphProjectFromStoreConfig withGraphName(String value) {
        String newValue = Objects.requireNonNull(value, "graphName");
        if (this.graphName.equals(newValue)) {
            return this;
        }
        return ImmutableGraphProjectFromStoreConfig.validate(new ImmutableGraphProjectFromStoreConfig(this.usernameOverride, this.sudo, this.configKeys, this.jobId, this.username, newValue, this.readConcurrency, this.nodeCount, this.relationshipCount, this.validateRelationships, this.nodeProjections, this.relationshipProjections, this.nodeProperties, this.relationshipProperties));
    }

    public final ImmutableGraphProjectFromStoreConfig withReadConcurrency(int value) {
        if (this.readConcurrency == value) {
            return this;
        }
        return ImmutableGraphProjectFromStoreConfig.validate(new ImmutableGraphProjectFromStoreConfig(this.usernameOverride, this.sudo, this.configKeys, this.jobId, this.username, this.graphName, value, this.nodeCount, this.relationshipCount, this.validateRelationships, this.nodeProjections, this.relationshipProjections, this.nodeProperties, this.relationshipProperties));
    }

    public final ImmutableGraphProjectFromStoreConfig withNodeCount(long value) {
        if (this.nodeCount == value) {
            return this;
        }
        return ImmutableGraphProjectFromStoreConfig.validate(new ImmutableGraphProjectFromStoreConfig(this.usernameOverride, this.sudo, this.configKeys, this.jobId, this.username, this.graphName, this.readConcurrency, value, this.relationshipCount, this.validateRelationships, this.nodeProjections, this.relationshipProjections, this.nodeProperties, this.relationshipProperties));
    }

    public final ImmutableGraphProjectFromStoreConfig withRelationshipCount(long value) {
        if (this.relationshipCount == value) {
            return this;
        }
        return ImmutableGraphProjectFromStoreConfig.validate(new ImmutableGraphProjectFromStoreConfig(this.usernameOverride, this.sudo, this.configKeys, this.jobId, this.username, this.graphName, this.readConcurrency, this.nodeCount, value, this.validateRelationships, this.nodeProjections, this.relationshipProjections, this.nodeProperties, this.relationshipProperties));
    }

    public final ImmutableGraphProjectFromStoreConfig withValidateRelationships(boolean value) {
        if (this.validateRelationships == value) {
            return this;
        }
        return ImmutableGraphProjectFromStoreConfig.validate(new ImmutableGraphProjectFromStoreConfig(this.usernameOverride, this.sudo, this.configKeys, this.jobId, this.username, this.graphName, this.readConcurrency, this.nodeCount, this.relationshipCount, value, this.nodeProjections, this.relationshipProjections, this.nodeProperties, this.relationshipProperties));
    }

    public final ImmutableGraphProjectFromStoreConfig withNodeProjections(NodeProjections value) {
        if (this.nodeProjections == value) {
            return this;
        }
        NodeProjections newValue = Objects.requireNonNull(value, "nodeProjections");
        return ImmutableGraphProjectFromStoreConfig.validate(new ImmutableGraphProjectFromStoreConfig(this.usernameOverride, this.sudo, this.configKeys, this.jobId, this.username, this.graphName, this.readConcurrency, this.nodeCount, this.relationshipCount, this.validateRelationships, newValue, this.relationshipProjections, this.nodeProperties, this.relationshipProperties));
    }

    public final ImmutableGraphProjectFromStoreConfig withRelationshipProjections(RelationshipProjections value) {
        if (this.relationshipProjections == value) {
            return this;
        }
        RelationshipProjections newValue = Objects.requireNonNull(value, "relationshipProjections");
        return ImmutableGraphProjectFromStoreConfig.validate(new ImmutableGraphProjectFromStoreConfig(this.usernameOverride, this.sudo, this.configKeys, this.jobId, this.username, this.graphName, this.readConcurrency, this.nodeCount, this.relationshipCount, this.validateRelationships, this.nodeProjections, newValue, this.nodeProperties, this.relationshipProperties));
    }

    public final ImmutableGraphProjectFromStoreConfig withNodeProperties(PropertyMappings value) {
        if (this.nodeProperties == value) {
            return this;
        }
        PropertyMappings newValue = Objects.requireNonNull(value, "nodeProperties");
        return ImmutableGraphProjectFromStoreConfig.validate(new ImmutableGraphProjectFromStoreConfig(this.usernameOverride, this.sudo, this.configKeys, this.jobId, this.username, this.graphName, this.readConcurrency, this.nodeCount, this.relationshipCount, this.validateRelationships, this.nodeProjections, this.relationshipProjections, newValue, this.relationshipProperties));
    }

    public final ImmutableGraphProjectFromStoreConfig withRelationshipProperties(PropertyMappings value) {
        if (this.relationshipProperties == value) {
            return this;
        }
        PropertyMappings newValue = Objects.requireNonNull(value, "relationshipProperties");
        return ImmutableGraphProjectFromStoreConfig.validate(new ImmutableGraphProjectFromStoreConfig(this.usernameOverride, this.sudo, this.configKeys, this.jobId, this.username, this.graphName, this.readConcurrency, this.nodeCount, this.relationshipCount, this.validateRelationships, this.nodeProjections, this.relationshipProjections, this.nodeProperties, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGraphProjectFromStoreConfig && this.equalTo((ImmutableGraphProjectFromStoreConfig)another);
    }

    private boolean equalTo(ImmutableGraphProjectFromStoreConfig another) {
        return Objects.equals(this.usernameOverride, another.usernameOverride) && this.sudo == another.sudo && this.jobId.equals(another.jobId) && this.username.equals(another.username) && this.graphName.equals(another.graphName) && this.readConcurrency == another.readConcurrency && this.nodeCount == another.nodeCount && this.relationshipCount == another.relationshipCount && this.validateRelationships == another.validateRelationships && this.nodeProjections.equals((Object)another.nodeProjections) && this.relationshipProjections.equals((Object)another.relationshipProjections) && this.nodeProperties.equals((Object)another.nodeProperties) && this.relationshipProperties.equals((Object)another.relationshipProperties) && this.outputFieldDenylist.equals(another.outputFieldDenylist);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.usernameOverride);
        h += (h << 5) + Boolean.hashCode(this.sudo);
        h += (h << 5) + this.jobId.hashCode();
        h += (h << 5) + this.username.hashCode();
        h += (h << 5) + this.graphName.hashCode();
        h += (h << 5) + this.readConcurrency;
        h += (h << 5) + Long.hashCode(this.nodeCount);
        h += (h << 5) + Long.hashCode(this.relationshipCount);
        h += (h << 5) + Boolean.hashCode(this.validateRelationships);
        h += (h << 5) + this.nodeProjections.hashCode();
        h += (h << 5) + this.relationshipProjections.hashCode();
        h += (h << 5) + this.nodeProperties.hashCode();
        h += (h << 5) + this.relationshipProperties.hashCode();
        h += (h << 5) + this.outputFieldDenylist.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("GraphProjectFromStoreConfig{");
        if (this.usernameOverride != null) {
            builder.append("usernameOverride=").append(this.usernameOverride);
        }
        if (builder.length() > 28) {
            builder.append(", ");
        }
        builder.append("sudo=").append(this.sudo);
        builder.append(", ");
        builder.append("jobId=").append(this.jobId);
        builder.append(", ");
        builder.append("username=").append(this.username);
        builder.append(", ");
        builder.append("graphName=").append(this.graphName);
        builder.append(", ");
        builder.append("readConcurrency=").append(this.readConcurrency);
        builder.append(", ");
        builder.append("nodeCount=").append(this.nodeCount);
        builder.append(", ");
        builder.append("relationshipCount=").append(this.relationshipCount);
        builder.append(", ");
        builder.append("validateRelationships=").append(this.validateRelationships);
        builder.append(", ");
        builder.append("nodeProjections=").append(this.nodeProjections);
        builder.append(", ");
        builder.append("relationshipProjections=").append(this.relationshipProjections);
        builder.append(", ");
        builder.append("nodeProperties=").append(this.nodeProperties);
        builder.append(", ");
        builder.append("relationshipProperties=").append(this.relationshipProperties);
        builder.append(", ");
        builder.append("outputFieldDenylist=").append(this.outputFieldDenylist);
        return builder.append("}").toString();
    }

    public static GraphProjectFromStoreConfig of(String username, String graphName, NodeProjections nodeProjections, RelationshipProjections relationshipProjections) {
        return ImmutableGraphProjectFromStoreConfig.validate(new ImmutableGraphProjectFromStoreConfig(username, graphName, nodeProjections, relationshipProjections));
    }

    private static ImmutableGraphProjectFromStoreConfig validate(ImmutableGraphProjectFromStoreConfig instance) {
        instance = (ImmutableGraphProjectFromStoreConfig)instance.withNormalizedPropertyMappings();
        instance.validateProjectionsAreNotEmpty();
        instance.validateReadConcurrency();
        return instance;
    }

    public static GraphProjectFromStoreConfig copyOf(GraphProjectFromStoreConfig instance) {
        if (instance instanceof ImmutableGraphProjectFromStoreConfig) {
            return (ImmutableGraphProjectFromStoreConfig)instance;
        }
        return ImmutableGraphProjectFromStoreConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="GraphProjectFromStoreConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_GRAPH_NAME = 1L;
        private static final long INIT_BIT_NODE_PROJECTIONS = 2L;
        private static final long INIT_BIT_RELATIONSHIP_PROJECTIONS = 4L;
        private static final long OPT_BIT_SUDO = 1L;
        private static final long OPT_BIT_READ_CONCURRENCY = 2L;
        private static final long OPT_BIT_NODE_COUNT = 4L;
        private static final long OPT_BIT_RELATIONSHIP_COUNT = 8L;
        private static final long OPT_BIT_VALIDATE_RELATIONSHIPS = 16L;
        private long initBits = 7L;
        private long optBits;
        @Nullable
        private String usernameOverride;
        private boolean sudo;
        @Nullable
        private Collection<String> configKeys;
        @Nullable
        private JobId jobId;
        @Nullable
        private String username;
        @Nullable
        private String graphName;
        private int readConcurrency;
        private long nodeCount;
        private long relationshipCount;
        private boolean validateRelationships;
        @Nullable
        private NodeProjections nodeProjections;
        @Nullable
        private RelationshipProjections relationshipProjections;
        @Nullable
        private PropertyMappings nodeProperties;
        @Nullable
        private PropertyMappings relationshipProperties;

        private Builder() {
        }

        public final Builder from(GraphProjectFromStoreConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(GraphProjectConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(JobIdConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            JobIdConfig instance;
            if (object instanceof GraphProjectFromStoreConfig) {
                instance = (GraphProjectFromStoreConfig)object;
                this.relationshipProperties(instance.relationshipProperties());
                this.relationshipProjections(instance.relationshipProjections());
                this.nodeProjections(instance.nodeProjections());
                this.nodeProperties(instance.nodeProperties());
            }
            if (object instanceof GraphProjectConfig) {
                instance = (GraphProjectConfig)object;
                this.graphName(instance.graphName());
                this.nodeCount(instance.nodeCount());
                this.readConcurrency(instance.readConcurrency());
                this.validateRelationships(instance.validateRelationships());
                this.relationshipCount(instance.relationshipCount());
                this.username(instance.username());
            }
            if (object instanceof JobIdConfig) {
                instance = (JobIdConfig)object;
                this.jobId(instance.jobId());
            }
            if (object instanceof BaseConfig) {
                instance = (BaseConfig)object;
                Optional usernameOverrideOptional = instance.usernameOverride();
                if (usernameOverrideOptional.isPresent()) {
                    this.usernameOverride(usernameOverrideOptional);
                }
                this.configKeys(instance.configKeys());
                this.sudo(instance.sudo());
            }
        }

        public final Builder usernameOverride(@Nullable String usernameOverride) {
            this.usernameOverride = usernameOverride;
            return this;
        }

        public final Builder usernameOverride(Optional<String> usernameOverride) {
            this.usernameOverride = usernameOverride.orElse(null);
            return this;
        }

        public final Builder sudo(boolean sudo) {
            this.sudo = sudo;
            this.optBits |= 1L;
            return this;
        }

        public final Builder configKeys(Collection<String> configKeys) {
            this.configKeys = Objects.requireNonNull(configKeys, "configKeys");
            return this;
        }

        public final Builder jobId(JobId jobId) {
            this.jobId = Objects.requireNonNull(jobId, "jobId");
            return this;
        }

        public final Builder username(String username) {
            this.username = Objects.requireNonNull(username, "username");
            return this;
        }

        public final Builder graphName(String graphName) {
            this.graphName = Objects.requireNonNull(graphName, "graphName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder readConcurrency(int readConcurrency) {
            this.readConcurrency = readConcurrency;
            this.optBits |= 2L;
            return this;
        }

        public final Builder nodeCount(long nodeCount) {
            this.nodeCount = nodeCount;
            this.optBits |= 4L;
            return this;
        }

        public final Builder relationshipCount(long relationshipCount) {
            this.relationshipCount = relationshipCount;
            this.optBits |= 8L;
            return this;
        }

        public final Builder validateRelationships(boolean validateRelationships) {
            this.validateRelationships = validateRelationships;
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder nodeProjections(NodeProjections nodeProjections) {
            this.nodeProjections = Objects.requireNonNull(nodeProjections, "nodeProjections");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder relationshipProjections(RelationshipProjections relationshipProjections) {
            this.relationshipProjections = Objects.requireNonNull(relationshipProjections, "relationshipProjections");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder nodeProperties(PropertyMappings nodeProperties) {
            this.nodeProperties = Objects.requireNonNull(nodeProperties, "nodeProperties");
            return this;
        }

        public final Builder relationshipProperties(PropertyMappings relationshipProperties) {
            this.relationshipProperties = Objects.requireNonNull(relationshipProperties, "relationshipProperties");
            return this;
        }

        public Builder clear() {
            this.initBits = 7L;
            this.optBits = 0L;
            this.usernameOverride = null;
            this.sudo = false;
            this.configKeys = null;
            this.jobId = null;
            this.username = null;
            this.graphName = null;
            this.readConcurrency = 0;
            this.nodeCount = 0L;
            this.relationshipCount = 0L;
            this.validateRelationships = false;
            this.nodeProjections = null;
            this.relationshipProjections = null;
            this.nodeProperties = null;
            this.relationshipProperties = null;
            return this;
        }

        public GraphProjectFromStoreConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableGraphProjectFromStoreConfig.validate(new ImmutableGraphProjectFromStoreConfig(this));
        }

        private boolean sudoIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean readConcurrencyIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean nodeCountIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean relationshipCountIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean validateRelationshipsIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("graphName");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("nodeProjections");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("relationshipProjections");
            }
            return "Cannot build GraphProjectFromStoreConfig, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="GraphProjectFromStoreConfig", generator="Immutables")
    private final class InitShim {
        private byte sudoBuildStage = 0;
        private boolean sudo;
        private byte configKeysBuildStage = 0;
        private Collection<String> configKeys;
        private byte toMapBuildStage = 0;
        private Map<String, Object> toMap;
        private byte jobIdBuildStage = 0;
        private JobId jobId;
        private byte usernameBuildStage = 0;
        private String username;
        private byte readConcurrencyBuildStage = 0;
        private int readConcurrency;
        private byte nodeCountBuildStage = 0;
        private long nodeCount;
        private byte relationshipCountBuildStage = 0;
        private long relationshipCount;
        private byte creationTimeBuildStage = 0;
        private ZonedDateTime creationTime;
        private byte validateRelationshipsBuildStage = 0;
        private boolean validateRelationships;
        private byte nodePropertiesBuildStage = 0;
        private PropertyMappings nodeProperties;
        private byte relationshipPropertiesBuildStage = 0;
        private PropertyMappings relationshipProperties;
        private byte outputFieldDenylistBuildStage = 0;
        private Set<String> outputFieldDenylist;

        private InitShim() {
        }

        boolean sudo() {
            if (this.sudoBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sudoBuildStage == 0) {
                this.sudoBuildStage = (byte)-1;
                this.sudo = ImmutableGraphProjectFromStoreConfig.this.sudoInitialize();
                this.sudoBuildStage = 1;
            }
            return this.sudo;
        }

        void sudo(boolean sudo) {
            this.sudo = sudo;
            this.sudoBuildStage = 1;
        }

        Collection<String> configKeys() {
            if (this.configKeysBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.configKeysBuildStage == 0) {
                this.configKeysBuildStage = (byte)-1;
                this.configKeys = Objects.requireNonNull(ImmutableGraphProjectFromStoreConfig.this.configKeysInitialize(), "configKeys");
                this.configKeysBuildStage = 1;
            }
            return this.configKeys;
        }

        void configKeys(Collection<String> configKeys) {
            this.configKeys = configKeys;
            this.configKeysBuildStage = 1;
        }

        Map<String, Object> toMap() {
            if (this.toMapBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.toMapBuildStage == 0) {
                this.toMapBuildStage = (byte)-1;
                this.toMap = Objects.requireNonNull(ImmutableGraphProjectFromStoreConfig.this.toMapInitialize(), "toMap");
                this.toMapBuildStage = 1;
            }
            return this.toMap;
        }

        JobId jobId() {
            if (this.jobIdBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.jobIdBuildStage == 0) {
                this.jobIdBuildStage = (byte)-1;
                this.jobId = Objects.requireNonNull(ImmutableGraphProjectFromStoreConfig.this.jobIdInitialize(), "jobId");
                this.jobIdBuildStage = 1;
            }
            return this.jobId;
        }

        void jobId(JobId jobId) {
            this.jobId = jobId;
            this.jobIdBuildStage = 1;
        }

        String username() {
            if (this.usernameBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.usernameBuildStage == 0) {
                this.usernameBuildStage = (byte)-1;
                this.username = Objects.requireNonNull(ImmutableGraphProjectFromStoreConfig.this.usernameInitialize(), "username");
                this.usernameBuildStage = 1;
            }
            return this.username;
        }

        void username(String username) {
            this.username = username;
            this.usernameBuildStage = 1;
        }

        int readConcurrency() {
            if (this.readConcurrencyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.readConcurrencyBuildStage == 0) {
                this.readConcurrencyBuildStage = (byte)-1;
                this.readConcurrency = ImmutableGraphProjectFromStoreConfig.this.readConcurrencyInitialize();
                this.readConcurrencyBuildStage = 1;
            }
            return this.readConcurrency;
        }

        void readConcurrency(int readConcurrency) {
            this.readConcurrency = readConcurrency;
            this.readConcurrencyBuildStage = 1;
        }

        long nodeCount() {
            if (this.nodeCountBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nodeCountBuildStage == 0) {
                this.nodeCountBuildStage = (byte)-1;
                this.nodeCount = ImmutableGraphProjectFromStoreConfig.this.nodeCountInitialize();
                this.nodeCountBuildStage = 1;
            }
            return this.nodeCount;
        }

        void nodeCount(long nodeCount) {
            this.nodeCount = nodeCount;
            this.nodeCountBuildStage = 1;
        }

        long relationshipCount() {
            if (this.relationshipCountBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relationshipCountBuildStage == 0) {
                this.relationshipCountBuildStage = (byte)-1;
                this.relationshipCount = ImmutableGraphProjectFromStoreConfig.this.relationshipCountInitialize();
                this.relationshipCountBuildStage = 1;
            }
            return this.relationshipCount;
        }

        void relationshipCount(long relationshipCount) {
            this.relationshipCount = relationshipCount;
            this.relationshipCountBuildStage = 1;
        }

        ZonedDateTime creationTime() {
            if (this.creationTimeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.creationTimeBuildStage == 0) {
                this.creationTimeBuildStage = (byte)-1;
                this.creationTime = Objects.requireNonNull(ImmutableGraphProjectFromStoreConfig.this.creationTimeInitialize(), "creationTime");
                this.creationTimeBuildStage = 1;
            }
            return this.creationTime;
        }

        boolean validateRelationships() {
            if (this.validateRelationshipsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.validateRelationshipsBuildStage == 0) {
                this.validateRelationshipsBuildStage = (byte)-1;
                this.validateRelationships = ImmutableGraphProjectFromStoreConfig.this.validateRelationshipsInitialize();
                this.validateRelationshipsBuildStage = 1;
            }
            return this.validateRelationships;
        }

        void validateRelationships(boolean validateRelationships) {
            this.validateRelationships = validateRelationships;
            this.validateRelationshipsBuildStage = 1;
        }

        PropertyMappings nodeProperties() {
            if (this.nodePropertiesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nodePropertiesBuildStage == 0) {
                this.nodePropertiesBuildStage = (byte)-1;
                this.nodeProperties = Objects.requireNonNull(ImmutableGraphProjectFromStoreConfig.this.nodePropertiesInitialize(), "nodeProperties");
                this.nodePropertiesBuildStage = 1;
            }
            return this.nodeProperties;
        }

        void nodeProperties(PropertyMappings nodeProperties) {
            this.nodeProperties = nodeProperties;
            this.nodePropertiesBuildStage = 1;
        }

        PropertyMappings relationshipProperties() {
            if (this.relationshipPropertiesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relationshipPropertiesBuildStage == 0) {
                this.relationshipPropertiesBuildStage = (byte)-1;
                this.relationshipProperties = Objects.requireNonNull(ImmutableGraphProjectFromStoreConfig.this.relationshipPropertiesInitialize(), "relationshipProperties");
                this.relationshipPropertiesBuildStage = 1;
            }
            return this.relationshipProperties;
        }

        void relationshipProperties(PropertyMappings relationshipProperties) {
            this.relationshipProperties = relationshipProperties;
            this.relationshipPropertiesBuildStage = 1;
        }

        Set<String> outputFieldDenylist() {
            if (this.outputFieldDenylistBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.outputFieldDenylistBuildStage == 0) {
                this.outputFieldDenylistBuildStage = (byte)-1;
                this.outputFieldDenylist = Objects.requireNonNull(ImmutableGraphProjectFromStoreConfig.this.outputFieldDenylistInitialize(), "outputFieldDenylist");
                this.outputFieldDenylistBuildStage = 1;
            }
            return this.outputFieldDenylist;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.sudoBuildStage == -1) {
                attributes.add("sudo");
            }
            if (this.configKeysBuildStage == -1) {
                attributes.add("configKeys");
            }
            if (this.toMapBuildStage == -1) {
                attributes.add("toMap");
            }
            if (this.jobIdBuildStage == -1) {
                attributes.add("jobId");
            }
            if (this.usernameBuildStage == -1) {
                attributes.add("username");
            }
            if (this.readConcurrencyBuildStage == -1) {
                attributes.add("readConcurrency");
            }
            if (this.nodeCountBuildStage == -1) {
                attributes.add("nodeCount");
            }
            if (this.relationshipCountBuildStage == -1) {
                attributes.add("relationshipCount");
            }
            if (this.creationTimeBuildStage == -1) {
                attributes.add("creationTime");
            }
            if (this.validateRelationshipsBuildStage == -1) {
                attributes.add("validateRelationships");
            }
            if (this.nodePropertiesBuildStage == -1) {
                attributes.add("nodeProperties");
            }
            if (this.relationshipPropertiesBuildStage == -1) {
                attributes.add("relationshipProperties");
            }
            if (this.outputFieldDenylistBuildStage == -1) {
                attributes.add("outputFieldDenylist");
            }
            return "Cannot build GraphProjectFromStoreConfig, attribute initializers form cycle " + attributes;
        }
    }
}

