/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.config;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.api.GraphStoreFactory;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.GraphProjectConfig;
import org.neo4j.gds.config.GraphProjectFromGraphConfig;
import org.neo4j.gds.config.JobIdConfig;
import org.neo4j.gds.core.utils.progress.JobId;

@ParametersAreNonnullByDefault
@Generated(from="GraphProjectFromGraphConfig", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableGraphProjectFromGraphConfig
implements GraphProjectFromGraphConfig {
    @Nullable
    private final String usernameOverride;
    private final boolean sudo;
    private final Collection<String> configKeys;
    private final transient Map<String, Object> toMap;
    private final JobId jobId;
    private final String username;
    private final int readConcurrency;
    private final transient ZonedDateTime creationTime;
    private final String graphName;
    private final String fromGraphName;
    private final String nodeFilter;
    private final String relationshipFilter;
    private final GraphProjectConfig originalConfig;
    private final int concurrency;
    private final Map<String, Object> parameters;
    private final GraphStoreFactory.Supplier graphStoreFactory;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableGraphProjectFromGraphConfig(String username, String graphName, String fromGraphName, String nodeFilter, String relationshipFilter, GraphProjectConfig originalConfig, GraphStoreFactory.Supplier graphStoreFactory) {
        this.initShim.username(Objects.requireNonNull(username, "username"));
        this.graphName = Objects.requireNonNull(graphName, "graphName");
        this.fromGraphName = Objects.requireNonNull(fromGraphName, "fromGraphName");
        this.nodeFilter = Objects.requireNonNull(nodeFilter, "nodeFilter");
        this.relationshipFilter = Objects.requireNonNull(relationshipFilter, "relationshipFilter");
        this.originalConfig = Objects.requireNonNull(originalConfig, "originalConfig");
        this.initShim.graphStoreFactory(Objects.requireNonNull(graphStoreFactory, "graphStoreFactory"));
        this.usernameOverride = null;
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.jobId = this.initShim.jobId();
        this.username = this.initShim.username();
        this.readConcurrency = this.initShim.readConcurrency();
        this.creationTime = this.initShim.creationTime();
        this.concurrency = this.initShim.concurrency();
        this.parameters = this.initShim.parameters();
        this.graphStoreFactory = this.initShim.graphStoreFactory();
        this.initShim = null;
    }

    private ImmutableGraphProjectFromGraphConfig(Builder builder) {
        this.usernameOverride = builder.usernameOverride;
        this.graphName = builder.graphName;
        this.fromGraphName = builder.fromGraphName;
        this.nodeFilter = builder.nodeFilter;
        this.relationshipFilter = builder.relationshipFilter;
        this.originalConfig = builder.originalConfig;
        if (builder.sudoIsSet()) {
            this.initShim.sudo(builder.sudo);
        }
        if (builder.configKeys != null) {
            this.initShim.configKeys(builder.configKeys);
        }
        if (builder.jobId != null) {
            this.initShim.jobId(builder.jobId);
        }
        if (builder.username != null) {
            this.initShim.username(builder.username);
        }
        if (builder.readConcurrencyIsSet()) {
            this.initShim.readConcurrency(builder.readConcurrency);
        }
        if (builder.concurrencyIsSet()) {
            this.initShim.concurrency(builder.concurrency);
        }
        if (builder.parametersIsSet()) {
            this.initShim.parameters(builder.parameters == null ? Collections.emptyMap() : ImmutableGraphProjectFromGraphConfig.createUnmodifiableMap(false, false, builder.parameters));
        }
        if (builder.graphStoreFactory != null) {
            this.initShim.graphStoreFactory(builder.graphStoreFactory);
        }
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.jobId = this.initShim.jobId();
        this.username = this.initShim.username();
        this.readConcurrency = this.initShim.readConcurrency();
        this.creationTime = this.initShim.creationTime();
        this.concurrency = this.initShim.concurrency();
        this.parameters = this.initShim.parameters();
        this.graphStoreFactory = this.initShim.graphStoreFactory();
        this.initShim = null;
    }

    private ImmutableGraphProjectFromGraphConfig(@Nullable String usernameOverride, boolean sudo, Collection<String> configKeys, JobId jobId, String username, int readConcurrency, String graphName, String fromGraphName, String nodeFilter, String relationshipFilter, GraphProjectConfig originalConfig, int concurrency, Map<String, Object> parameters, GraphStoreFactory.Supplier graphStoreFactory) {
        this.usernameOverride = usernameOverride;
        this.initShim.sudo(sudo);
        this.initShim.configKeys(configKeys);
        this.initShim.jobId(jobId);
        this.initShim.username(username);
        this.initShim.readConcurrency(readConcurrency);
        this.graphName = graphName;
        this.fromGraphName = fromGraphName;
        this.nodeFilter = nodeFilter;
        this.relationshipFilter = relationshipFilter;
        this.originalConfig = originalConfig;
        this.initShim.concurrency(concurrency);
        this.initShim.parameters(parameters);
        this.initShim.graphStoreFactory(graphStoreFactory);
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.jobId = this.initShim.jobId();
        this.username = this.initShim.username();
        this.readConcurrency = this.initShim.readConcurrency();
        this.creationTime = this.initShim.creationTime();
        this.concurrency = this.initShim.concurrency();
        this.parameters = this.initShim.parameters();
        this.graphStoreFactory = this.initShim.graphStoreFactory();
        this.initShim = null;
    }

    private boolean sudoInitialize() {
        return GraphProjectFromGraphConfig.super.sudo();
    }

    private Collection<String> configKeysInitialize() {
        return GraphProjectFromGraphConfig.super.configKeys();
    }

    private Map<String, Object> toMapInitialize() {
        return GraphProjectFromGraphConfig.super.toMap();
    }

    private JobId jobIdInitialize() {
        return GraphProjectFromGraphConfig.super.jobId();
    }

    private String usernameInitialize() {
        return GraphProjectFromGraphConfig.super.username();
    }

    private int readConcurrencyInitialize() {
        return GraphProjectFromGraphConfig.super.readConcurrency();
    }

    private ZonedDateTime creationTimeInitialize() {
        return GraphProjectFromGraphConfig.super.creationTime();
    }

    private int concurrencyInitialize() {
        return GraphProjectFromGraphConfig.super.concurrency();
    }

    private Map<String, Object> parametersInitialize() {
        return GraphProjectFromGraphConfig.super.parameters();
    }

    private GraphStoreFactory.Supplier graphStoreFactoryInitialize() {
        return GraphProjectFromGraphConfig.super.graphStoreFactory();
    }

    public Optional<String> usernameOverride() {
        return Optional.ofNullable(this.usernameOverride);
    }

    public boolean sudo() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sudo() : this.sudo;
    }

    public Collection<String> configKeys() {
        InitShim shim = this.initShim;
        return shim != null ? shim.configKeys() : this.configKeys;
    }

    public Map<String, Object> toMap() {
        InitShim shim = this.initShim;
        return shim != null ? shim.toMap() : this.toMap;
    }

    @Override
    public JobId jobId() {
        InitShim shim = this.initShim;
        return shim != null ? shim.jobId() : this.jobId;
    }

    @Override
    public String username() {
        InitShim shim = this.initShim;
        return shim != null ? shim.username() : this.username;
    }

    @Override
    public int readConcurrency() {
        InitShim shim = this.initShim;
        return shim != null ? shim.readConcurrency() : this.readConcurrency;
    }

    @Override
    public ZonedDateTime creationTime() {
        InitShim shim = this.initShim;
        return shim != null ? shim.creationTime() : this.creationTime;
    }

    @Override
    public String graphName() {
        return this.graphName;
    }

    @Override
    public String fromGraphName() {
        return this.fromGraphName;
    }

    @Override
    public String nodeFilter() {
        return this.nodeFilter;
    }

    @Override
    public String relationshipFilter() {
        return this.relationshipFilter;
    }

    @Override
    public GraphProjectConfig originalConfig() {
        return this.originalConfig;
    }

    @Override
    public int concurrency() {
        InitShim shim = this.initShim;
        return shim != null ? shim.concurrency() : this.concurrency;
    }

    @Override
    public Map<String, Object> parameters() {
        InitShim shim = this.initShim;
        return shim != null ? shim.parameters() : this.parameters;
    }

    @Override
    public GraphStoreFactory.Supplier graphStoreFactory() {
        InitShim shim = this.initShim;
        return shim != null ? shim.graphStoreFactory() : this.graphStoreFactory;
    }

    public final ImmutableGraphProjectFromGraphConfig withUsernameOverride(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.usernameOverride, newValue)) {
            return this;
        }
        return ImmutableGraphProjectFromGraphConfig.validate(new ImmutableGraphProjectFromGraphConfig(newValue, this.sudo, this.configKeys, this.jobId, this.username, this.readConcurrency, this.graphName, this.fromGraphName, this.nodeFilter, this.relationshipFilter, this.originalConfig, this.concurrency, this.parameters, this.graphStoreFactory));
    }

    public final ImmutableGraphProjectFromGraphConfig withUsernameOverride(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.usernameOverride, value)) {
            return this;
        }
        return ImmutableGraphProjectFromGraphConfig.validate(new ImmutableGraphProjectFromGraphConfig(value, this.sudo, this.configKeys, this.jobId, this.username, this.readConcurrency, this.graphName, this.fromGraphName, this.nodeFilter, this.relationshipFilter, this.originalConfig, this.concurrency, this.parameters, this.graphStoreFactory));
    }

    public final ImmutableGraphProjectFromGraphConfig withSudo(boolean value) {
        if (this.sudo == value) {
            return this;
        }
        return ImmutableGraphProjectFromGraphConfig.validate(new ImmutableGraphProjectFromGraphConfig(this.usernameOverride, value, this.configKeys, this.jobId, this.username, this.readConcurrency, this.graphName, this.fromGraphName, this.nodeFilter, this.relationshipFilter, this.originalConfig, this.concurrency, this.parameters, this.graphStoreFactory));
    }

    public final ImmutableGraphProjectFromGraphConfig withConfigKeys(Collection<String> value) {
        if (this.configKeys == value) {
            return this;
        }
        Collection<String> newValue = Objects.requireNonNull(value, "configKeys");
        return ImmutableGraphProjectFromGraphConfig.validate(new ImmutableGraphProjectFromGraphConfig(this.usernameOverride, this.sudo, newValue, this.jobId, this.username, this.readConcurrency, this.graphName, this.fromGraphName, this.nodeFilter, this.relationshipFilter, this.originalConfig, this.concurrency, this.parameters, this.graphStoreFactory));
    }

    public final ImmutableGraphProjectFromGraphConfig withJobId(JobId value) {
        if (this.jobId == value) {
            return this;
        }
        JobId newValue = Objects.requireNonNull(value, "jobId");
        return ImmutableGraphProjectFromGraphConfig.validate(new ImmutableGraphProjectFromGraphConfig(this.usernameOverride, this.sudo, this.configKeys, newValue, this.username, this.readConcurrency, this.graphName, this.fromGraphName, this.nodeFilter, this.relationshipFilter, this.originalConfig, this.concurrency, this.parameters, this.graphStoreFactory));
    }

    public final ImmutableGraphProjectFromGraphConfig withUsername(String value) {
        String newValue = Objects.requireNonNull(value, "username");
        if (this.username.equals(newValue)) {
            return this;
        }
        return ImmutableGraphProjectFromGraphConfig.validate(new ImmutableGraphProjectFromGraphConfig(this.usernameOverride, this.sudo, this.configKeys, this.jobId, newValue, this.readConcurrency, this.graphName, this.fromGraphName, this.nodeFilter, this.relationshipFilter, this.originalConfig, this.concurrency, this.parameters, this.graphStoreFactory));
    }

    public final ImmutableGraphProjectFromGraphConfig withReadConcurrency(int value) {
        if (this.readConcurrency == value) {
            return this;
        }
        return ImmutableGraphProjectFromGraphConfig.validate(new ImmutableGraphProjectFromGraphConfig(this.usernameOverride, this.sudo, this.configKeys, this.jobId, this.username, value, this.graphName, this.fromGraphName, this.nodeFilter, this.relationshipFilter, this.originalConfig, this.concurrency, this.parameters, this.graphStoreFactory));
    }

    public final ImmutableGraphProjectFromGraphConfig withGraphName(String value) {
        String newValue = Objects.requireNonNull(value, "graphName");
        if (this.graphName.equals(newValue)) {
            return this;
        }
        return ImmutableGraphProjectFromGraphConfig.validate(new ImmutableGraphProjectFromGraphConfig(this.usernameOverride, this.sudo, this.configKeys, this.jobId, this.username, this.readConcurrency, newValue, this.fromGraphName, this.nodeFilter, this.relationshipFilter, this.originalConfig, this.concurrency, this.parameters, this.graphStoreFactory));
    }

    public final ImmutableGraphProjectFromGraphConfig withFromGraphName(String value) {
        String newValue = Objects.requireNonNull(value, "fromGraphName");
        if (this.fromGraphName.equals(newValue)) {
            return this;
        }
        return ImmutableGraphProjectFromGraphConfig.validate(new ImmutableGraphProjectFromGraphConfig(this.usernameOverride, this.sudo, this.configKeys, this.jobId, this.username, this.readConcurrency, this.graphName, newValue, this.nodeFilter, this.relationshipFilter, this.originalConfig, this.concurrency, this.parameters, this.graphStoreFactory));
    }

    public final ImmutableGraphProjectFromGraphConfig withNodeFilter(String value) {
        String newValue = Objects.requireNonNull(value, "nodeFilter");
        if (this.nodeFilter.equals(newValue)) {
            return this;
        }
        return ImmutableGraphProjectFromGraphConfig.validate(new ImmutableGraphProjectFromGraphConfig(this.usernameOverride, this.sudo, this.configKeys, this.jobId, this.username, this.readConcurrency, this.graphName, this.fromGraphName, newValue, this.relationshipFilter, this.originalConfig, this.concurrency, this.parameters, this.graphStoreFactory));
    }

    public final ImmutableGraphProjectFromGraphConfig withRelationshipFilter(String value) {
        String newValue = Objects.requireNonNull(value, "relationshipFilter");
        if (this.relationshipFilter.equals(newValue)) {
            return this;
        }
        return ImmutableGraphProjectFromGraphConfig.validate(new ImmutableGraphProjectFromGraphConfig(this.usernameOverride, this.sudo, this.configKeys, this.jobId, this.username, this.readConcurrency, this.graphName, this.fromGraphName, this.nodeFilter, newValue, this.originalConfig, this.concurrency, this.parameters, this.graphStoreFactory));
    }

    public final ImmutableGraphProjectFromGraphConfig withOriginalConfig(GraphProjectConfig value) {
        if (this.originalConfig == value) {
            return this;
        }
        GraphProjectConfig newValue = Objects.requireNonNull(value, "originalConfig");
        return ImmutableGraphProjectFromGraphConfig.validate(new ImmutableGraphProjectFromGraphConfig(this.usernameOverride, this.sudo, this.configKeys, this.jobId, this.username, this.readConcurrency, this.graphName, this.fromGraphName, this.nodeFilter, this.relationshipFilter, newValue, this.concurrency, this.parameters, this.graphStoreFactory));
    }

    public final ImmutableGraphProjectFromGraphConfig withConcurrency(int value) {
        if (this.concurrency == value) {
            return this;
        }
        return ImmutableGraphProjectFromGraphConfig.validate(new ImmutableGraphProjectFromGraphConfig(this.usernameOverride, this.sudo, this.configKeys, this.jobId, this.username, this.readConcurrency, this.graphName, this.fromGraphName, this.nodeFilter, this.relationshipFilter, this.originalConfig, value, this.parameters, this.graphStoreFactory));
    }

    public final ImmutableGraphProjectFromGraphConfig withParameters(Map<String, ? extends Object> entries) {
        if (this.parameters == entries) {
            return this;
        }
        Map<String, Object> newValue = ImmutableGraphProjectFromGraphConfig.createUnmodifiableMap(true, false, entries);
        return ImmutableGraphProjectFromGraphConfig.validate(new ImmutableGraphProjectFromGraphConfig(this.usernameOverride, this.sudo, this.configKeys, this.jobId, this.username, this.readConcurrency, this.graphName, this.fromGraphName, this.nodeFilter, this.relationshipFilter, this.originalConfig, this.concurrency, newValue, this.graphStoreFactory));
    }

    public final ImmutableGraphProjectFromGraphConfig withGraphStoreFactory(GraphStoreFactory.Supplier value) {
        if (this.graphStoreFactory == value) {
            return this;
        }
        GraphStoreFactory.Supplier newValue = Objects.requireNonNull(value, "graphStoreFactory");
        return ImmutableGraphProjectFromGraphConfig.validate(new ImmutableGraphProjectFromGraphConfig(this.usernameOverride, this.sudo, this.configKeys, this.jobId, this.username, this.readConcurrency, this.graphName, this.fromGraphName, this.nodeFilter, this.relationshipFilter, this.originalConfig, this.concurrency, this.parameters, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGraphProjectFromGraphConfig && this.equalTo((ImmutableGraphProjectFromGraphConfig)another);
    }

    private boolean equalTo(ImmutableGraphProjectFromGraphConfig another) {
        return Objects.equals(this.usernameOverride, another.usernameOverride) && this.sudo == another.sudo && this.jobId.equals(another.jobId) && this.username.equals(another.username) && this.readConcurrency == another.readConcurrency && this.graphName.equals(another.graphName) && this.fromGraphName.equals(another.fromGraphName) && this.nodeFilter.equals(another.nodeFilter) && this.relationshipFilter.equals(another.relationshipFilter) && this.originalConfig.equals(another.originalConfig) && this.concurrency == another.concurrency && this.parameters.equals(another.parameters) && this.graphStoreFactory.equals(another.graphStoreFactory);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.usernameOverride);
        h += (h << 5) + Boolean.hashCode(this.sudo);
        h += (h << 5) + this.jobId.hashCode();
        h += (h << 5) + this.username.hashCode();
        h += (h << 5) + this.readConcurrency;
        h += (h << 5) + this.graphName.hashCode();
        h += (h << 5) + this.fromGraphName.hashCode();
        h += (h << 5) + this.nodeFilter.hashCode();
        h += (h << 5) + this.relationshipFilter.hashCode();
        h += (h << 5) + this.originalConfig.hashCode();
        h += (h << 5) + this.concurrency;
        h += (h << 5) + this.parameters.hashCode();
        h += (h << 5) + this.graphStoreFactory.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("GraphProjectFromGraphConfig{");
        if (this.usernameOverride != null) {
            builder.append("usernameOverride=").append(this.usernameOverride);
        }
        if (builder.length() > 28) {
            builder.append(", ");
        }
        builder.append("sudo=").append(this.sudo);
        builder.append(", ");
        builder.append("jobId=").append(this.jobId);
        builder.append(", ");
        builder.append("username=").append(this.username);
        builder.append(", ");
        builder.append("readConcurrency=").append(this.readConcurrency);
        builder.append(", ");
        builder.append("graphName=").append(this.graphName);
        builder.append(", ");
        builder.append("fromGraphName=").append(this.fromGraphName);
        builder.append(", ");
        builder.append("nodeFilter=").append(this.nodeFilter);
        builder.append(", ");
        builder.append("relationshipFilter=").append(this.relationshipFilter);
        builder.append(", ");
        builder.append("originalConfig=").append(this.originalConfig);
        builder.append(", ");
        builder.append("concurrency=").append(this.concurrency);
        builder.append(", ");
        builder.append("parameters=").append(this.parameters);
        builder.append(", ");
        builder.append("graphStoreFactory=").append(this.graphStoreFactory);
        return builder.append("}").toString();
    }

    public static GraphProjectFromGraphConfig of(String username, String graphName, String fromGraphName, String nodeFilter, String relationshipFilter, GraphProjectConfig originalConfig, GraphStoreFactory.Supplier graphStoreFactory) {
        return ImmutableGraphProjectFromGraphConfig.validate(new ImmutableGraphProjectFromGraphConfig(username, graphName, fromGraphName, nodeFilter, relationshipFilter, originalConfig, graphStoreFactory));
    }

    private static ImmutableGraphProjectFromGraphConfig validate(ImmutableGraphProjectFromGraphConfig instance) {
        instance.validateReadConcurrency();
        return instance;
    }

    public static GraphProjectFromGraphConfig copyOf(GraphProjectFromGraphConfig instance) {
        if (instance instanceof ImmutableGraphProjectFromGraphConfig) {
            return (ImmutableGraphProjectFromGraphConfig)instance;
        }
        return ImmutableGraphProjectFromGraphConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="GraphProjectFromGraphConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_GRAPH_NAME = 1L;
        private static final long INIT_BIT_FROM_GRAPH_NAME = 2L;
        private static final long INIT_BIT_NODE_FILTER = 4L;
        private static final long INIT_BIT_RELATIONSHIP_FILTER = 8L;
        private static final long INIT_BIT_ORIGINAL_CONFIG = 16L;
        private static final long OPT_BIT_SUDO = 1L;
        private static final long OPT_BIT_READ_CONCURRENCY = 2L;
        private static final long OPT_BIT_CONCURRENCY = 4L;
        private static final long OPT_BIT_PARAMETERS = 8L;
        private long initBits = 31L;
        private long optBits;
        @Nullable
        private String usernameOverride;
        private boolean sudo;
        @Nullable
        private Collection<String> configKeys;
        @Nullable
        private JobId jobId;
        @Nullable
        private String username;
        private int readConcurrency;
        @Nullable
        private String graphName;
        @Nullable
        private String fromGraphName;
        @Nullable
        private String nodeFilter;
        @Nullable
        private String relationshipFilter;
        @Nullable
        private GraphProjectConfig originalConfig;
        private int concurrency;
        private Map<String, Object> parameters = null;
        @Nullable
        private GraphStoreFactory.Supplier graphStoreFactory;

        private Builder() {
        }

        public final Builder from(GraphProjectConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(JobIdConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(GraphProjectFromGraphConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            JobIdConfig instance;
            long bits = 0L;
            if (object instanceof GraphProjectConfig) {
                instance = (GraphProjectConfig)object;
                if ((bits & 2L) == 0L) {
                    this.graphName(instance.graphName());
                    bits |= 2L;
                }
                this.readConcurrency(instance.readConcurrency());
                if ((bits & 1L) == 0L) {
                    this.graphStoreFactory(instance.graphStoreFactory());
                    bits |= 1L;
                }
                this.username(instance.username());
            }
            if (object instanceof JobIdConfig) {
                instance = (JobIdConfig)object;
                this.jobId(instance.jobId());
            }
            if (object instanceof BaseConfig) {
                instance = (BaseConfig)object;
                Optional usernameOverrideOptional = instance.usernameOverride();
                if (usernameOverrideOptional.isPresent()) {
                    this.usernameOverride(usernameOverrideOptional);
                }
                this.configKeys(instance.configKeys());
                this.sudo(instance.sudo());
            }
            if (object instanceof GraphProjectFromGraphConfig) {
                instance = (GraphProjectFromGraphConfig)object;
                if ((bits & 2L) == 0L) {
                    this.graphName(instance.graphName());
                    bits |= 2L;
                }
                this.originalConfig(instance.originalConfig());
                this.fromGraphName(instance.fromGraphName());
                this.nodeFilter(instance.nodeFilter());
                this.putAllParameters(instance.parameters());
                this.relationshipFilter(instance.relationshipFilter());
                this.concurrency(instance.concurrency());
                if ((bits & 1L) == 0L) {
                    this.graphStoreFactory(instance.graphStoreFactory());
                    bits |= 1L;
                }
            }
        }

        public final Builder usernameOverride(@Nullable String usernameOverride) {
            this.usernameOverride = usernameOverride;
            return this;
        }

        public final Builder usernameOverride(Optional<String> usernameOverride) {
            this.usernameOverride = usernameOverride.orElse(null);
            return this;
        }

        public final Builder sudo(boolean sudo) {
            this.sudo = sudo;
            this.optBits |= 1L;
            return this;
        }

        public final Builder configKeys(Collection<String> configKeys) {
            this.configKeys = Objects.requireNonNull(configKeys, "configKeys");
            return this;
        }

        public final Builder jobId(JobId jobId) {
            this.jobId = Objects.requireNonNull(jobId, "jobId");
            return this;
        }

        public final Builder username(String username) {
            this.username = Objects.requireNonNull(username, "username");
            return this;
        }

        public final Builder readConcurrency(int readConcurrency) {
            this.readConcurrency = readConcurrency;
            this.optBits |= 2L;
            return this;
        }

        public final Builder graphName(String graphName) {
            this.graphName = Objects.requireNonNull(graphName, "graphName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder fromGraphName(String fromGraphName) {
            this.fromGraphName = Objects.requireNonNull(fromGraphName, "fromGraphName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder nodeFilter(String nodeFilter) {
            this.nodeFilter = Objects.requireNonNull(nodeFilter, "nodeFilter");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder relationshipFilter(String relationshipFilter) {
            this.relationshipFilter = Objects.requireNonNull(relationshipFilter, "relationshipFilter");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder originalConfig(GraphProjectConfig originalConfig) {
            this.originalConfig = Objects.requireNonNull(originalConfig, "originalConfig");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.optBits |= 4L;
            return this;
        }

        public final Builder putParameter(String key, Object value) {
            if (this.parameters == null) {
                this.parameters = new LinkedHashMap<String, Object>();
            }
            this.parameters.put(Objects.requireNonNull(key, "parameters key"), Objects.requireNonNull(value, "parameters value"));
            this.optBits |= 8L;
            return this;
        }

        public final Builder putParameter(Map.Entry<String, ? extends Object> entry) {
            if (this.parameters == null) {
                this.parameters = new LinkedHashMap<String, Object>();
            }
            String k = entry.getKey();
            Object v = entry.getValue();
            this.parameters.put(Objects.requireNonNull(k, "parameters key"), Objects.requireNonNull(v, "parameters value"));
            this.optBits |= 8L;
            return this;
        }

        public final Builder parameters(Map<String, ? extends Object> entries) {
            this.parameters = new LinkedHashMap<String, Object>();
            this.optBits |= 8L;
            return this.putAllParameters(entries);
        }

        public final Builder putAllParameters(Map<String, ? extends Object> entries) {
            if (this.parameters == null) {
                this.parameters = new LinkedHashMap<String, Object>();
            }
            for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
                String k = e.getKey();
                Object v = e.getValue();
                this.parameters.put(Objects.requireNonNull(k, "parameters key"), Objects.requireNonNull(v, "parameters value"));
            }
            this.optBits |= 8L;
            return this;
        }

        public final Builder graphStoreFactory(GraphStoreFactory.Supplier graphStoreFactory) {
            this.graphStoreFactory = Objects.requireNonNull(graphStoreFactory, "graphStoreFactory");
            return this;
        }

        public Builder clear() {
            this.initBits = 31L;
            this.optBits = 0L;
            this.usernameOverride = null;
            this.sudo = false;
            this.configKeys = null;
            this.jobId = null;
            this.username = null;
            this.readConcurrency = 0;
            this.graphName = null;
            this.fromGraphName = null;
            this.nodeFilter = null;
            this.relationshipFilter = null;
            this.originalConfig = null;
            this.concurrency = 0;
            if (this.parameters != null) {
                this.parameters.clear();
            }
            this.graphStoreFactory = null;
            return this;
        }

        public GraphProjectFromGraphConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableGraphProjectFromGraphConfig.validate(new ImmutableGraphProjectFromGraphConfig(this));
        }

        private boolean sudoIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean readConcurrencyIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean concurrencyIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean parametersIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("graphName");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("fromGraphName");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("nodeFilter");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("relationshipFilter");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("originalConfig");
            }
            return "Cannot build GraphProjectFromGraphConfig, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="GraphProjectFromGraphConfig", generator="Immutables")
    private final class InitShim {
        private byte sudoBuildStage = 0;
        private boolean sudo;
        private byte configKeysBuildStage = 0;
        private Collection<String> configKeys;
        private byte toMapBuildStage = 0;
        private Map<String, Object> toMap;
        private byte jobIdBuildStage = 0;
        private JobId jobId;
        private byte usernameBuildStage = 0;
        private String username;
        private byte readConcurrencyBuildStage = 0;
        private int readConcurrency;
        private byte creationTimeBuildStage = 0;
        private ZonedDateTime creationTime;
        private byte concurrencyBuildStage = 0;
        private int concurrency;
        private byte parametersBuildStage = 0;
        private Map<String, Object> parameters;
        private byte graphStoreFactoryBuildStage = 0;
        private GraphStoreFactory.Supplier graphStoreFactory;

        private InitShim() {
        }

        boolean sudo() {
            if (this.sudoBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sudoBuildStage == 0) {
                this.sudoBuildStage = (byte)-1;
                this.sudo = ImmutableGraphProjectFromGraphConfig.this.sudoInitialize();
                this.sudoBuildStage = 1;
            }
            return this.sudo;
        }

        void sudo(boolean sudo) {
            this.sudo = sudo;
            this.sudoBuildStage = 1;
        }

        Collection<String> configKeys() {
            if (this.configKeysBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.configKeysBuildStage == 0) {
                this.configKeysBuildStage = (byte)-1;
                this.configKeys = Objects.requireNonNull(ImmutableGraphProjectFromGraphConfig.this.configKeysInitialize(), "configKeys");
                this.configKeysBuildStage = 1;
            }
            return this.configKeys;
        }

        void configKeys(Collection<String> configKeys) {
            this.configKeys = configKeys;
            this.configKeysBuildStage = 1;
        }

        Map<String, Object> toMap() {
            if (this.toMapBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.toMapBuildStage == 0) {
                this.toMapBuildStage = (byte)-1;
                this.toMap = Objects.requireNonNull(ImmutableGraphProjectFromGraphConfig.this.toMapInitialize(), "toMap");
                this.toMapBuildStage = 1;
            }
            return this.toMap;
        }

        JobId jobId() {
            if (this.jobIdBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.jobIdBuildStage == 0) {
                this.jobIdBuildStage = (byte)-1;
                this.jobId = Objects.requireNonNull(ImmutableGraphProjectFromGraphConfig.this.jobIdInitialize(), "jobId");
                this.jobIdBuildStage = 1;
            }
            return this.jobId;
        }

        void jobId(JobId jobId) {
            this.jobId = jobId;
            this.jobIdBuildStage = 1;
        }

        String username() {
            if (this.usernameBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.usernameBuildStage == 0) {
                this.usernameBuildStage = (byte)-1;
                this.username = Objects.requireNonNull(ImmutableGraphProjectFromGraphConfig.this.usernameInitialize(), "username");
                this.usernameBuildStage = 1;
            }
            return this.username;
        }

        void username(String username) {
            this.username = username;
            this.usernameBuildStage = 1;
        }

        int readConcurrency() {
            if (this.readConcurrencyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.readConcurrencyBuildStage == 0) {
                this.readConcurrencyBuildStage = (byte)-1;
                this.readConcurrency = ImmutableGraphProjectFromGraphConfig.this.readConcurrencyInitialize();
                this.readConcurrencyBuildStage = 1;
            }
            return this.readConcurrency;
        }

        void readConcurrency(int readConcurrency) {
            this.readConcurrency = readConcurrency;
            this.readConcurrencyBuildStage = 1;
        }

        ZonedDateTime creationTime() {
            if (this.creationTimeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.creationTimeBuildStage == 0) {
                this.creationTimeBuildStage = (byte)-1;
                this.creationTime = Objects.requireNonNull(ImmutableGraphProjectFromGraphConfig.this.creationTimeInitialize(), "creationTime");
                this.creationTimeBuildStage = 1;
            }
            return this.creationTime;
        }

        int concurrency() {
            if (this.concurrencyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.concurrencyBuildStage == 0) {
                this.concurrencyBuildStage = (byte)-1;
                this.concurrency = ImmutableGraphProjectFromGraphConfig.this.concurrencyInitialize();
                this.concurrencyBuildStage = 1;
            }
            return this.concurrency;
        }

        void concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.concurrencyBuildStage = 1;
        }

        Map<String, Object> parameters() {
            if (this.parametersBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.parametersBuildStage == 0) {
                this.parametersBuildStage = (byte)-1;
                this.parameters = ImmutableGraphProjectFromGraphConfig.createUnmodifiableMap(true, false, ImmutableGraphProjectFromGraphConfig.this.parametersInitialize());
                this.parametersBuildStage = 1;
            }
            return this.parameters;
        }

        void parameters(Map<String, Object> parameters) {
            this.parameters = parameters;
            this.parametersBuildStage = 1;
        }

        GraphStoreFactory.Supplier graphStoreFactory() {
            if (this.graphStoreFactoryBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.graphStoreFactoryBuildStage == 0) {
                this.graphStoreFactoryBuildStage = (byte)-1;
                this.graphStoreFactory = Objects.requireNonNull(ImmutableGraphProjectFromGraphConfig.this.graphStoreFactoryInitialize(), "graphStoreFactory");
                this.graphStoreFactoryBuildStage = 1;
            }
            return this.graphStoreFactory;
        }

        void graphStoreFactory(GraphStoreFactory.Supplier graphStoreFactory) {
            this.graphStoreFactory = graphStoreFactory;
            this.graphStoreFactoryBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.sudoBuildStage == -1) {
                attributes.add("sudo");
            }
            if (this.configKeysBuildStage == -1) {
                attributes.add("configKeys");
            }
            if (this.toMapBuildStage == -1) {
                attributes.add("toMap");
            }
            if (this.jobIdBuildStage == -1) {
                attributes.add("jobId");
            }
            if (this.usernameBuildStage == -1) {
                attributes.add("username");
            }
            if (this.readConcurrencyBuildStage == -1) {
                attributes.add("readConcurrency");
            }
            if (this.creationTimeBuildStage == -1) {
                attributes.add("creationTime");
            }
            if (this.concurrencyBuildStage == -1) {
                attributes.add("concurrency");
            }
            if (this.parametersBuildStage == -1) {
                attributes.add("parameters");
            }
            if (this.graphStoreFactoryBuildStage == -1) {
                attributes.add("graphStoreFactory");
            }
            return "Cannot build GraphProjectFromGraphConfig, attribute initializers form cycle " + attributes;
        }
    }
}

