/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.config;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.GraphProjectConfig;
import org.neo4j.gds.config.GraphProjectFromCypherConfig;
import org.neo4j.gds.config.JobIdConfig;
import org.neo4j.gds.core.utils.progress.JobId;

@ParametersAreNonnullByDefault
@Generated(from="GraphProjectFromCypherConfig", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableGraphProjectFromCypherConfig
implements GraphProjectFromCypherConfig {
    @Nullable
    private final String usernameOverride;
    private final Collection<String> configKeys;
    private final transient Map<String, Object> toMap;
    private final JobId jobId;
    private final String username;
    private final String graphName;
    private final int readConcurrency;
    private final long nodeCount;
    private final long relationshipCount;
    private final transient ZonedDateTime creationTime;
    private final String nodeQuery;
    private final String relationshipQuery;
    private final Map<String, Object> parameters;
    private final boolean validateRelationships;
    private final boolean sudo;
    private final transient Set<String> outputFieldDenylist;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableGraphProjectFromCypherConfig(String username, String graphName, String nodeQuery, String relationshipQuery, Map<String, ? extends Object> parameters) {
        this.initShim.username(Objects.requireNonNull(username, "username"));
        this.graphName = Objects.requireNonNull(graphName, "graphName");
        this.nodeQuery = Objects.requireNonNull(nodeQuery, "nodeQuery");
        this.relationshipQuery = Objects.requireNonNull(relationshipQuery, "relationshipQuery");
        this.initShim.parameters(ImmutableGraphProjectFromCypherConfig.createUnmodifiableMap(true, false, parameters));
        this.usernameOverride = null;
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.jobId = this.initShim.jobId();
        this.username = this.initShim.username();
        this.readConcurrency = this.initShim.readConcurrency();
        this.nodeCount = this.initShim.nodeCount();
        this.relationshipCount = this.initShim.relationshipCount();
        this.creationTime = this.initShim.creationTime();
        this.parameters = this.initShim.parameters();
        this.validateRelationships = this.initShim.validateRelationships();
        this.sudo = this.initShim.sudo();
        this.outputFieldDenylist = this.initShim.outputFieldDenylist();
        this.initShim = null;
    }

    private ImmutableGraphProjectFromCypherConfig(Builder builder) {
        this.usernameOverride = builder.usernameOverride;
        this.graphName = builder.graphName;
        this.nodeQuery = builder.nodeQuery;
        this.relationshipQuery = builder.relationshipQuery;
        if (builder.configKeys != null) {
            this.initShim.configKeys(builder.configKeys);
        }
        if (builder.jobId != null) {
            this.initShim.jobId(builder.jobId);
        }
        if (builder.username != null) {
            this.initShim.username(builder.username);
        }
        if (builder.readConcurrencyIsSet()) {
            this.initShim.readConcurrency(builder.readConcurrency);
        }
        if (builder.nodeCountIsSet()) {
            this.initShim.nodeCount(builder.nodeCount);
        }
        if (builder.relationshipCountIsSet()) {
            this.initShim.relationshipCount(builder.relationshipCount);
        }
        if (builder.parametersIsSet()) {
            this.initShim.parameters(builder.parameters == null ? Collections.emptyMap() : ImmutableGraphProjectFromCypherConfig.createUnmodifiableMap(false, false, builder.parameters));
        }
        if (builder.validateRelationshipsIsSet()) {
            this.initShim.validateRelationships(builder.validateRelationships);
        }
        if (builder.sudoIsSet()) {
            this.initShim.sudo(builder.sudo);
        }
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.jobId = this.initShim.jobId();
        this.username = this.initShim.username();
        this.readConcurrency = this.initShim.readConcurrency();
        this.nodeCount = this.initShim.nodeCount();
        this.relationshipCount = this.initShim.relationshipCount();
        this.creationTime = this.initShim.creationTime();
        this.parameters = this.initShim.parameters();
        this.validateRelationships = this.initShim.validateRelationships();
        this.sudo = this.initShim.sudo();
        this.outputFieldDenylist = this.initShim.outputFieldDenylist();
        this.initShim = null;
    }

    private ImmutableGraphProjectFromCypherConfig(@Nullable String usernameOverride, Collection<String> configKeys, JobId jobId, String username, String graphName, int readConcurrency, long nodeCount, long relationshipCount, String nodeQuery, String relationshipQuery, Map<String, Object> parameters, boolean validateRelationships, boolean sudo) {
        this.usernameOverride = usernameOverride;
        this.initShim.configKeys(configKeys);
        this.initShim.jobId(jobId);
        this.initShim.username(username);
        this.graphName = graphName;
        this.initShim.readConcurrency(readConcurrency);
        this.initShim.nodeCount(nodeCount);
        this.initShim.relationshipCount(relationshipCount);
        this.nodeQuery = nodeQuery;
        this.relationshipQuery = relationshipQuery;
        this.initShim.parameters(parameters);
        this.initShim.validateRelationships(validateRelationships);
        this.initShim.sudo(sudo);
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.jobId = this.initShim.jobId();
        this.username = this.initShim.username();
        this.readConcurrency = this.initShim.readConcurrency();
        this.nodeCount = this.initShim.nodeCount();
        this.relationshipCount = this.initShim.relationshipCount();
        this.creationTime = this.initShim.creationTime();
        this.parameters = this.initShim.parameters();
        this.validateRelationships = this.initShim.validateRelationships();
        this.sudo = this.initShim.sudo();
        this.outputFieldDenylist = this.initShim.outputFieldDenylist();
        this.initShim = null;
    }

    private Collection<String> configKeysInitialize() {
        return GraphProjectFromCypherConfig.super.configKeys();
    }

    private Map<String, Object> toMapInitialize() {
        return GraphProjectFromCypherConfig.super.toMap();
    }

    private JobId jobIdInitialize() {
        return GraphProjectFromCypherConfig.super.jobId();
    }

    private String usernameInitialize() {
        return GraphProjectFromCypherConfig.super.username();
    }

    private int readConcurrencyInitialize() {
        return GraphProjectFromCypherConfig.super.readConcurrency();
    }

    private long nodeCountInitialize() {
        return GraphProjectFromCypherConfig.super.nodeCount();
    }

    private long relationshipCountInitialize() {
        return GraphProjectFromCypherConfig.super.relationshipCount();
    }

    private ZonedDateTime creationTimeInitialize() {
        return GraphProjectFromCypherConfig.super.creationTime();
    }

    private Map<String, Object> parametersInitialize() {
        return GraphProjectFromCypherConfig.super.parameters();
    }

    private boolean validateRelationshipsInitialize() {
        return GraphProjectFromCypherConfig.super.validateRelationships();
    }

    private boolean sudoInitialize() {
        return GraphProjectFromCypherConfig.super.sudo();
    }

    private Set<String> outputFieldDenylistInitialize() {
        return GraphProjectFromCypherConfig.super.outputFieldDenylist();
    }

    public Optional<String> usernameOverride() {
        return Optional.ofNullable(this.usernameOverride);
    }

    public Collection<String> configKeys() {
        InitShim shim = this.initShim;
        return shim != null ? shim.configKeys() : this.configKeys;
    }

    public Map<String, Object> toMap() {
        InitShim shim = this.initShim;
        return shim != null ? shim.toMap() : this.toMap;
    }

    @Override
    public JobId jobId() {
        InitShim shim = this.initShim;
        return shim != null ? shim.jobId() : this.jobId;
    }

    @Override
    public String username() {
        InitShim shim = this.initShim;
        return shim != null ? shim.username() : this.username;
    }

    @Override
    public String graphName() {
        return this.graphName;
    }

    @Override
    public int readConcurrency() {
        InitShim shim = this.initShim;
        return shim != null ? shim.readConcurrency() : this.readConcurrency;
    }

    @Override
    public long nodeCount() {
        InitShim shim = this.initShim;
        return shim != null ? shim.nodeCount() : this.nodeCount;
    }

    @Override
    public long relationshipCount() {
        InitShim shim = this.initShim;
        return shim != null ? shim.relationshipCount() : this.relationshipCount;
    }

    @Override
    public ZonedDateTime creationTime() {
        InitShim shim = this.initShim;
        return shim != null ? shim.creationTime() : this.creationTime;
    }

    @Override
    public String nodeQuery() {
        return this.nodeQuery;
    }

    @Override
    public String relationshipQuery() {
        return this.relationshipQuery;
    }

    @Override
    public Map<String, Object> parameters() {
        InitShim shim = this.initShim;
        return shim != null ? shim.parameters() : this.parameters;
    }

    @Override
    public boolean validateRelationships() {
        InitShim shim = this.initShim;
        return shim != null ? shim.validateRelationships() : this.validateRelationships;
    }

    @Override
    public boolean sudo() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sudo() : this.sudo;
    }

    @Override
    public Set<String> outputFieldDenylist() {
        InitShim shim = this.initShim;
        return shim != null ? shim.outputFieldDenylist() : this.outputFieldDenylist;
    }

    public final ImmutableGraphProjectFromCypherConfig withUsernameOverride(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.usernameOverride, newValue)) {
            return this;
        }
        return ImmutableGraphProjectFromCypherConfig.validate(new ImmutableGraphProjectFromCypherConfig(newValue, this.configKeys, this.jobId, this.username, this.graphName, this.readConcurrency, this.nodeCount, this.relationshipCount, this.nodeQuery, this.relationshipQuery, this.parameters, this.validateRelationships, this.sudo));
    }

    public final ImmutableGraphProjectFromCypherConfig withUsernameOverride(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.usernameOverride, value)) {
            return this;
        }
        return ImmutableGraphProjectFromCypherConfig.validate(new ImmutableGraphProjectFromCypherConfig(value, this.configKeys, this.jobId, this.username, this.graphName, this.readConcurrency, this.nodeCount, this.relationshipCount, this.nodeQuery, this.relationshipQuery, this.parameters, this.validateRelationships, this.sudo));
    }

    public final ImmutableGraphProjectFromCypherConfig withConfigKeys(Collection<String> value) {
        if (this.configKeys == value) {
            return this;
        }
        Collection<String> newValue = Objects.requireNonNull(value, "configKeys");
        return ImmutableGraphProjectFromCypherConfig.validate(new ImmutableGraphProjectFromCypherConfig(this.usernameOverride, newValue, this.jobId, this.username, this.graphName, this.readConcurrency, this.nodeCount, this.relationshipCount, this.nodeQuery, this.relationshipQuery, this.parameters, this.validateRelationships, this.sudo));
    }

    public final ImmutableGraphProjectFromCypherConfig withJobId(JobId value) {
        if (this.jobId == value) {
            return this;
        }
        JobId newValue = Objects.requireNonNull(value, "jobId");
        return ImmutableGraphProjectFromCypherConfig.validate(new ImmutableGraphProjectFromCypherConfig(this.usernameOverride, this.configKeys, newValue, this.username, this.graphName, this.readConcurrency, this.nodeCount, this.relationshipCount, this.nodeQuery, this.relationshipQuery, this.parameters, this.validateRelationships, this.sudo));
    }

    public final ImmutableGraphProjectFromCypherConfig withUsername(String value) {
        String newValue = Objects.requireNonNull(value, "username");
        if (this.username.equals(newValue)) {
            return this;
        }
        return ImmutableGraphProjectFromCypherConfig.validate(new ImmutableGraphProjectFromCypherConfig(this.usernameOverride, this.configKeys, this.jobId, newValue, this.graphName, this.readConcurrency, this.nodeCount, this.relationshipCount, this.nodeQuery, this.relationshipQuery, this.parameters, this.validateRelationships, this.sudo));
    }

    public final ImmutableGraphProjectFromCypherConfig withGraphName(String value) {
        String newValue = Objects.requireNonNull(value, "graphName");
        if (this.graphName.equals(newValue)) {
            return this;
        }
        return ImmutableGraphProjectFromCypherConfig.validate(new ImmutableGraphProjectFromCypherConfig(this.usernameOverride, this.configKeys, this.jobId, this.username, newValue, this.readConcurrency, this.nodeCount, this.relationshipCount, this.nodeQuery, this.relationshipQuery, this.parameters, this.validateRelationships, this.sudo));
    }

    public final ImmutableGraphProjectFromCypherConfig withReadConcurrency(int value) {
        if (this.readConcurrency == value) {
            return this;
        }
        return ImmutableGraphProjectFromCypherConfig.validate(new ImmutableGraphProjectFromCypherConfig(this.usernameOverride, this.configKeys, this.jobId, this.username, this.graphName, value, this.nodeCount, this.relationshipCount, this.nodeQuery, this.relationshipQuery, this.parameters, this.validateRelationships, this.sudo));
    }

    public final ImmutableGraphProjectFromCypherConfig withNodeCount(long value) {
        if (this.nodeCount == value) {
            return this;
        }
        return ImmutableGraphProjectFromCypherConfig.validate(new ImmutableGraphProjectFromCypherConfig(this.usernameOverride, this.configKeys, this.jobId, this.username, this.graphName, this.readConcurrency, value, this.relationshipCount, this.nodeQuery, this.relationshipQuery, this.parameters, this.validateRelationships, this.sudo));
    }

    public final ImmutableGraphProjectFromCypherConfig withRelationshipCount(long value) {
        if (this.relationshipCount == value) {
            return this;
        }
        return ImmutableGraphProjectFromCypherConfig.validate(new ImmutableGraphProjectFromCypherConfig(this.usernameOverride, this.configKeys, this.jobId, this.username, this.graphName, this.readConcurrency, this.nodeCount, value, this.nodeQuery, this.relationshipQuery, this.parameters, this.validateRelationships, this.sudo));
    }

    public final ImmutableGraphProjectFromCypherConfig withNodeQuery(String value) {
        String newValue = Objects.requireNonNull(value, "nodeQuery");
        if (this.nodeQuery.equals(newValue)) {
            return this;
        }
        return ImmutableGraphProjectFromCypherConfig.validate(new ImmutableGraphProjectFromCypherConfig(this.usernameOverride, this.configKeys, this.jobId, this.username, this.graphName, this.readConcurrency, this.nodeCount, this.relationshipCount, newValue, this.relationshipQuery, this.parameters, this.validateRelationships, this.sudo));
    }

    public final ImmutableGraphProjectFromCypherConfig withRelationshipQuery(String value) {
        String newValue = Objects.requireNonNull(value, "relationshipQuery");
        if (this.relationshipQuery.equals(newValue)) {
            return this;
        }
        return ImmutableGraphProjectFromCypherConfig.validate(new ImmutableGraphProjectFromCypherConfig(this.usernameOverride, this.configKeys, this.jobId, this.username, this.graphName, this.readConcurrency, this.nodeCount, this.relationshipCount, this.nodeQuery, newValue, this.parameters, this.validateRelationships, this.sudo));
    }

    public final ImmutableGraphProjectFromCypherConfig withParameters(Map<String, ? extends Object> entries) {
        if (this.parameters == entries) {
            return this;
        }
        Map<String, Object> newValue = ImmutableGraphProjectFromCypherConfig.createUnmodifiableMap(true, false, entries);
        return ImmutableGraphProjectFromCypherConfig.validate(new ImmutableGraphProjectFromCypherConfig(this.usernameOverride, this.configKeys, this.jobId, this.username, this.graphName, this.readConcurrency, this.nodeCount, this.relationshipCount, this.nodeQuery, this.relationshipQuery, newValue, this.validateRelationships, this.sudo));
    }

    public final ImmutableGraphProjectFromCypherConfig withValidateRelationships(boolean value) {
        if (this.validateRelationships == value) {
            return this;
        }
        return ImmutableGraphProjectFromCypherConfig.validate(new ImmutableGraphProjectFromCypherConfig(this.usernameOverride, this.configKeys, this.jobId, this.username, this.graphName, this.readConcurrency, this.nodeCount, this.relationshipCount, this.nodeQuery, this.relationshipQuery, this.parameters, value, this.sudo));
    }

    public final ImmutableGraphProjectFromCypherConfig withSudo(boolean value) {
        if (this.sudo == value) {
            return this;
        }
        return ImmutableGraphProjectFromCypherConfig.validate(new ImmutableGraphProjectFromCypherConfig(this.usernameOverride, this.configKeys, this.jobId, this.username, this.graphName, this.readConcurrency, this.nodeCount, this.relationshipCount, this.nodeQuery, this.relationshipQuery, this.parameters, this.validateRelationships, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGraphProjectFromCypherConfig && this.equalTo((ImmutableGraphProjectFromCypherConfig)another);
    }

    private boolean equalTo(ImmutableGraphProjectFromCypherConfig another) {
        return Objects.equals(this.usernameOverride, another.usernameOverride) && this.jobId.equals(another.jobId) && this.username.equals(another.username) && this.graphName.equals(another.graphName) && this.readConcurrency == another.readConcurrency && this.nodeCount == another.nodeCount && this.relationshipCount == another.relationshipCount && this.nodeQuery.equals(another.nodeQuery) && this.relationshipQuery.equals(another.relationshipQuery) && this.parameters.equals(another.parameters) && this.validateRelationships == another.validateRelationships && this.sudo == another.sudo && this.outputFieldDenylist.equals(another.outputFieldDenylist);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.usernameOverride);
        h += (h << 5) + this.jobId.hashCode();
        h += (h << 5) + this.username.hashCode();
        h += (h << 5) + this.graphName.hashCode();
        h += (h << 5) + this.readConcurrency;
        h += (h << 5) + Long.hashCode(this.nodeCount);
        h += (h << 5) + Long.hashCode(this.relationshipCount);
        h += (h << 5) + this.nodeQuery.hashCode();
        h += (h << 5) + this.relationshipQuery.hashCode();
        h += (h << 5) + this.parameters.hashCode();
        h += (h << 5) + Boolean.hashCode(this.validateRelationships);
        h += (h << 5) + Boolean.hashCode(this.sudo);
        h += (h << 5) + this.outputFieldDenylist.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("GraphProjectFromCypherConfig{");
        if (this.usernameOverride != null) {
            builder.append("usernameOverride=").append(this.usernameOverride);
        }
        if (builder.length() > 29) {
            builder.append(", ");
        }
        builder.append("jobId=").append(this.jobId);
        builder.append(", ");
        builder.append("username=").append(this.username);
        builder.append(", ");
        builder.append("graphName=").append(this.graphName);
        builder.append(", ");
        builder.append("readConcurrency=").append(this.readConcurrency);
        builder.append(", ");
        builder.append("nodeCount=").append(this.nodeCount);
        builder.append(", ");
        builder.append("relationshipCount=").append(this.relationshipCount);
        builder.append(", ");
        builder.append("nodeQuery=").append(this.nodeQuery);
        builder.append(", ");
        builder.append("relationshipQuery=").append(this.relationshipQuery);
        builder.append(", ");
        builder.append("parameters=").append(this.parameters);
        builder.append(", ");
        builder.append("validateRelationships=").append(this.validateRelationships);
        builder.append(", ");
        builder.append("sudo=").append(this.sudo);
        builder.append(", ");
        builder.append("outputFieldDenylist=").append(this.outputFieldDenylist);
        return builder.append("}").toString();
    }

    public static GraphProjectFromCypherConfig of(String username, String graphName, String nodeQuery, String relationshipQuery, Map<String, ? extends Object> parameters) {
        return ImmutableGraphProjectFromCypherConfig.validate(new ImmutableGraphProjectFromCypherConfig(username, graphName, nodeQuery, relationshipQuery, parameters));
    }

    private static ImmutableGraphProjectFromCypherConfig validate(ImmutableGraphProjectFromCypherConfig instance) {
        instance.validateReadConcurrency();
        return instance;
    }

    public static GraphProjectFromCypherConfig copyOf(GraphProjectFromCypherConfig instance) {
        if (instance instanceof ImmutableGraphProjectFromCypherConfig) {
            return (ImmutableGraphProjectFromCypherConfig)instance;
        }
        return ImmutableGraphProjectFromCypherConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="GraphProjectFromCypherConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_GRAPH_NAME = 1L;
        private static final long INIT_BIT_NODE_QUERY = 2L;
        private static final long INIT_BIT_RELATIONSHIP_QUERY = 4L;
        private static final long OPT_BIT_READ_CONCURRENCY = 1L;
        private static final long OPT_BIT_NODE_COUNT = 2L;
        private static final long OPT_BIT_RELATIONSHIP_COUNT = 4L;
        private static final long OPT_BIT_PARAMETERS = 8L;
        private static final long OPT_BIT_VALIDATE_RELATIONSHIPS = 16L;
        private static final long OPT_BIT_SUDO = 32L;
        private long initBits = 7L;
        private long optBits;
        @Nullable
        private String usernameOverride;
        @Nullable
        private Collection<String> configKeys;
        @Nullable
        private JobId jobId;
        @Nullable
        private String username;
        @Nullable
        private String graphName;
        private int readConcurrency;
        private long nodeCount;
        private long relationshipCount;
        @Nullable
        private String nodeQuery;
        @Nullable
        private String relationshipQuery;
        private Map<String, Object> parameters = null;
        private boolean validateRelationships;
        private boolean sudo;

        private Builder() {
        }

        public final Builder from(GraphProjectConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(JobIdConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(GraphProjectFromCypherConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            JobIdConfig instance;
            long bits = 0L;
            if (object instanceof GraphProjectConfig) {
                instance = (GraphProjectConfig)object;
                this.graphName(instance.graphName());
                this.nodeCount(instance.nodeCount());
                this.readConcurrency(instance.readConcurrency());
                if ((bits & 1L) == 0L) {
                    this.validateRelationships(instance.validateRelationships());
                    bits |= 1L;
                }
                this.relationshipCount(instance.relationshipCount());
                this.username(instance.username());
            }
            if (object instanceof JobIdConfig) {
                instance = (JobIdConfig)object;
                this.jobId(instance.jobId());
            }
            if (object instanceof GraphProjectFromCypherConfig) {
                instance = (GraphProjectFromCypherConfig)object;
                this.relationshipQuery(instance.relationshipQuery());
                this.nodeQuery(instance.nodeQuery());
                if ((bits & 2L) == 0L) {
                    this.sudo(instance.sudo());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    this.validateRelationships(instance.validateRelationships());
                    bits |= 1L;
                }
                this.putAllParameters(instance.parameters());
            }
            if (object instanceof BaseConfig) {
                instance = (BaseConfig)object;
                Optional usernameOverrideOptional = instance.usernameOverride();
                if (usernameOverrideOptional.isPresent()) {
                    this.usernameOverride(usernameOverrideOptional);
                }
                this.configKeys(instance.configKeys());
                if ((bits & 2L) == 0L) {
                    this.sudo(instance.sudo());
                    bits |= 2L;
                }
            }
        }

        public final Builder usernameOverride(@Nullable String usernameOverride) {
            this.usernameOverride = usernameOverride;
            return this;
        }

        public final Builder usernameOverride(Optional<String> usernameOverride) {
            this.usernameOverride = usernameOverride.orElse(null);
            return this;
        }

        public final Builder configKeys(Collection<String> configKeys) {
            this.configKeys = Objects.requireNonNull(configKeys, "configKeys");
            return this;
        }

        public final Builder jobId(JobId jobId) {
            this.jobId = Objects.requireNonNull(jobId, "jobId");
            return this;
        }

        public final Builder username(String username) {
            this.username = Objects.requireNonNull(username, "username");
            return this;
        }

        public final Builder graphName(String graphName) {
            this.graphName = Objects.requireNonNull(graphName, "graphName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder readConcurrency(int readConcurrency) {
            this.readConcurrency = readConcurrency;
            this.optBits |= 1L;
            return this;
        }

        public final Builder nodeCount(long nodeCount) {
            this.nodeCount = nodeCount;
            this.optBits |= 2L;
            return this;
        }

        public final Builder relationshipCount(long relationshipCount) {
            this.relationshipCount = relationshipCount;
            this.optBits |= 4L;
            return this;
        }

        public final Builder nodeQuery(String nodeQuery) {
            this.nodeQuery = Objects.requireNonNull(nodeQuery, "nodeQuery");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder relationshipQuery(String relationshipQuery) {
            this.relationshipQuery = Objects.requireNonNull(relationshipQuery, "relationshipQuery");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder putParameter(String key, Object value) {
            if (this.parameters == null) {
                this.parameters = new LinkedHashMap<String, Object>();
            }
            this.parameters.put(Objects.requireNonNull(key, "parameters key"), Objects.requireNonNull(value, "parameters value"));
            this.optBits |= 8L;
            return this;
        }

        public final Builder putParameter(Map.Entry<String, ? extends Object> entry) {
            if (this.parameters == null) {
                this.parameters = new LinkedHashMap<String, Object>();
            }
            String k = entry.getKey();
            Object v = entry.getValue();
            this.parameters.put(Objects.requireNonNull(k, "parameters key"), Objects.requireNonNull(v, "parameters value"));
            this.optBits |= 8L;
            return this;
        }

        public final Builder parameters(Map<String, ? extends Object> entries) {
            this.parameters = new LinkedHashMap<String, Object>();
            this.optBits |= 8L;
            return this.putAllParameters(entries);
        }

        public final Builder putAllParameters(Map<String, ? extends Object> entries) {
            if (this.parameters == null) {
                this.parameters = new LinkedHashMap<String, Object>();
            }
            for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
                String k = e.getKey();
                Object v = e.getValue();
                this.parameters.put(Objects.requireNonNull(k, "parameters key"), Objects.requireNonNull(v, "parameters value"));
            }
            this.optBits |= 8L;
            return this;
        }

        public final Builder validateRelationships(boolean validateRelationships) {
            this.validateRelationships = validateRelationships;
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder sudo(boolean sudo) {
            this.sudo = sudo;
            this.optBits |= 0x20L;
            return this;
        }

        public Builder clear() {
            this.initBits = 7L;
            this.optBits = 0L;
            this.usernameOverride = null;
            this.configKeys = null;
            this.jobId = null;
            this.username = null;
            this.graphName = null;
            this.readConcurrency = 0;
            this.nodeCount = 0L;
            this.relationshipCount = 0L;
            this.nodeQuery = null;
            this.relationshipQuery = null;
            if (this.parameters != null) {
                this.parameters.clear();
            }
            this.validateRelationships = false;
            this.sudo = false;
            return this;
        }

        public GraphProjectFromCypherConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableGraphProjectFromCypherConfig.validate(new ImmutableGraphProjectFromCypherConfig(this));
        }

        private boolean readConcurrencyIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean nodeCountIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean relationshipCountIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean parametersIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean validateRelationshipsIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean sudoIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("graphName");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("nodeQuery");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("relationshipQuery");
            }
            return "Cannot build GraphProjectFromCypherConfig, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="GraphProjectFromCypherConfig", generator="Immutables")
    private final class InitShim {
        private byte configKeysBuildStage = 0;
        private Collection<String> configKeys;
        private byte toMapBuildStage = 0;
        private Map<String, Object> toMap;
        private byte jobIdBuildStage = 0;
        private JobId jobId;
        private byte usernameBuildStage = 0;
        private String username;
        private byte readConcurrencyBuildStage = 0;
        private int readConcurrency;
        private byte nodeCountBuildStage = 0;
        private long nodeCount;
        private byte relationshipCountBuildStage = 0;
        private long relationshipCount;
        private byte creationTimeBuildStage = 0;
        private ZonedDateTime creationTime;
        private byte parametersBuildStage = 0;
        private Map<String, Object> parameters;
        private byte validateRelationshipsBuildStage = 0;
        private boolean validateRelationships;
        private byte sudoBuildStage = 0;
        private boolean sudo;
        private byte outputFieldDenylistBuildStage = 0;
        private Set<String> outputFieldDenylist;

        private InitShim() {
        }

        Collection<String> configKeys() {
            if (this.configKeysBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.configKeysBuildStage == 0) {
                this.configKeysBuildStage = (byte)-1;
                this.configKeys = Objects.requireNonNull(ImmutableGraphProjectFromCypherConfig.this.configKeysInitialize(), "configKeys");
                this.configKeysBuildStage = 1;
            }
            return this.configKeys;
        }

        void configKeys(Collection<String> configKeys) {
            this.configKeys = configKeys;
            this.configKeysBuildStage = 1;
        }

        Map<String, Object> toMap() {
            if (this.toMapBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.toMapBuildStage == 0) {
                this.toMapBuildStage = (byte)-1;
                this.toMap = Objects.requireNonNull(ImmutableGraphProjectFromCypherConfig.this.toMapInitialize(), "toMap");
                this.toMapBuildStage = 1;
            }
            return this.toMap;
        }

        JobId jobId() {
            if (this.jobIdBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.jobIdBuildStage == 0) {
                this.jobIdBuildStage = (byte)-1;
                this.jobId = Objects.requireNonNull(ImmutableGraphProjectFromCypherConfig.this.jobIdInitialize(), "jobId");
                this.jobIdBuildStage = 1;
            }
            return this.jobId;
        }

        void jobId(JobId jobId) {
            this.jobId = jobId;
            this.jobIdBuildStage = 1;
        }

        String username() {
            if (this.usernameBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.usernameBuildStage == 0) {
                this.usernameBuildStage = (byte)-1;
                this.username = Objects.requireNonNull(ImmutableGraphProjectFromCypherConfig.this.usernameInitialize(), "username");
                this.usernameBuildStage = 1;
            }
            return this.username;
        }

        void username(String username) {
            this.username = username;
            this.usernameBuildStage = 1;
        }

        int readConcurrency() {
            if (this.readConcurrencyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.readConcurrencyBuildStage == 0) {
                this.readConcurrencyBuildStage = (byte)-1;
                this.readConcurrency = ImmutableGraphProjectFromCypherConfig.this.readConcurrencyInitialize();
                this.readConcurrencyBuildStage = 1;
            }
            return this.readConcurrency;
        }

        void readConcurrency(int readConcurrency) {
            this.readConcurrency = readConcurrency;
            this.readConcurrencyBuildStage = 1;
        }

        long nodeCount() {
            if (this.nodeCountBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nodeCountBuildStage == 0) {
                this.nodeCountBuildStage = (byte)-1;
                this.nodeCount = ImmutableGraphProjectFromCypherConfig.this.nodeCountInitialize();
                this.nodeCountBuildStage = 1;
            }
            return this.nodeCount;
        }

        void nodeCount(long nodeCount) {
            this.nodeCount = nodeCount;
            this.nodeCountBuildStage = 1;
        }

        long relationshipCount() {
            if (this.relationshipCountBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relationshipCountBuildStage == 0) {
                this.relationshipCountBuildStage = (byte)-1;
                this.relationshipCount = ImmutableGraphProjectFromCypherConfig.this.relationshipCountInitialize();
                this.relationshipCountBuildStage = 1;
            }
            return this.relationshipCount;
        }

        void relationshipCount(long relationshipCount) {
            this.relationshipCount = relationshipCount;
            this.relationshipCountBuildStage = 1;
        }

        ZonedDateTime creationTime() {
            if (this.creationTimeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.creationTimeBuildStage == 0) {
                this.creationTimeBuildStage = (byte)-1;
                this.creationTime = Objects.requireNonNull(ImmutableGraphProjectFromCypherConfig.this.creationTimeInitialize(), "creationTime");
                this.creationTimeBuildStage = 1;
            }
            return this.creationTime;
        }

        Map<String, Object> parameters() {
            if (this.parametersBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.parametersBuildStage == 0) {
                this.parametersBuildStage = (byte)-1;
                this.parameters = ImmutableGraphProjectFromCypherConfig.createUnmodifiableMap(true, false, ImmutableGraphProjectFromCypherConfig.this.parametersInitialize());
                this.parametersBuildStage = 1;
            }
            return this.parameters;
        }

        void parameters(Map<String, Object> parameters) {
            this.parameters = parameters;
            this.parametersBuildStage = 1;
        }

        boolean validateRelationships() {
            if (this.validateRelationshipsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.validateRelationshipsBuildStage == 0) {
                this.validateRelationshipsBuildStage = (byte)-1;
                this.validateRelationships = ImmutableGraphProjectFromCypherConfig.this.validateRelationshipsInitialize();
                this.validateRelationshipsBuildStage = 1;
            }
            return this.validateRelationships;
        }

        void validateRelationships(boolean validateRelationships) {
            this.validateRelationships = validateRelationships;
            this.validateRelationshipsBuildStage = 1;
        }

        boolean sudo() {
            if (this.sudoBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sudoBuildStage == 0) {
                this.sudoBuildStage = (byte)-1;
                this.sudo = ImmutableGraphProjectFromCypherConfig.this.sudoInitialize();
                this.sudoBuildStage = 1;
            }
            return this.sudo;
        }

        void sudo(boolean sudo) {
            this.sudo = sudo;
            this.sudoBuildStage = 1;
        }

        Set<String> outputFieldDenylist() {
            if (this.outputFieldDenylistBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.outputFieldDenylistBuildStage == 0) {
                this.outputFieldDenylistBuildStage = (byte)-1;
                this.outputFieldDenylist = Objects.requireNonNull(ImmutableGraphProjectFromCypherConfig.this.outputFieldDenylistInitialize(), "outputFieldDenylist");
                this.outputFieldDenylistBuildStage = 1;
            }
            return this.outputFieldDenylist;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.configKeysBuildStage == -1) {
                attributes.add("configKeys");
            }
            if (this.toMapBuildStage == -1) {
                attributes.add("toMap");
            }
            if (this.jobIdBuildStage == -1) {
                attributes.add("jobId");
            }
            if (this.usernameBuildStage == -1) {
                attributes.add("username");
            }
            if (this.readConcurrencyBuildStage == -1) {
                attributes.add("readConcurrency");
            }
            if (this.nodeCountBuildStage == -1) {
                attributes.add("nodeCount");
            }
            if (this.relationshipCountBuildStage == -1) {
                attributes.add("relationshipCount");
            }
            if (this.creationTimeBuildStage == -1) {
                attributes.add("creationTime");
            }
            if (this.parametersBuildStage == -1) {
                attributes.add("parameters");
            }
            if (this.validateRelationshipsBuildStage == -1) {
                attributes.add("validateRelationships");
            }
            if (this.sudoBuildStage == -1) {
                attributes.add("sudo");
            }
            if (this.outputFieldDenylistBuildStage == -1) {
                attributes.add("outputFieldDenylist");
            }
            return "Cannot build GraphProjectFromCypherConfig, attribute initializers form cycle " + attributes;
        }
    }
}

