/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.config;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.config.DeleteRelationshipsConfig;

@ParametersAreNonnullByDefault
@Generated(from="DeleteRelationshipsConfig", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableDeleteRelationshipsConfig
implements DeleteRelationshipsConfig {
    private final String graphName;
    private final String relationshipType;

    private ImmutableDeleteRelationshipsConfig(String graphName, String relationshipType) {
        this.graphName = Objects.requireNonNull(graphName, "graphName");
        this.relationshipType = Objects.requireNonNull(relationshipType, "relationshipType");
    }

    private ImmutableDeleteRelationshipsConfig(ImmutableDeleteRelationshipsConfig original, String graphName, String relationshipType) {
        this.graphName = graphName;
        this.relationshipType = relationshipType;
    }

    @Override
    public String graphName() {
        return this.graphName;
    }

    @Override
    public String relationshipType() {
        return this.relationshipType;
    }

    public final ImmutableDeleteRelationshipsConfig withGraphName(String value) {
        String newValue = Objects.requireNonNull(value, "graphName");
        if (this.graphName.equals(newValue)) {
            return this;
        }
        return new ImmutableDeleteRelationshipsConfig(this, newValue, this.relationshipType);
    }

    public final ImmutableDeleteRelationshipsConfig withRelationshipType(String value) {
        String newValue = Objects.requireNonNull(value, "relationshipType");
        if (this.relationshipType.equals(newValue)) {
            return this;
        }
        return new ImmutableDeleteRelationshipsConfig(this, this.graphName, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDeleteRelationshipsConfig && this.equalTo((ImmutableDeleteRelationshipsConfig)another);
    }

    private boolean equalTo(ImmutableDeleteRelationshipsConfig another) {
        return this.graphName.equals(another.graphName) && this.relationshipType.equals(another.relationshipType);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.graphName.hashCode();
        h += (h << 5) + this.relationshipType.hashCode();
        return h;
    }

    public String toString() {
        return "DeleteRelationshipsConfig{graphName=" + this.graphName + ", relationshipType=" + this.relationshipType + "}";
    }

    public static DeleteRelationshipsConfig of(String graphName, String relationshipType) {
        return new ImmutableDeleteRelationshipsConfig(graphName, relationshipType);
    }

    public static DeleteRelationshipsConfig copyOf(DeleteRelationshipsConfig instance) {
        if (instance instanceof ImmutableDeleteRelationshipsConfig) {
            return (ImmutableDeleteRelationshipsConfig)instance;
        }
        return ImmutableDeleteRelationshipsConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DeleteRelationshipsConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_GRAPH_NAME = 1L;
        private static final long INIT_BIT_RELATIONSHIP_TYPE = 2L;
        private long initBits = 3L;
        @Nullable
        private String graphName;
        @Nullable
        private String relationshipType;

        private Builder() {
        }

        public final Builder from(DeleteRelationshipsConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.graphName(instance.graphName());
            this.relationshipType(instance.relationshipType());
            return this;
        }

        public final Builder graphName(String graphName) {
            this.graphName = Objects.requireNonNull(graphName, "graphName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder relationshipType(String relationshipType) {
            this.relationshipType = Objects.requireNonNull(relationshipType, "relationshipType");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder clear() {
            this.initBits = 3L;
            this.graphName = null;
            this.relationshipType = null;
            return this;
        }

        public DeleteRelationshipsConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDeleteRelationshipsConfig(null, this.graphName, this.relationshipType);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("graphName");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("relationshipType");
            }
            return "Cannot build DeleteRelationshipsConfig, some of required attributes are not set " + attributes;
        }
    }
}

