/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.GraphStreamRelationshipsConfig;
import org.neo4j.gds.core.CypherMapWrapper;

public final class GraphStreamRelationshipsConfigImpl
implements GraphStreamRelationshipsConfig {
    private Optional<String> graphName;
    private List<String> relationshipTypes;
    private int concurrency;
    private Optional<String> usernameOverride;
    private boolean sudo;

    public GraphStreamRelationshipsConfigImpl(@NotNull Optional<String> graphName, @NotNull List<String> relationshipTypes, @NotNull CypherMapWrapper config) {
        ArrayList<IllegalArgumentException> errors = new ArrayList<IllegalArgumentException>();
        try {
            this.graphName = (Optional)CypherMapWrapper.failOnNull((String)"graphName", graphName);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.relationshipTypes = (List)CypherMapWrapper.failOnNull((String)"relationshipTypes", relationshipTypes);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.concurrency = config.getInt("concurrency", GraphStreamRelationshipsConfig.super.concurrency());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.usernameOverride = (Optional)CypherMapWrapper.failOnNull((String)"username", (Object)BaseConfig.trim((Optional)config.getOptional("username", String.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.sudo = config.getBool("sudo", GraphStreamRelationshipsConfig.super.sudo());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        if (!errors.isEmpty()) {
            if (errors.size() == 1) {
                throw (IllegalArgumentException)errors.get(0);
            }
            String combinedErrorMsg = errors.stream().map(Throwable::getMessage).collect(Collectors.joining(System.lineSeparator() + "\t\t\t\t", "Multiple errors in configuration arguments:" + System.lineSeparator() + "\t\t\t\t", ""));
            IllegalArgumentException combinedError = new IllegalArgumentException(combinedErrorMsg);
            errors.forEach(error -> combinedError.addSuppressed((Throwable)error));
            throw combinedError;
        }
    }

    @Override
    public Optional<String> graphName() {
        return this.graphName;
    }

    @Override
    public List<String> relationshipTypes() {
        return this.relationshipTypes;
    }

    @Override
    public int concurrency() {
        return this.concurrency;
    }

    public Optional<String> usernameOverride() {
        return this.usernameOverride;
    }

    public boolean sudo() {
        return this.sudo;
    }

    public Collection<String> configKeys() {
        return Arrays.asList("concurrency", "username", "sudo");
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("concurrency", this.concurrency());
        this.usernameOverride().ifPresent(username -> map.put("username", username));
        map.put("sudo", this.sudo());
        return map;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, Object> config = new HashMap<String, Object>();
        @NotNull
        private Optional<String> graphName;
        @NotNull
        private List<String> relationshipTypes;

        public Builder graphName(Optional<String> graphName) {
            this.graphName = graphName;
            return this;
        }

        public Builder relationshipTypes(List<String> relationshipTypes) {
            this.relationshipTypes = relationshipTypes;
            return this;
        }

        public Builder concurrency(int concurrency) {
            this.config.put("concurrency", concurrency);
            return this;
        }

        public Builder usernameOverride(String usernameOverride) {
            this.config.put("username", usernameOverride);
            return this;
        }

        public Builder usernameOverride(Optional<String> usernameOverride) {
            usernameOverride.ifPresent(actualusernameOverride -> this.config.put("username", actualusernameOverride));
            return this;
        }

        public Builder sudo(boolean sudo) {
            this.config.put("sudo", sudo);
            return this;
        }

        public GraphStreamRelationshipsConfig build() {
            CypherMapWrapper config = CypherMapWrapper.create(this.config);
            return new GraphStreamRelationshipsConfigImpl(this.graphName, this.relationshipTypes, config);
        }
    }
}

