/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.immutables.value.Value;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.annotation.Configuration;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.GraphStreamRelationshipsConfigImpl;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.utils.StringFormatting;

@ValueClass
@Configuration
public interface GraphStreamRelationshipsConfig
extends BaseConfig {
    @Configuration.Parameter
    public Optional<String> graphName();

    @Configuration.Parameter
    @Value.Default
    default public List<String> relationshipTypes() {
        return Collections.singletonList("*");
    }

    @Value.Default
    default public int concurrency() {
        return 4;
    }

    @Configuration.Ignore
    default public Collection<RelationshipType> relationshipTypeIdentifiers(GraphStore graphStore) {
        return this.relationshipTypes().contains("*") ? graphStore.relationshipTypes() : (Collection)this.relationshipTypes().stream().map(RelationshipType::of).collect(Collectors.toList());
    }

    @Configuration.Ignore
    default public void validate(GraphStore graphStore) {
        ArrayList missingRelationshipTypes = new ArrayList();
        this.relationshipTypeIdentifiers(graphStore).forEach(relationshipType -> {
            if (!graphStore.hasRelationshipType((RelationshipType)relationshipType)) {
                missingRelationshipTypes.add(relationshipType);
            }
        });
        if (!missingRelationshipTypes.isEmpty()) {
            throw new IllegalStateException(StringFormatting.formatWithLocale((String)"Expecting all specified relationship types to be present in graph store, but could not find %s", (Object[])new Object[]{missingRelationshipTypes}));
        }
    }

    public static GraphStreamRelationshipsConfig of(String graphName, List<String> relationshipTypes, CypherMapWrapper config) {
        return new GraphStreamRelationshipsConfigImpl(Optional.of(graphName), relationshipTypes, config);
    }
}

