/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.config;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.annotation.Configuration;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.config.GraphStreamRelationshipPropertiesConfigImpl;
import org.neo4j.gds.config.GraphStreamRelationshipsConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.gds.utils.StringJoining;

@ValueClass
@Configuration
public interface GraphStreamRelationshipPropertiesConfig
extends GraphStreamRelationshipsConfig {
    @Configuration.Parameter
    public List<String> relationshipProperties();

    @Override
    @Configuration.Ignore
    default public void validate(GraphStore graphStore) {
        if (!this.relationshipTypes().contains("*")) {
            this.relationshipTypeIdentifiers(graphStore).forEach(relationshipType -> {
                List invalidProperties = this.relationshipProperties().stream().filter(relProperty -> !graphStore.hasRelationshipProperty((RelationshipType)relationshipType, (String)relProperty)).collect(Collectors.toList());
                if (!invalidProperties.isEmpty()) {
                    throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Expecting all specified relationship projections to have all given properties defined. Could not find property key(s) %s for label %s. Defined keys: %s.", (Object[])new Object[]{StringJoining.join(invalidProperties), relationshipType.name, StringJoining.join(graphStore.relationshipPropertyKeys((RelationshipType)relationshipType))}));
                }
            });
        } else {
            boolean hasValidType = this.relationshipTypeIdentifiers(graphStore).stream().anyMatch(relationshipType -> graphStore.relationshipPropertyKeys((RelationshipType)relationshipType).containsAll(this.relationshipProperties()));
            if (!hasValidType) {
                throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Expecting at least one relationship projection to contain property key(s) %s.", (Object[])new Object[]{StringJoining.join(this.relationshipProperties())}));
            }
        }
    }

    @Configuration.Ignore
    default public Collection<RelationshipType> validRelationshipTypes(GraphStore graphStore) {
        return this.relationshipTypeIdentifiers(graphStore);
    }

    public static GraphStreamRelationshipPropertiesConfig of(String graphName, List<String> relationshipProperties, List<String> relationshipTypes, CypherMapWrapper config) {
        return new GraphStreamRelationshipPropertiesConfigImpl(relationshipProperties, Optional.of(graphName), relationshipTypes, config);
    }
}

