/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.GraphStreamGraphPropertiesConfig;
import org.neo4j.gds.core.CypherMapWrapper;

public final class GraphStreamGraphPropertiesConfigImpl
implements GraphStreamGraphPropertiesConfig {
    private Optional<String> graphName;
    private String graphProperty;
    private Optional<String> usernameOverride;
    private boolean sudo;

    public GraphStreamGraphPropertiesConfigImpl(@NotNull Optional<String> graphName, @NotNull String graphProperty, @NotNull CypherMapWrapper config) {
        ArrayList<IllegalArgumentException> errors = new ArrayList<IllegalArgumentException>();
        try {
            this.graphName = (Optional)CypherMapWrapper.failOnNull((String)"graphName", graphName);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.graphProperty = (String)CypherMapWrapper.failOnNull((String)"graphProperty", (Object)graphProperty);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.usernameOverride = (Optional)CypherMapWrapper.failOnNull((String)"username", (Object)BaseConfig.trim((Optional)config.getOptional("username", String.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.sudo = config.getBool("sudo", GraphStreamGraphPropertiesConfig.super.sudo());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        if (!errors.isEmpty()) {
            if (errors.size() == 1) {
                throw (IllegalArgumentException)errors.get(0);
            }
            String combinedErrorMsg = errors.stream().map(Throwable::getMessage).collect(Collectors.joining(System.lineSeparator() + "\t\t\t\t", "Multiple errors in configuration arguments:" + System.lineSeparator() + "\t\t\t\t", ""));
            IllegalArgumentException combinedError = new IllegalArgumentException(combinedErrorMsg);
            errors.forEach(error -> combinedError.addSuppressed((Throwable)error));
            throw combinedError;
        }
    }

    @Override
    public Optional<String> graphName() {
        return this.graphName;
    }

    @Override
    public String graphProperty() {
        return this.graphProperty;
    }

    public Optional<String> usernameOverride() {
        return this.usernameOverride;
    }

    public boolean sudo() {
        return this.sudo;
    }

    public Collection<String> configKeys() {
        return Arrays.asList("username", "sudo");
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        this.usernameOverride().ifPresent(username -> map.put("username", username));
        map.put("sudo", this.sudo());
        return map;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, Object> config = new HashMap<String, Object>();
        @NotNull
        private Optional<String> graphName;
        @NotNull
        private String graphProperty;

        public Builder graphName(Optional<String> graphName) {
            this.graphName = graphName;
            return this;
        }

        public Builder graphProperty(String graphProperty) {
            this.graphProperty = graphProperty;
            return this;
        }

        public Builder usernameOverride(String usernameOverride) {
            this.config.put("username", usernameOverride);
            return this;
        }

        public Builder usernameOverride(Optional<String> usernameOverride) {
            usernameOverride.ifPresent(actualusernameOverride -> this.config.put("username", actualusernameOverride));
            return this;
        }

        public Builder sudo(boolean sudo) {
            this.config.put("sudo", sudo);
            return this;
        }

        public GraphStreamGraphPropertiesConfig build() {
            CypherMapWrapper config = CypherMapWrapper.create(this.config);
            return new GraphStreamGraphPropertiesConfigImpl(this.graphName, this.graphProperty, config);
        }
    }
}

