/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.config;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.GraphProjectConfig;
import org.neo4j.gds.config.GraphSampleAlgoConfig;
import org.neo4j.gds.config.GraphSampleProcConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.utils.progress.JobId;

public final class GraphSampleProcConfigImpl
implements GraphSampleProcConfig {
    private GraphProjectConfig originalConfig;
    private String fromGraphName;
    private GraphSampleAlgoConfig sampleAlgoConfig;
    private String username;
    private String graphName;
    private int readConcurrency;
    private long nodeCount;
    private long relationshipCount;
    private ZonedDateTime creationTime;
    private boolean validateRelationships;
    private Optional<String> usernameOverride;
    private boolean sudo;
    private JobId jobId;

    public GraphSampleProcConfigImpl(@NotNull GraphProjectConfig originalConfig, @NotNull String fromGraphName, @NotNull GraphSampleAlgoConfig sampleAlgoConfig, @NotNull String username, @NotNull String graphName, @NotNull CypherMapWrapper config) {
        ArrayList<IllegalArgumentException> errors = new ArrayList<IllegalArgumentException>();
        try {
            this.originalConfig = (GraphProjectConfig)CypherMapWrapper.failOnNull((String)"originalConfig", (Object)originalConfig);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.fromGraphName = (String)CypherMapWrapper.failOnNull((String)"fromGraphName", (Object)fromGraphName);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.sampleAlgoConfig = (GraphSampleAlgoConfig)CypherMapWrapper.failOnNull((String)"sampleAlgoConfig", (Object)sampleAlgoConfig);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.username = (String)CypherMapWrapper.failOnNull((String)"username", (Object)username);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.graphName = GraphProjectConfig.validateName((String)CypherMapWrapper.failOnNull((String)"graphName", (Object)graphName));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.readConcurrency = config.getInt("readConcurrency", GraphSampleProcConfig.super.readConcurrency());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.nodeCount = config.getLong("nodeCount", GraphSampleProcConfig.super.nodeCount());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.relationshipCount = config.getLong("relationshipCount", GraphSampleProcConfig.super.relationshipCount());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.creationTime = (ZonedDateTime)CypherMapWrapper.failOnNull((String)"creationTime", (Object)((ZonedDateTime)config.getChecked("creationTime", (Object)GraphSampleProcConfig.super.creationTime(), ZonedDateTime.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.validateRelationships = config.getBool("validateRelationships", GraphSampleProcConfig.super.validateRelationships());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.usernameOverride = (Optional)CypherMapWrapper.failOnNull((String)"username", (Object)BaseConfig.trim((Optional)config.getOptional("username", String.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.sudo = config.getBool("sudo", GraphSampleProcConfig.super.sudo());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.jobId = (JobId)CypherMapWrapper.failOnNull((String)"jobId", (Object)JobId.parse(config.getChecked("jobId", (Object)GraphSampleProcConfig.super.jobId(), Object.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.validateReadConcurrency();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (!errors.isEmpty()) {
            if (errors.size() == 1) {
                throw (IllegalArgumentException)errors.get(0);
            }
            String combinedErrorMsg = errors.stream().map(Throwable::getMessage).collect(Collectors.joining(System.lineSeparator() + "\t\t\t\t", "Multiple errors in configuration arguments:" + System.lineSeparator() + "\t\t\t\t", ""));
            IllegalArgumentException combinedError = new IllegalArgumentException(combinedErrorMsg);
            errors.forEach(error -> combinedError.addSuppressed((Throwable)error));
            throw combinedError;
        }
    }

    @Override
    public GraphProjectConfig originalConfig() {
        return this.originalConfig;
    }

    @Override
    public String fromGraphName() {
        return this.fromGraphName;
    }

    @Override
    public GraphSampleAlgoConfig sampleAlgoConfig() {
        return this.sampleAlgoConfig;
    }

    @Override
    public String username() {
        return this.username;
    }

    @Override
    public String graphName() {
        return this.graphName;
    }

    @Override
    public int readConcurrency() {
        return this.readConcurrency;
    }

    @Override
    public long nodeCount() {
        return this.nodeCount;
    }

    @Override
    public long relationshipCount() {
        return this.relationshipCount;
    }

    @Override
    public ZonedDateTime creationTime() {
        return this.creationTime;
    }

    @Override
    public boolean validateRelationships() {
        return this.validateRelationships;
    }

    public Optional<String> usernameOverride() {
        return this.usernameOverride;
    }

    public boolean sudo() {
        return this.sudo;
    }

    public Collection<String> configKeys() {
        return Arrays.asList("readConcurrency", "nodeCount", "relationshipCount", "creationTime", "validateRelationships", "username", "sudo", "jobId");
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("readConcurrency", this.readConcurrency());
        map.put("nodeCount", this.nodeCount());
        map.put("relationshipCount", this.relationshipCount());
        map.put("creationTime", this.creationTime());
        map.put("validateRelationships", this.validateRelationships());
        this.usernameOverride().ifPresent(username -> map.put("username", username));
        map.put("sudo", this.sudo());
        map.put("jobId", JobId.asString(this.jobId()));
        return map;
    }

    @Override
    public JobId jobId() {
        return this.jobId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, Object> config = new HashMap<String, Object>();
        @NotNull
        private GraphProjectConfig originalConfig;
        @NotNull
        private String fromGraphName;
        @NotNull
        private GraphSampleAlgoConfig sampleAlgoConfig;
        @NotNull
        private String username;
        @NotNull
        private String graphName;

        public Builder originalConfig(GraphProjectConfig originalConfig) {
            this.originalConfig = originalConfig;
            return this;
        }

        public Builder fromGraphName(String fromGraphName) {
            this.fromGraphName = fromGraphName;
            return this;
        }

        public Builder sampleAlgoConfig(GraphSampleAlgoConfig sampleAlgoConfig) {
            this.sampleAlgoConfig = sampleAlgoConfig;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder graphName(String graphName) {
            this.graphName = graphName;
            return this;
        }

        public Builder readConcurrency(int readConcurrency) {
            this.config.put("readConcurrency", readConcurrency);
            return this;
        }

        public Builder nodeCount(long nodeCount) {
            this.config.put("nodeCount", nodeCount);
            return this;
        }

        public Builder relationshipCount(long relationshipCount) {
            this.config.put("relationshipCount", relationshipCount);
            return this;
        }

        public Builder creationTime(ZonedDateTime creationTime) {
            this.config.put("creationTime", creationTime);
            return this;
        }

        public Builder validateRelationships(boolean validateRelationships) {
            this.config.put("validateRelationships", validateRelationships);
            return this;
        }

        public Builder usernameOverride(String usernameOverride) {
            this.config.put("username", usernameOverride);
            return this;
        }

        public Builder usernameOverride(Optional<String> usernameOverride) {
            usernameOverride.ifPresent(actualusernameOverride -> this.config.put("username", actualusernameOverride));
            return this;
        }

        public Builder sudo(boolean sudo) {
            this.config.put("sudo", sudo);
            return this;
        }

        public Builder jobId(Object jobId) {
            this.config.put("jobId", jobId);
            return this;
        }

        public GraphSampleProcConfig build() {
            CypherMapWrapper config = CypherMapWrapper.create(this.config);
            return new GraphSampleProcConfigImpl(this.originalConfig, this.fromGraphName, this.sampleAlgoConfig, this.username, this.graphName, config);
        }
    }
}

