/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.config;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.neo4j.gds.annotation.Configuration;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.ConcurrencyConfig;
import org.neo4j.gds.config.GraphRemoveNodePropertiesConfigImpl;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.gds.utils.StringJoining;

@ValueClass
@Configuration
public interface GraphRemoveNodePropertiesConfig
extends BaseConfig,
ConcurrencyConfig {
    @Configuration.Parameter
    public Optional<String> graphName();

    @Configuration.Parameter
    public List<String> nodeProperties();

    public static GraphRemoveNodePropertiesConfig of(String graphName, List<String> nodeProperties, CypherMapWrapper config) {
        return new GraphRemoveNodePropertiesConfigImpl(Optional.of(graphName), nodeProperties, config);
    }

    @Configuration.Ignore
    default public void validate(GraphStore graphStore) {
        List invalidProperties = this.nodeProperties().stream().filter(nodeProperty -> !graphStore.hasNodeProperty((String)nodeProperty)).collect(Collectors.toList());
        if (!invalidProperties.isEmpty()) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Could not find property key(s) %s. Defined keys: %s.", (Object[])new Object[]{StringJoining.join(invalidProperties), StringJoining.join(graphStore.nodePropertyKeys())}));
        }
    }
}

