/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.config;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.neo4j.gds.AbstractNodeProjections;
import org.neo4j.gds.AbstractPropertyMappings;
import org.neo4j.gds.AbstractRelationshipProjections;
import org.neo4j.gds.NodeProjections;
import org.neo4j.gds.PropertyMappings;
import org.neo4j.gds.RelationshipProjections;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.GraphProjectConfig;
import org.neo4j.gds.config.GraphProjectFromStoreConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.utils.progress.JobId;

public final class GraphProjectFromStoreConfigImpl
implements GraphProjectFromStoreConfig {
    private NodeProjections nodeProjections;
    private RelationshipProjections relationshipProjections;
    private PropertyMappings nodeProperties;
    private PropertyMappings relationshipProperties;
    private String username;
    private String graphName;
    private int readConcurrency;
    private long nodeCount;
    private long relationshipCount;
    private ZonedDateTime creationTime;
    private boolean validateRelationships;
    private Optional<String> usernameOverride;
    private boolean sudo;
    private JobId jobId;

    private GraphProjectFromStoreConfigImpl(@NotNull String username, @NotNull String graphName, @NotNull CypherMapWrapper config) {
        ArrayList<IllegalArgumentException> errors = new ArrayList<IllegalArgumentException>();
        try {
            this.nodeProjections = (NodeProjections)CypherMapWrapper.failOnNull((String)"nodeProjection", (Object)AbstractNodeProjections.fromObject((Object)config.requireChecked("nodeProjection", Object.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.relationshipProjections = (RelationshipProjections)CypherMapWrapper.failOnNull((String)"relationshipProjection", (Object)AbstractRelationshipProjections.fromObject((Object)config.requireChecked("relationshipProjection", Object.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.nodeProperties = (PropertyMappings)CypherMapWrapper.failOnNull((String)"nodeProperties", (Object)AbstractPropertyMappings.fromObject((Object)config.getChecked("nodeProperties", (Object)GraphProjectFromStoreConfig.super.nodeProperties(), Object.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.relationshipProperties = (PropertyMappings)CypherMapWrapper.failOnNull((String)"relationshipProperties", (Object)AbstractPropertyMappings.fromObject((Object)config.getChecked("relationshipProperties", (Object)GraphProjectFromStoreConfig.super.relationshipProperties(), Object.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.username = (String)CypherMapWrapper.failOnNull((String)"username", (Object)username);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.graphName = GraphProjectConfig.validateName((String)CypherMapWrapper.failOnNull((String)"graphName", (Object)graphName));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.readConcurrency = config.getInt("readConcurrency", GraphProjectFromStoreConfig.super.readConcurrency());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.nodeCount = config.getLong("nodeCount", GraphProjectFromStoreConfig.super.nodeCount());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.relationshipCount = config.getLong("relationshipCount", GraphProjectFromStoreConfig.super.relationshipCount());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.creationTime = (ZonedDateTime)CypherMapWrapper.failOnNull((String)"creationTime", (Object)((ZonedDateTime)config.getChecked("creationTime", (Object)GraphProjectFromStoreConfig.super.creationTime(), ZonedDateTime.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.validateRelationships = config.getBool("validateRelationships", GraphProjectFromStoreConfig.super.validateRelationships());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.usernameOverride = (Optional)CypherMapWrapper.failOnNull((String)"username", (Object)BaseConfig.trim((Optional)config.getOptional("username", String.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.sudo = config.getBool("sudo", GraphProjectFromStoreConfig.super.sudo());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.jobId = (JobId)CypherMapWrapper.failOnNull((String)"jobId", (Object)JobId.parse(config.getChecked("jobId", (Object)GraphProjectFromStoreConfig.super.jobId(), Object.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.validateProjectionsAreNotEmpty();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            this.validateReadConcurrency();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (!errors.isEmpty()) {
            if (errors.size() == 1) {
                throw (IllegalArgumentException)errors.get(0);
            }
            String combinedErrorMsg = errors.stream().map(Throwable::getMessage).collect(Collectors.joining(System.lineSeparator() + "\t\t\t\t", "Multiple errors in configuration arguments:" + System.lineSeparator() + "\t\t\t\t", ""));
            IllegalArgumentException combinedError = new IllegalArgumentException(combinedErrorMsg);
            errors.forEach(error -> combinedError.addSuppressed((Throwable)error));
            throw combinedError;
        }
    }

    public static GraphProjectFromStoreConfig of(@NotNull String username, @NotNull String graphName, @NotNull CypherMapWrapper config) {
        GraphProjectFromStoreConfig instance = new GraphProjectFromStoreConfigImpl(username, graphName, config);
        instance = instance.withNormalizedPropertyMappings();
        return instance;
    }

    @Override
    public NodeProjections nodeProjections() {
        return this.nodeProjections;
    }

    @Override
    public RelationshipProjections relationshipProjections() {
        return this.relationshipProjections;
    }

    @Override
    public PropertyMappings nodeProperties() {
        return this.nodeProperties;
    }

    @Override
    public PropertyMappings relationshipProperties() {
        return this.relationshipProperties;
    }

    @Override
    public String username() {
        return this.username;
    }

    @Override
    public String graphName() {
        return this.graphName;
    }

    @Override
    public int readConcurrency() {
        return this.readConcurrency;
    }

    @Override
    public long nodeCount() {
        return this.nodeCount;
    }

    @Override
    public long relationshipCount() {
        return this.relationshipCount;
    }

    @Override
    public ZonedDateTime creationTime() {
        return this.creationTime;
    }

    @Override
    public boolean validateRelationships() {
        return this.validateRelationships;
    }

    public Optional<String> usernameOverride() {
        return this.usernameOverride;
    }

    public boolean sudo() {
        return this.sudo;
    }

    public Collection<String> configKeys() {
        return Arrays.asList("nodeProjection", "relationshipProjection", "nodeProperties", "relationshipProperties", "readConcurrency", "nodeCount", "relationshipCount", "creationTime", "validateRelationships", "username", "sudo", "jobId");
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("nodeProjection", AbstractNodeProjections.toObject((AbstractNodeProjections)this.nodeProjections()));
        map.put("relationshipProjection", AbstractRelationshipProjections.toObject((AbstractRelationshipProjections)this.relationshipProjections()));
        map.put("nodeProperties", this.nodeProperties());
        map.put("relationshipProperties", this.relationshipProperties());
        map.put("readConcurrency", this.readConcurrency());
        map.put("nodeCount", this.nodeCount());
        map.put("relationshipCount", this.relationshipCount());
        map.put("creationTime", this.creationTime());
        map.put("validateRelationships", this.validateRelationships());
        this.usernameOverride().ifPresent(username -> map.put("username", username));
        map.put("sudo", this.sudo());
        map.put("jobId", JobId.asString(this.jobId()));
        return map;
    }

    @Override
    public JobId jobId() {
        return this.jobId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, Object> config = new HashMap<String, Object>();
        @NotNull
        private String username;
        @NotNull
        private String graphName;

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder graphName(String graphName) {
            this.graphName = graphName;
            return this;
        }

        public Builder nodeProjections(Object nodeProjections) {
            this.config.put("nodeProjection", nodeProjections);
            return this;
        }

        public Builder relationshipProjections(Object relationshipProjections) {
            this.config.put("relationshipProjection", relationshipProjections);
            return this;
        }

        public Builder nodeProperties(Object nodeProperties) {
            this.config.put("nodeProperties", nodeProperties);
            return this;
        }

        public Builder relationshipProperties(Object relationshipProperties) {
            this.config.put("relationshipProperties", relationshipProperties);
            return this;
        }

        public Builder readConcurrency(int readConcurrency) {
            this.config.put("readConcurrency", readConcurrency);
            return this;
        }

        public Builder nodeCount(long nodeCount) {
            this.config.put("nodeCount", nodeCount);
            return this;
        }

        public Builder relationshipCount(long relationshipCount) {
            this.config.put("relationshipCount", relationshipCount);
            return this;
        }

        public Builder creationTime(ZonedDateTime creationTime) {
            this.config.put("creationTime", creationTime);
            return this;
        }

        public Builder validateRelationships(boolean validateRelationships) {
            this.config.put("validateRelationships", validateRelationships);
            return this;
        }

        public Builder usernameOverride(String usernameOverride) {
            this.config.put("username", usernameOverride);
            return this;
        }

        public Builder usernameOverride(Optional<String> usernameOverride) {
            usernameOverride.ifPresent(actualusernameOverride -> this.config.put("username", actualusernameOverride));
            return this;
        }

        public Builder sudo(boolean sudo) {
            this.config.put("sudo", sudo);
            return this;
        }

        public Builder jobId(Object jobId) {
            this.config.put("jobId", jobId);
            return this;
        }

        public GraphProjectFromStoreConfig build() {
            CypherMapWrapper config = CypherMapWrapper.create(this.config);
            return GraphProjectFromStoreConfigImpl.of(this.username, this.graphName, config);
        }
    }
}

