/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.config;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.immutables.value.Value;
import org.neo4j.gds.NodeProjections;
import org.neo4j.gds.PropertyMapping;
import org.neo4j.gds.PropertyMappings;
import org.neo4j.gds.RelationshipProjections;
import org.neo4j.gds.annotation.Configuration;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.api.GraphLoaderContext;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.api.GraphStoreFactory;
import org.neo4j.gds.config.GraphProjectConfig;
import org.neo4j.gds.config.GraphProjectFromStoreConfigImpl;
import org.neo4j.gds.config.ImmutableGraphProjectFromStoreConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.GraphDimensions;
import org.neo4j.gds.core.loading.NativeFactory;
import org.neo4j.gds.utils.StringFormatting;

@ValueClass
@Configuration
public interface GraphProjectFromStoreConfig
extends GraphProjectConfig {
    public static final String NODE_PROJECTION_KEY = "nodeProjection";
    public static final String RELATIONSHIP_PROJECTION_KEY = "relationshipProjection";
    public static final String NODE_PROPERTIES_KEY = "nodeProperties";
    public static final String RELATIONSHIP_PROPERTIES_KEY = "relationshipProperties";

    @Configuration.Key(value="nodeProjection")
    @Configuration.ConvertWith(value="org.neo4j.gds.AbstractNodeProjections#fromObject")
    @Configuration.ToMapValue(value="org.neo4j.gds.AbstractNodeProjections#toObject")
    public NodeProjections nodeProjections();

    @Configuration.Key(value="relationshipProjection")
    @Configuration.ConvertWith(value="org.neo4j.gds.AbstractRelationshipProjections#fromObject")
    @Configuration.ToMapValue(value="org.neo4j.gds.AbstractRelationshipProjections#toObject")
    public RelationshipProjections relationshipProjections();

    @Value.Default
    @Value.Parameter(value=false)
    @Configuration.ConvertWith(value="org.neo4j.gds.AbstractPropertyMappings#fromObject")
    default public PropertyMappings nodeProperties() {
        return PropertyMappings.of();
    }

    @Value.Default
    @Value.Parameter(value=false)
    @Configuration.ConvertWith(value="org.neo4j.gds.AbstractPropertyMappings#fromObject")
    default public PropertyMappings relationshipProperties() {
        return PropertyMappings.of();
    }

    @Override
    @Configuration.Ignore
    default public GraphStoreFactory.Supplier graphStoreFactory() {
        return new GraphStoreFactory.Supplier(){

            @Override
            public GraphStoreFactory<? extends GraphStore, ? extends GraphProjectConfig> get(GraphLoaderContext loaderContext) {
                return new NativeFactory(GraphProjectFromStoreConfig.this, loaderContext);
            }

            @Override
            public GraphStoreFactory<? extends GraphStore, ? extends GraphProjectConfig> getWithDimension(GraphLoaderContext loaderContext, GraphDimensions graphDimensions) {
                return new NativeFactory(GraphProjectFromStoreConfig.this, loaderContext, graphDimensions);
            }
        };
    }

    @Value.Check
    default public void validateProjectionsAreNotEmpty() {
        if (this.nodeProjections().isEmpty()) {
            throw new IllegalArgumentException("The parameter 'nodeProjections' should not be empty. Use '*' to load all nodes.");
        }
        if (this.relationshipProjections().isEmpty()) {
            throw new IllegalArgumentException("The parameter 'relationshipProjections' should not be empty. Use '*' to load all Relationships.");
        }
    }

    @Value.Check
    default public GraphProjectFromStoreConfig withNormalizedPropertyMappings() {
        PropertyMappings nodeProperties = this.nodeProperties();
        PropertyMappings relationshipProperties = this.relationshipProperties();
        if (!nodeProperties.hasMappings() && !relationshipProperties.hasMappings()) {
            return this;
        }
        this.relationshipProjections().projections().values().forEach(relationshipProjection -> {
            if (relationshipProjection.properties().mappings().size() > 1) {
                throw new IllegalArgumentException("Implicit graph loading does not allow loading multiple relationship properties per relationship type");
            }
        });
        this.verifyProperties(nodeProperties.stream().map(PropertyMapping::propertyKey).collect(Collectors.toSet()), this.nodeProjections().allProperties(), "node");
        this.verifyProperties(relationshipProperties.stream().map(PropertyMapping::propertyKey).collect(Collectors.toSet()), this.relationshipProjections().allProperties(), "relationship");
        return ImmutableGraphProjectFromStoreConfig.builder().from(this).nodeProjections(this.nodeProjections().addPropertyMappings(nodeProperties)).nodeProperties(PropertyMappings.of()).relationshipProjections(this.relationshipProjections().addPropertyMappings(relationshipProperties)).relationshipProperties(PropertyMappings.of()).build();
    }

    @Configuration.Ignore
    default public void verifyProperties(Set<String> propertiesFromMapping, Set<String> propertiesFromProjection, String type) {
        HashSet<String> propertyIntersection = new HashSet<String>(propertiesFromMapping);
        propertyIntersection.retainAll(propertiesFromProjection);
        if (!propertyIntersection.isEmpty()) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Incompatible %s projection and %s property specification. Both specify properties named %s", (Object[])new Object[]{type, type, propertyIntersection}));
        }
    }

    @Override
    @Configuration.Ignore
    default public <R> R accept(GraphProjectConfig.Cases<R> visitor) {
        return visitor.store(this);
    }

    @Value.Derived
    @Configuration.Ignore
    default public Set<String> outputFieldDenylist() {
        return Set.of("nodeCount", "relationshipCount");
    }

    public static GraphProjectFromStoreConfig emptyWithName(String userName, String graphName) {
        NodeProjections nodeProjections = NodeProjections.all();
        RelationshipProjections relationshipProjections = RelationshipProjections.all();
        return ImmutableGraphProjectFromStoreConfig.of(userName, graphName, nodeProjections, relationshipProjections);
    }

    public static GraphProjectFromStoreConfig of(String userName, String graphName, Object nodeProjections, Object relationshipProjections, CypherMapWrapper config) {
        if (nodeProjections != null) {
            config = config.withEntry(NODE_PROJECTION_KEY, nodeProjections);
        }
        if (relationshipProjections != null) {
            config = config.withEntry(RELATIONSHIP_PROJECTION_KEY, relationshipProjections);
        }
        return GraphProjectFromStoreConfigImpl.of(userName, graphName, config);
    }

    public static GraphProjectFromStoreConfig all(String userName, String graphName) {
        return ImmutableGraphProjectFromStoreConfig.builder().username(userName).graphName(graphName).nodeProjections(NodeProjections.all()).relationshipProjections(RelationshipProjections.all()).build();
    }

    public static GraphProjectFromStoreConfig fromProcedureConfig(String username, CypherMapWrapper config) {
        if (!config.containsKey(NODE_PROJECTION_KEY)) {
            config = config.withEntry(NODE_PROJECTION_KEY, (Object)NodeProjections.all());
        }
        if (!config.containsKey(RELATIONSHIP_PROJECTION_KEY)) {
            config = config.withEntry(RELATIONSHIP_PROJECTION_KEY, (Object)RelationshipProjections.all());
        }
        return GraphProjectFromStoreConfigImpl.of(username, "", config);
    }
}

