/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.config;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.GraphProjectConfig;
import org.neo4j.gds.config.GraphProjectFromGraphConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.utils.progress.JobId;

public final class GraphProjectFromGraphConfigImpl
implements GraphProjectFromGraphConfig {
    private String graphName;
    private String fromGraphName;
    private String nodeFilter;
    private String relationshipFilter;
    private GraphProjectConfig originalConfig;
    private int concurrency;
    private Map<String, Object> parameters;
    private String username;
    private int readConcurrency;
    private ZonedDateTime creationTime;
    private Optional<String> usernameOverride;
    private boolean sudo;
    private JobId jobId;

    public GraphProjectFromGraphConfigImpl(@NotNull String graphName, @NotNull String fromGraphName, @NotNull String nodeFilter, @NotNull String relationshipFilter, @NotNull GraphProjectConfig originalConfig, @NotNull String username, @NotNull CypherMapWrapper config) {
        ArrayList<IllegalArgumentException> errors = new ArrayList<IllegalArgumentException>();
        try {
            this.graphName = (String)CypherMapWrapper.failOnNull((String)"graphName", (Object)graphName);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.fromGraphName = (String)CypherMapWrapper.failOnNull((String)"fromGraphName", (Object)fromGraphName);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.nodeFilter = (String)CypherMapWrapper.failOnNull((String)"nodeFilter", (Object)nodeFilter);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.relationshipFilter = (String)CypherMapWrapper.failOnNull((String)"relationshipFilter", (Object)relationshipFilter);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.originalConfig = (GraphProjectConfig)CypherMapWrapper.failOnNull((String)"originalConfig", (Object)originalConfig);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.concurrency = config.getInt("concurrency", GraphProjectFromGraphConfig.super.concurrency());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.parameters = (Map)CypherMapWrapper.failOnNull((String)"parameters", (Object)((Map)config.getChecked("parameters", GraphProjectFromGraphConfig.super.parameters(), Map.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.username = (String)CypherMapWrapper.failOnNull((String)"username", (Object)username);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.readConcurrency = config.getInt("readConcurrency", GraphProjectFromGraphConfig.super.readConcurrency());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.creationTime = (ZonedDateTime)CypherMapWrapper.failOnNull((String)"creationTime", (Object)((ZonedDateTime)config.getChecked("creationTime", (Object)GraphProjectFromGraphConfig.super.creationTime(), ZonedDateTime.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.usernameOverride = (Optional)CypherMapWrapper.failOnNull((String)"username", (Object)BaseConfig.trim((Optional)config.getOptional("username", String.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.sudo = config.getBool("sudo", GraphProjectFromGraphConfig.super.sudo());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.jobId = (JobId)CypherMapWrapper.failOnNull((String)"jobId", (Object)JobId.parse(config.getChecked("jobId", (Object)GraphProjectFromGraphConfig.super.jobId(), Object.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.validateReadConcurrency();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (!errors.isEmpty()) {
            if (errors.size() == 1) {
                throw (IllegalArgumentException)errors.get(0);
            }
            String combinedErrorMsg = errors.stream().map(Throwable::getMessage).collect(Collectors.joining(System.lineSeparator() + "\t\t\t\t", "Multiple errors in configuration arguments:" + System.lineSeparator() + "\t\t\t\t", ""));
            IllegalArgumentException combinedError = new IllegalArgumentException(combinedErrorMsg);
            errors.forEach(error -> combinedError.addSuppressed((Throwable)error));
            throw combinedError;
        }
    }

    @Override
    public String graphName() {
        return this.graphName;
    }

    @Override
    public String fromGraphName() {
        return this.fromGraphName;
    }

    @Override
    public String nodeFilter() {
        return this.nodeFilter;
    }

    @Override
    public String relationshipFilter() {
        return this.relationshipFilter;
    }

    @Override
    public GraphProjectConfig originalConfig() {
        return this.originalConfig;
    }

    @Override
    public int concurrency() {
        return this.concurrency;
    }

    @Override
    public Map<String, Object> parameters() {
        return this.parameters;
    }

    @Override
    public String username() {
        return this.username;
    }

    @Override
    public int readConcurrency() {
        return this.readConcurrency;
    }

    @Override
    public ZonedDateTime creationTime() {
        return this.creationTime;
    }

    public Optional<String> usernameOverride() {
        return this.usernameOverride;
    }

    public boolean sudo() {
        return this.sudo;
    }

    public Collection<String> configKeys() {
        return Arrays.asList("concurrency", "parameters", "readConcurrency", "creationTime", "username", "sudo", "jobId");
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("concurrency", this.concurrency());
        map.put("parameters", this.parameters());
        map.put("readConcurrency", this.readConcurrency());
        map.put("creationTime", this.creationTime());
        this.usernameOverride().ifPresent(username -> map.put("username", username));
        map.put("sudo", this.sudo());
        map.put("jobId", JobId.asString(this.jobId()));
        return map;
    }

    @Override
    public JobId jobId() {
        return this.jobId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, Object> config = new HashMap<String, Object>();
        @NotNull
        private String graphName;
        @NotNull
        private String fromGraphName;
        @NotNull
        private String nodeFilter;
        @NotNull
        private String relationshipFilter;
        @NotNull
        private GraphProjectConfig originalConfig;
        @NotNull
        private String username;

        public Builder graphName(String graphName) {
            this.graphName = graphName;
            return this;
        }

        public Builder fromGraphName(String fromGraphName) {
            this.fromGraphName = fromGraphName;
            return this;
        }

        public Builder nodeFilter(String nodeFilter) {
            this.nodeFilter = nodeFilter;
            return this;
        }

        public Builder relationshipFilter(String relationshipFilter) {
            this.relationshipFilter = relationshipFilter;
            return this;
        }

        public Builder originalConfig(GraphProjectConfig originalConfig) {
            this.originalConfig = originalConfig;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder concurrency(int concurrency) {
            this.config.put("concurrency", concurrency);
            return this;
        }

        public Builder parameters(Map<String, Object> parameters) {
            this.config.put("parameters", parameters);
            return this;
        }

        public Builder readConcurrency(int readConcurrency) {
            this.config.put("readConcurrency", readConcurrency);
            return this;
        }

        public Builder creationTime(ZonedDateTime creationTime) {
            this.config.put("creationTime", creationTime);
            return this;
        }

        public Builder usernameOverride(String usernameOverride) {
            this.config.put("username", usernameOverride);
            return this;
        }

        public Builder usernameOverride(Optional<String> usernameOverride) {
            usernameOverride.ifPresent(actualusernameOverride -> this.config.put("username", actualusernameOverride));
            return this;
        }

        public Builder sudo(boolean sudo) {
            this.config.put("sudo", sudo);
            return this;
        }

        public Builder jobId(Object jobId) {
            this.config.put("jobId", jobId);
            return this;
        }

        public GraphProjectFromGraphConfig build() {
            CypherMapWrapper config = CypherMapWrapper.create(this.config);
            return new GraphProjectFromGraphConfigImpl(this.graphName, this.fromGraphName, this.nodeFilter, this.relationshipFilter, this.originalConfig, this.username, config);
        }
    }
}

