/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.config;

import java.util.Collections;
import java.util.Map;
import org.immutables.value.Value;
import org.neo4j.gds.annotation.Configuration;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.api.GraphStoreFactory;
import org.neo4j.gds.concurrency.ConcurrencyValidatorService;
import org.neo4j.gds.config.GraphProjectConfig;
import org.neo4j.gds.config.GraphProjectFromGraphConfigImpl;
import org.neo4j.gds.core.CypherMapWrapper;

@ValueClass
@Configuration
public interface GraphProjectFromGraphConfig
extends GraphProjectConfig {
    @Override
    @Configuration.Parameter
    public String graphName();

    @Configuration.Parameter
    public String fromGraphName();

    @Configuration.Parameter
    public String nodeFilter();

    @Configuration.Parameter
    public String relationshipFilter();

    @Configuration.Parameter
    public GraphProjectConfig originalConfig();

    @Value.Default
    @Value.Parameter(value=false)
    default public int concurrency() {
        return 4;
    }

    @Value.Default
    @Value.Parameter(value=false)
    default public Map<String, Object> parameters() {
        return Collections.emptyMap();
    }

    @Override
    @Value.Check
    default public void validateReadConcurrency() {
        ConcurrencyValidatorService.validator().validate(this.concurrency(), "concurrency", 4);
    }

    @Override
    @Value.Default
    @Configuration.Ignore
    default public GraphStoreFactory.Supplier graphStoreFactory() {
        return this.originalConfig().graphStoreFactory();
    }

    @Override
    @Configuration.Ignore
    default public <R> R accept(GraphProjectConfig.Cases<R> visitor) {
        return visitor.graph(this);
    }

    @Override
    @Configuration.Ignore
    default public long nodeCount() {
        return -1L;
    }

    @Override
    @Configuration.Ignore
    default public long relationshipCount() {
        return -1L;
    }

    @Override
    @Configuration.Ignore
    default public boolean validateRelationships() {
        return false;
    }

    public static GraphProjectFromGraphConfig of(String userName, String graphName, String fromGraphName, String nodeFilter, String relationshipFilter, GraphProjectConfig originalConfig, CypherMapWrapper procedureConfig) {
        return new GraphProjectFromGraphConfigImpl(graphName, fromGraphName, nodeFilter, relationshipFilter, originalConfig, userName, procedureConfig);
    }
}

