/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.config;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.GraphProjectConfig;
import org.neo4j.gds.config.GraphProjectFromCypherConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.utils.progress.JobId;

public final class GraphProjectFromCypherConfigImpl
implements GraphProjectFromCypherConfig {
    private String nodeQuery;
    private String relationshipQuery;
    private Map<String, Object> parameters;
    private boolean validateRelationships;
    private boolean sudo;
    private String username;
    private String graphName;
    private int readConcurrency;
    private long nodeCount;
    private long relationshipCount;
    private ZonedDateTime creationTime;
    private Optional<String> usernameOverride;
    private JobId jobId;

    public GraphProjectFromCypherConfigImpl(@NotNull String username, @NotNull String graphName, @NotNull CypherMapWrapper config) {
        ArrayList<IllegalArgumentException> errors = new ArrayList<IllegalArgumentException>();
        try {
            this.nodeQuery = (String)CypherMapWrapper.failOnNull((String)"nodeQuery", (Object)StringUtils.trimToNull((String)config.requireString("nodeQuery")));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.relationshipQuery = (String)CypherMapWrapper.failOnNull((String)"relationshipQuery", (Object)StringUtils.trimToNull((String)config.requireString("relationshipQuery")));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.parameters = (Map)CypherMapWrapper.failOnNull((String)"parameters", (Object)((Map)config.getChecked("parameters", GraphProjectFromCypherConfig.super.parameters(), Map.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.validateRelationships = config.getBool("validateRelationships", GraphProjectFromCypherConfig.super.validateRelationships());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.sudo = config.getBool("sudo", GraphProjectFromCypherConfig.super.sudo());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.username = (String)CypherMapWrapper.failOnNull((String)"username", (Object)username);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.graphName = GraphProjectConfig.validateName((String)CypherMapWrapper.failOnNull((String)"graphName", (Object)graphName));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.readConcurrency = config.getInt("readConcurrency", GraphProjectFromCypherConfig.super.readConcurrency());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.nodeCount = config.getLong("nodeCount", GraphProjectFromCypherConfig.super.nodeCount());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.relationshipCount = config.getLong("relationshipCount", GraphProjectFromCypherConfig.super.relationshipCount());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.creationTime = (ZonedDateTime)CypherMapWrapper.failOnNull((String)"creationTime", (Object)((ZonedDateTime)config.getChecked("creationTime", (Object)GraphProjectFromCypherConfig.super.creationTime(), ZonedDateTime.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.usernameOverride = (Optional)CypherMapWrapper.failOnNull((String)"username", (Object)BaseConfig.trim((Optional)config.getOptional("username", String.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.jobId = (JobId)CypherMapWrapper.failOnNull((String)"jobId", (Object)JobId.parse(config.getChecked("jobId", (Object)GraphProjectFromCypherConfig.super.jobId(), Object.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.validateReadConcurrency();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (!errors.isEmpty()) {
            if (errors.size() == 1) {
                throw (IllegalArgumentException)errors.get(0);
            }
            String combinedErrorMsg = errors.stream().map(Throwable::getMessage).collect(Collectors.joining(System.lineSeparator() + "\t\t\t\t", "Multiple errors in configuration arguments:" + System.lineSeparator() + "\t\t\t\t", ""));
            IllegalArgumentException combinedError = new IllegalArgumentException(combinedErrorMsg);
            errors.forEach(error -> combinedError.addSuppressed((Throwable)error));
            throw combinedError;
        }
    }

    @Override
    public String nodeQuery() {
        return this.nodeQuery;
    }

    @Override
    public String relationshipQuery() {
        return this.relationshipQuery;
    }

    @Override
    public Map<String, Object> parameters() {
        return this.parameters;
    }

    @Override
    public boolean validateRelationships() {
        return this.validateRelationships;
    }

    @Override
    public boolean sudo() {
        return this.sudo;
    }

    @Override
    public String username() {
        return this.username;
    }

    @Override
    public String graphName() {
        return this.graphName;
    }

    @Override
    public int readConcurrency() {
        return this.readConcurrency;
    }

    @Override
    public long nodeCount() {
        return this.nodeCount;
    }

    @Override
    public long relationshipCount() {
        return this.relationshipCount;
    }

    @Override
    public ZonedDateTime creationTime() {
        return this.creationTime;
    }

    public Optional<String> usernameOverride() {
        return this.usernameOverride;
    }

    public Collection<String> configKeys() {
        return Arrays.asList("nodeQuery", "relationshipQuery", "parameters", "validateRelationships", "sudo", "readConcurrency", "nodeCount", "relationshipCount", "creationTime", "username", "jobId");
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("nodeQuery", this.nodeQuery());
        map.put("relationshipQuery", this.relationshipQuery());
        map.put("parameters", this.parameters());
        map.put("validateRelationships", this.validateRelationships());
        map.put("sudo", this.sudo());
        map.put("readConcurrency", this.readConcurrency());
        map.put("nodeCount", this.nodeCount());
        map.put("relationshipCount", this.relationshipCount());
        map.put("creationTime", this.creationTime());
        this.usernameOverride().ifPresent(username -> map.put("username", username));
        map.put("jobId", JobId.asString(this.jobId()));
        return map;
    }

    @Override
    public JobId jobId() {
        return this.jobId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, Object> config = new HashMap<String, Object>();
        @NotNull
        private String username;
        @NotNull
        private String graphName;

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder graphName(String graphName) {
            this.graphName = graphName;
            return this;
        }

        public Builder nodeQuery(String nodeQuery) {
            this.config.put("nodeQuery", nodeQuery);
            return this;
        }

        public Builder relationshipQuery(String relationshipQuery) {
            this.config.put("relationshipQuery", relationshipQuery);
            return this;
        }

        public Builder parameters(Map<String, Object> parameters) {
            this.config.put("parameters", parameters);
            return this;
        }

        public Builder validateRelationships(boolean validateRelationships) {
            this.config.put("validateRelationships", validateRelationships);
            return this;
        }

        public Builder sudo(boolean sudo) {
            this.config.put("sudo", sudo);
            return this;
        }

        public Builder readConcurrency(int readConcurrency) {
            this.config.put("readConcurrency", readConcurrency);
            return this;
        }

        public Builder nodeCount(long nodeCount) {
            this.config.put("nodeCount", nodeCount);
            return this;
        }

        public Builder relationshipCount(long relationshipCount) {
            this.config.put("relationshipCount", relationshipCount);
            return this;
        }

        public Builder creationTime(ZonedDateTime creationTime) {
            this.config.put("creationTime", creationTime);
            return this;
        }

        public Builder usernameOverride(String usernameOverride) {
            this.config.put("username", usernameOverride);
            return this;
        }

        public Builder usernameOverride(Optional<String> usernameOverride) {
            usernameOverride.ifPresent(actualusernameOverride -> this.config.put("username", actualusernameOverride));
            return this;
        }

        public Builder jobId(Object jobId) {
            this.config.put("jobId", jobId);
            return this;
        }

        public GraphProjectFromCypherConfig build() {
            CypherMapWrapper config = CypherMapWrapper.create(this.config);
            return new GraphProjectFromCypherConfigImpl(this.username, this.graphName, config);
        }
    }
}

