/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.config;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.immutables.value.Value;
import org.neo4j.gds.annotation.Configuration;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.api.GraphLoaderContext;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.api.GraphStoreFactory;
import org.neo4j.gds.config.GraphProjectConfig;
import org.neo4j.gds.config.GraphProjectFromCypherConfigImpl;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.GraphDimensions;
import org.neo4j.gds.core.loading.CypherFactory;
import org.neo4j.gds.utils.StringFormatting;

@ValueClass
@Configuration
public interface GraphProjectFromCypherConfig
extends GraphProjectConfig {
    public static final List<String> FORBIDDEN_KEYS = Arrays.asList("nodeProjection", "relationshipProjection", "nodeProperties", "relationshipProperties");
    public static final String NODE_QUERY_KEY = "nodeQuery";
    public static final String RELATIONSHIP_QUERY_KEY = "relationshipQuery";
    public static final String ALL_NODES_QUERY = "MATCH (n) RETURN id(n) AS id";
    public static final String ALL_RELATIONSHIPS_QUERY = "MATCH (a)-->(b) RETURN id(a) AS source, id(b) AS target";

    @Configuration.ConvertWith(value="org.apache.commons.lang3.StringUtils#trimToNull")
    public String nodeQuery();

    @Configuration.ConvertWith(value="org.apache.commons.lang3.StringUtils#trimToNull")
    public String relationshipQuery();

    @Value.Default
    default public Map<String, Object> parameters() {
        return Collections.emptyMap();
    }

    @Override
    @Value.Default
    @Value.Parameter(value=false)
    default public boolean validateRelationships() {
        return true;
    }

    @Override
    @Configuration.Ignore
    default public GraphStoreFactory.Supplier graphStoreFactory() {
        return new GraphStoreFactory.Supplier(){

            @Override
            public GraphStoreFactory<? extends GraphStore, ? extends GraphProjectConfig> get(GraphLoaderContext loaderContext) {
                return new CypherFactory(GraphProjectFromCypherConfig.this, loaderContext);
            }

            @Override
            public GraphStoreFactory<? extends GraphStore, ? extends GraphProjectConfig> getWithDimension(GraphLoaderContext loaderContext, GraphDimensions graphDimensions) {
                return new CypherFactory(GraphProjectFromCypherConfig.this, loaderContext, graphDimensions);
            }
        };
    }

    @Value.Default
    @Value.Parameter(value=false)
    default public boolean sudo() {
        return true;
    }

    @Override
    @Configuration.Ignore
    default public <R> R accept(GraphProjectConfig.Cases<R> visitor) {
        return visitor.cypher(this);
    }

    @Value.Derived
    @Configuration.Ignore
    default public Set<String> outputFieldDenylist() {
        return Set.of("nodeCount", "relationshipCount");
    }

    public static GraphProjectFromCypherConfig of(String userName, String graphName, String nodeQuery, String relationshipQuery, CypherMapWrapper config) {
        GraphProjectFromCypherConfig.assertNoProjectionsOrExplicitProperties(config);
        if (nodeQuery != null) {
            config = config.withString(NODE_QUERY_KEY, nodeQuery);
        }
        if (relationshipQuery != null) {
            config = config.withString(RELATIONSHIP_QUERY_KEY, relationshipQuery);
        }
        return new GraphProjectFromCypherConfigImpl(userName, graphName, config);
    }

    public static GraphProjectFromCypherConfig fromProcedureConfig(String username, CypherMapWrapper config) {
        GraphProjectFromCypherConfig.assertNoProjectionsOrExplicitProperties(config);
        return new GraphProjectFromCypherConfigImpl(username, "", config);
    }

    public static void assertNoProjectionsOrExplicitProperties(CypherMapWrapper config) {
        for (String forbiddenKey : FORBIDDEN_KEYS) {
            if (!config.containsKey(forbiddenKey)) continue;
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Invalid key: %s", (Object[])new Object[]{forbiddenKey}));
        }
    }
}

