/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.config;

import java.time.ZonedDateTime;
import org.immutables.value.Value;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.annotation.Configuration;
import org.neo4j.gds.api.GraphStoreFactory;
import org.neo4j.gds.concurrency.ConcurrencyValidatorService;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.GraphProjectFromCypherConfig;
import org.neo4j.gds.config.GraphProjectFromGraphConfig;
import org.neo4j.gds.config.GraphProjectFromStoreConfig;
import org.neo4j.gds.config.GraphSampleProcConfig;
import org.neo4j.gds.config.JobIdConfig;
import org.neo4j.gds.config.RandomGraphGeneratorConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.StringIdentifierValidations;
import org.neo4j.gds.core.Username;
import org.neo4j.gds.core.utils.TimeUtil;

public interface GraphProjectConfig
extends BaseConfig,
JobIdConfig {
    public static final String IMPLICIT_GRAPH_NAME = "";
    public static final String NODE_COUNT_KEY = "nodeCount";
    public static final String RELATIONSHIP_COUNT_KEY = "relationshipCount";
    public static final String READ_CONCURRENCY_KEY = "readConcurrency";
    public static final String VALIDATE_RELATIONSHIPS_KEY = "validateRelationships";

    @Configuration.Parameter
    @Value.Default
    default public String username() {
        return Username.EMPTY_USERNAME.username();
    }

    @Configuration.Parameter
    @Configuration.ConvertWith(value="validateName")
    public String graphName();

    @Value.Default
    @Value.Parameter(value=false)
    @Configuration.Key(value="readConcurrency")
    default public int readConcurrency() {
        return 4;
    }

    @Value.Default
    @Value.Parameter(value=false)
    @Configuration.Key(value="nodeCount")
    default public long nodeCount() {
        return -1L;
    }

    @Value.Default
    @Value.Parameter(value=false)
    @Configuration.Key(value="relationshipCount")
    default public long relationshipCount() {
        return -1L;
    }

    @Value.Parameter(value=false)
    @Configuration.Ignore
    default public boolean isFictitiousLoading() {
        return this.nodeCount() > -1L || this.relationshipCount() > -1L;
    }

    @Value.Derived
    @Value.Auxiliary
    default public ZonedDateTime creationTime() {
        return TimeUtil.now();
    }

    @Value.Default
    @Value.Parameter(value=false)
    @Configuration.Key(value="validateRelationships")
    default public boolean validateRelationships() {
        return false;
    }

    @Configuration.Ignore
    public GraphStoreFactory.Supplier graphStoreFactory();

    @Value.Check
    default public void validateReadConcurrency() {
        ConcurrencyValidatorService.validator().validate(this.readConcurrency(), READ_CONCURRENCY_KEY, 4);
    }

    @Configuration.Ignore
    public <R> R accept(Cases<R> var1);

    @Nullable
    public static String validateName(String input) {
        return StringIdentifierValidations.validateNoWhiteCharacter((String)input, (String)"graphName");
    }

    public static GraphProjectConfig createImplicit(String username, CypherMapWrapper config) {
        CypherMapWrapper.PairResult result = config.verifyMutuallyExclusivePairs("nodeProjection", "relationshipProjection", "nodeQuery", "relationshipQuery", "Missing information for implicit graph creation.");
        if (result == CypherMapWrapper.PairResult.FIRST_PAIR) {
            return GraphProjectFromStoreConfig.fromProcedureConfig(username, config);
        }
        return GraphProjectFromCypherConfig.fromProcedureConfig(username, config);
    }

    public static interface Visitor
    extends Cases<Void> {
        @Override
        default public Void store(GraphProjectFromStoreConfig storeConfig) {
            this.visit(storeConfig);
            return null;
        }

        @Override
        default public Void cypher(GraphProjectFromCypherConfig cypherConfig) {
            this.visit(cypherConfig);
            return null;
        }

        @Override
        default public Void graph(GraphProjectFromGraphConfig graphConfig) {
            this.visit(graphConfig);
            return null;
        }

        @Override
        default public Void random(RandomGraphGeneratorConfig randomGraphConfig) {
            this.visit(randomGraphConfig);
            return null;
        }

        @Override
        default public Void sample(GraphSampleProcConfig sampleProcConfig) {
            this.visit(sampleProcConfig);
            return null;
        }

        default public void visit(GraphProjectFromStoreConfig storeConfig) {
        }

        default public void visit(GraphProjectFromCypherConfig cypherConfig) {
        }

        default public void visit(GraphProjectFromGraphConfig graphConfig) {
        }

        default public void visit(RandomGraphGeneratorConfig randomGraphConfig) {
        }

        default public void visit(GraphSampleProcConfig sampleProcConfig) {
        }
    }

    public static interface Cases<R> {
        public R store(GraphProjectFromStoreConfig var1);

        public R cypher(GraphProjectFromCypherConfig var1);

        public R graph(GraphProjectFromGraphConfig var1);

        public R random(RandomGraphGeneratorConfig var1);

        public R sample(GraphSampleProcConfig var1);
    }
}

