/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.config;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.neo4j.gds.annotation.Configuration;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.core.StringSimilarity;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.gds.utils.StringJoining;

public interface GraphAccessGraphPropertiesConfig
extends BaseConfig {
    @Configuration.Parameter
    public Optional<String> graphName();

    @Configuration.Parameter
    public String graphProperty();

    @Configuration.Ignore
    default public void validate(GraphStore graphStore) {
        if (!graphStore.hasGraphProperty(this.graphProperty())) {
            List candidates = StringSimilarity.similarStringsIgnoreCase((CharSequence)this.graphProperty(), graphStore.graphPropertyKeys());
            String message = !candidates.isEmpty() ? StringFormatting.formatWithLocale((String)"Did you mean: %s.", (Object[])new Object[]{StringJoining.join((Collection)candidates)}) : StringFormatting.formatWithLocale((String)"The following properties exist in the graph %s.", (Object[])new Object[]{StringJoining.join(graphStore.graphPropertyKeys())});
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"The specified graph property '%s' does not exist. %s", (Object[])new Object[]{this.graphProperty(), message}));
        }
    }
}

