/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.immutables.value.Value;
import org.neo4j.gds.ElementIdentifier;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.annotation.Configuration;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.gds.utils.StringJoining;

public interface FeaturePropertiesConfig {
    @Value.Default
    default public List<String> featureProperties() {
        return List.of();
    }

    @Configuration.Ignore
    default public boolean propertiesMustExistForEachNodeLabel() {
        return true;
    }

    @Configuration.GraphStoreValidationCheck
    default public void validateFeatureProperties(GraphStore graphStore, Collection<NodeLabel> selectedLabels, Collection<RelationshipType> selectedRelationshipTypes) {
        if (this.propertiesMustExistForEachNodeLabel()) {
            List missingProperties = this.featureProperties().stream().filter(featureProperty -> !graphStore.hasNodeProperty(selectedLabels, (String)featureProperty)).collect(Collectors.toList());
            if (!missingProperties.isEmpty()) {
                throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"The feature properties %s are not present for all requested labels. Requested labels: %s. Properties available on all requested labels: %s", (Object[])new Object[]{StringJoining.join(missingProperties), StringJoining.join(selectedLabels.stream().map(ElementIdentifier::name)), StringJoining.join(graphStore.nodePropertyKeys(selectedLabels))}));
            }
        } else {
            Set availableProperties = selectedLabels.stream().flatMap(label -> graphStore.nodePropertyKeys((NodeLabel)label).stream()).collect(Collectors.toSet());
            ArrayList<String> missingProperties = new ArrayList<String>(this.featureProperties());
            missingProperties.removeAll(availableProperties);
            if (!missingProperties.isEmpty()) {
                throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"The feature properties %s are not present for any of the requested labels. Requested labels: %s. Properties available on the requested labels: %s", (Object[])new Object[]{StringJoining.join(missingProperties), StringJoining.join(selectedLabels.stream().map(ElementIdentifier::name)), StringJoining.join(availableProperties)}));
            }
        }
    }
}

