/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.config;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.neo4j.gds.ElementIdentifier;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.gds.utils.StringJoining;

public final class ElementTypeValidator {
    private ElementTypeValidator() {
    }

    public static Collection<NodeLabel> resolve(GraphStore graphStore, Collection<String> labelFilterNames) {
        return labelFilterNames.contains("*") ? graphStore.nodeLabels() : (Collection)labelFilterNames.stream().map(NodeLabel::of).collect(Collectors.toSet());
    }

    public static Collection<RelationshipType> resolveTypes(GraphStore graphStore, Collection<String> relFilterNames) {
        return relFilterNames.contains("*") ? graphStore.relationshipTypes() : (Collection)relFilterNames.stream().map(RelationshipType::of).collect(Collectors.toSet());
    }

    public static void validate(GraphStore graphStore, Collection<NodeLabel> labelFilter, String filterName) {
        Set<NodeLabel> availableLabels = graphStore.nodeLabels();
        List invalidLabels = labelFilter.stream().filter(label -> !availableLabels.contains(label)).map(ElementIdentifier::name).collect(Collectors.toList());
        if (!invalidLabels.isEmpty()) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Could not find the specified %s of %s. Available labels are %s.", (Object[])new Object[]{filterName, StringJoining.join(invalidLabels.stream()), StringJoining.join(availableLabels.stream().map(ElementIdentifier::name))}));
        }
    }

    public static void validateTypes(GraphStore graphStore, Collection<RelationshipType> relFilter, String filterName) {
        Set<RelationshipType> availableTypes = graphStore.relationshipTypes();
        List invalidLabels = relFilter.stream().filter(label -> !availableTypes.contains(label)).map(ElementIdentifier::name).collect(Collectors.toList());
        if (!invalidLabels.isEmpty()) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Could not find the specified %s of %s. Available relationship types are %s.", (Object[])new Object[]{filterName, StringJoining.join(invalidLabels.stream()), StringJoining.join(availableTypes.stream().map(ElementIdentifier::name))}));
        }
    }

    public static Collection<NodeLabel> resolveAndValidate(GraphStore graphStore, Collection<String> labelFilterNames, String filterName) {
        Collection<NodeLabel> nodeLabels = ElementTypeValidator.resolve(graphStore, labelFilterNames);
        ElementTypeValidator.validate(graphStore, nodeLabels, filterName);
        return nodeLabels;
    }

    public static Collection<RelationshipType> resolveAndValidateTypes(GraphStore graphStore, Collection<String> relFilterNames, String filterName) {
        Collection<RelationshipType> relFilter = ElementTypeValidator.resolveTypes(graphStore, relFilterNames);
        ElementTypeValidator.validateTypes(graphStore, relFilter, filterName);
        return relFilter;
    }
}

