/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.neo4j.gds.config.DeleteRelationshipsConfig;
import org.neo4j.gds.core.CypherMapWrapper;

public final class DeleteRelationshipsConfigImpl
implements DeleteRelationshipsConfig {
    private String graphName;
    private String relationshipType;

    public DeleteRelationshipsConfigImpl(@NotNull String graphName, @NotNull String relationshipType) {
        ArrayList<IllegalArgumentException> errors = new ArrayList<IllegalArgumentException>();
        try {
            this.graphName = (String)CypherMapWrapper.failOnNull((String)"graphName", (Object)graphName);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.relationshipType = (String)CypherMapWrapper.failOnNull((String)"relationshipType", (Object)relationshipType);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        if (!errors.isEmpty()) {
            if (errors.size() == 1) {
                throw (IllegalArgumentException)errors.get(0);
            }
            String combinedErrorMsg = errors.stream().map(Throwable::getMessage).collect(Collectors.joining(System.lineSeparator() + "\t\t\t\t", "Multiple errors in configuration arguments:" + System.lineSeparator() + "\t\t\t\t", ""));
            IllegalArgumentException combinedError = new IllegalArgumentException(combinedErrorMsg);
            errors.forEach(error -> combinedError.addSuppressed((Throwable)error));
            throw combinedError;
        }
    }

    @Override
    public String graphName() {
        return this.graphName;
    }

    @Override
    public String relationshipType() {
        return this.relationshipType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, Object> config = new HashMap<String, Object>();
        @NotNull
        private String graphName;
        @NotNull
        private String relationshipType;

        public Builder graphName(String graphName) {
            this.graphName = graphName;
            return this;
        }

        public Builder relationshipType(String relationshipType) {
            this.relationshipType = relationshipType;
            return this;
        }

        public DeleteRelationshipsConfig build() {
            CypherMapWrapper config = CypherMapWrapper.create(this.config);
            return new DeleteRelationshipsConfigImpl(this.graphName, this.relationshipType);
        }
    }
}

