/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.config;

import java.util.Set;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.annotation.Configuration;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.config.DeleteRelationshipsConfigImpl;
import org.neo4j.gds.utils.StringFormatting;

@ValueClass
@Configuration
public interface DeleteRelationshipsConfig {
    @Configuration.Parameter
    public String graphName();

    @Configuration.Parameter
    public String relationshipType();

    public static DeleteRelationshipsConfig of(String graphName, String relationshipType) {
        return new DeleteRelationshipsConfigImpl(graphName, relationshipType);
    }

    @Configuration.Ignore
    default public void validate(GraphStore graphStore) {
        Set<RelationshipType> relationshipTypes = graphStore.relationshipTypes();
        if (relationshipTypes.size() == 1) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Deleting the last relationship type ('%s') from a graph ('%s') is not supported. Use `gds.graph.drop()` to drop the entire graph instead.", (Object[])new Object[]{this.relationshipType(), this.graphName()}));
        }
        if (!relationshipTypes.contains(RelationshipType.of((String)this.relationshipType()))) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"No relationship type '%s' found in graph '%s'.", (Object[])new Object[]{this.relationshipType(), this.graphName()}));
        }
    }
}

