/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.config;

import java.util.Collection;
import java.util.stream.Collectors;
import org.immutables.value.Value;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.annotation.Configuration;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.core.StringIdentifierValidations;
import org.neo4j.gds.utils.StringFormatting;

public interface ConfigurableSeedConfig {
    @Value.Default
    @Configuration.ConvertWith(value="validateProperty")
    @Nullable
    default public String seedProperty() {
        return null;
    }

    @Configuration.Ignore
    default public String propertyNameOverride() {
        return "seedProperty";
    }

    @Nullable
    public static String validateProperty(String input) {
        return StringIdentifierValidations.validateNoWhiteCharacter((String)StringIdentifierValidations.emptyToNull((String)input), (String)"seedProperty");
    }

    @Configuration.GraphStoreValidationCheck
    default public void validateConfigurableSeedConfig(GraphStore graphStore, Collection<NodeLabel> selectedLabels, Collection<RelationshipType> selectedRelationshipTypes) {
        String seedProperty = this.seedProperty();
        if (seedProperty != null && !graphStore.hasNodeProperty(selectedLabels, seedProperty)) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"`%s`: `%s` not found in graph with node properties: %s", (Object[])new Object[]{this.propertyNameOverride(), seedProperty, graphStore.nodePropertyKeys().stream().sorted().collect(Collectors.toList())}));
        }
    }
}

