/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.config;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.neo4j.gds.ElementIdentifier;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.gds.utils.StringJoining;

final class ConfigNodesValidations {
    private ConfigNodesValidations() {
    }

    static void validateNodes(GraphStore graphStore, Collection<Long> neoNodesToValidate, Collection<NodeLabel> filteredNodeLabels, String nodeDescription) {
        List missingNodes;
        if (!neoNodesToValidate.isEmpty() && !(missingNodes = neoNodesToValidate.stream().filter(targetNode -> ConfigNodesValidations.labelFilteredGraphNotContainsNode(filteredNodeLabels, graphStore.nodes(), targetNode)).map(Object::toString).collect(Collectors.toList())).isEmpty()) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"%s nodes do not exist in the in-memory graph%s: %s", (Object[])new Object[]{nodeDescription, ConfigNodesValidations.nodeLabelFilterDescription(filteredNodeLabels, graphStore), StringJoining.join(missingNodes)}));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean labelFilteredGraphNotContainsNode(Collection<NodeLabel> filteredNodeLabels, IdMap idMap, long neoNodeId) {
        long internalNodeId = idMap.safeToMappedNodeId(neoNodeId);
        if (internalNodeId == -1L) return true;
        if (!idMap.nodeLabels(internalNodeId).stream().noneMatch(filteredNodeLabels::contains)) return false;
        return true;
    }

    static String nodeLabelFilterDescription(Collection<NodeLabel> filteredNodeLabels, GraphStore graphStore) {
        return filteredNodeLabels.containsAll(graphStore.nodeLabels()) ? "" : " for the labels " + StringJoining.join(filteredNodeLabels.stream().map(ElementIdentifier::name));
    }
}

