/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.config;

import org.immutables.value.Value;
import org.neo4j.gds.annotation.Configuration;
import org.neo4j.gds.concurrency.ConcurrencyValidatorService;

public interface ConcurrencyConfig {
    public static final String CONCURRENCY_KEY = "concurrency";
    public static final int DEFAULT_CONCURRENCY = 4;
    public static final int CONCURRENCY_LIMITATION = 4;

    @Value.Default
    @Configuration.Key(value="concurrency")
    default public int concurrency() {
        return 4;
    }

    @Value.Default
    @Configuration.Ignore
    default public int minBatchSize() {
        return 10000;
    }

    @Value.Check
    default public void validateConcurrency() {
        ConcurrencyValidatorService.validator().validate(this.concurrency(), CONCURRENCY_KEY, 4);
    }
}

