/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.config;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.immutables.value.Value;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.annotation.Configuration;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.ConcurrencyConfig;
import org.neo4j.gds.config.ElementTypeValidator;
import org.neo4j.gds.config.JobIdConfig;

public interface AlgoBaseConfig
extends BaseConfig,
ConcurrencyConfig,
JobIdConfig {
    public static final String NODE_LABELS_KEY = "nodeLabels";
    public static final String RELATIONSHIP_TYPES_KEY = "relationshipTypes";

    @Value.Default
    @Configuration.Key(value="relationshipTypes")
    default public List<String> relationshipTypes() {
        return Collections.singletonList("*");
    }

    @Configuration.Ignore
    default public Collection<RelationshipType> internalRelationshipTypes(GraphStore graphStore) {
        return ElementTypeValidator.resolveTypes(graphStore, this.relationshipTypes());
    }

    @Value.Default
    @Configuration.Key(value="nodeLabels")
    default public List<String> nodeLabels() {
        return Collections.singletonList("*");
    }

    @Configuration.Ignore
    default public Collection<NodeLabel> nodeLabelIdentifiers(GraphStore graphStore) {
        return ElementTypeValidator.resolve(graphStore, this.nodeLabels());
    }

    @Configuration.GraphStoreValidation
    @Value.Auxiliary
    @Value.Default
    default public void graphStoreValidation(GraphStore graphStore, Collection<NodeLabel> selectedLabels, Collection<RelationshipType> selectedRelationshipTypes) {
    }

    @Configuration.GraphStoreValidationCheck
    default public void validateNodeLabels(GraphStore graphStore, Collection<NodeLabel> selectedLabels, Collection<RelationshipType> selectedRelationshipTypes) {
        ElementTypeValidator.validate(graphStore, selectedLabels, "`nodeLabels`");
    }

    @Configuration.GraphStoreValidationCheck
    default public void validateRelationshipTypes(GraphStore graphStore, Collection<NodeLabel> selectedLabels, Collection<RelationshipType> selectedRelationshipTypes) {
        ElementTypeValidator.validateTypes(graphStore, selectedRelationshipTypes, "`relationshipTypes`");
    }
}

