/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.generator;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.function.LongUnaryOperator;
import java.util.stream.Collectors;
import org.neo4j.gds.core.utils.statistics.DistributionHelper;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.gds.utils.StringJoining;

public enum RelationshipDistribution {
    UNIFORM{

        @Override
        public LongUnaryOperator degreeProducer(long nodeCount, long averageDegree, Random random) {
            return ignore -> averageDegree;
        }

        @Override
        public LongUnaryOperator relationshipProducer(long nodeCount, long averageDegree, Random random) {
            return ignore -> DistributionHelper.uniformSample(nodeCount, random);
        }
    }
    ,
    RANDOM{

        @Override
        public LongUnaryOperator degreeProducer(long nodeCount, long averageDegree, Random random) {
            long stdDev = averageDegree / 2L;
            return ignore -> DistributionHelper.gaussianSample(nodeCount, averageDegree, stdDev, random);
        }

        @Override
        public LongUnaryOperator relationshipProducer(long nodeCount, long averageDegree, Random random) {
            return ignore -> DistributionHelper.uniformSample(nodeCount, random);
        }
    }
    ,
    POWER_LAW{

        @Override
        public LongUnaryOperator degreeProducer(long nodeCount, long averageDegree, Random random) {
            long stdDev = averageDegree / 2L;
            return ignore -> DistributionHelper.gaussianSample(nodeCount, averageDegree, stdDev, random);
        }

        @Override
        public LongUnaryOperator relationshipProducer(long nodeCount, long averageDegree, Random random) {
            long min = 1L;
            double gamma = 1.0 + 1.0 / (double)averageDegree;
            return ignore -> DistributionHelper.powerLawSample(min, nodeCount - 1L, gamma, random);
        }
    };

    private static final List<String> VALUES;

    public static RelationshipDistribution parse(Object object) {
        if (object instanceof String) {
            String inputString = StringFormatting.toUpperCaseWithLocale((String)((String)object));
            if (!VALUES.contains(inputString)) {
                throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"RelationshipDistribution `%s` is not supported. Must be one of: %s.", (Object[])new Object[]{object, StringJoining.join(VALUES)}));
            }
            return RelationshipDistribution.valueOf(inputString);
        }
        if (object instanceof RelationshipDistribution) {
            return (RelationshipDistribution)((Object)object);
        }
        throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Expected RelationshipDistribution or String. Got %s.", (Object[])new Object[]{object.getClass().getSimpleName()}));
    }

    public static String toString(RelationshipDistribution distribution) {
        return distribution.toString();
    }

    public abstract LongUnaryOperator degreeProducer(long var1, long var3, Random var5);

    public abstract LongUnaryOperator relationshipProducer(long var1, long var3, Random var5);

    static {
        VALUES = Arrays.stream(RelationshipDistribution.values()).map(Enum::name).collect(Collectors.toList());
    }
}

