/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.generator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.Orientation;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.beta.generator.NodeLabelProducer;
import org.neo4j.gds.beta.generator.PropertyProducer;
import org.neo4j.gds.beta.generator.RandomGraphGenerator;
import org.neo4j.gds.beta.generator.RelationshipDistribution;
import org.neo4j.gds.config.RandomGraphGeneratorConfig;
import org.neo4j.gds.core.Aggregation;

public class RandomGraphGeneratorBuilder {
    private long nodeCount;
    private long averageDegree;
    private RelationshipDistribution relationshipDistribution;
    private long seed = 0L;
    private Optional<NodeLabelProducer> maybeNodeLabelProducer = Optional.empty();
    private final Map<NodeLabel, Set<PropertyProducer<?>>> nodePropertyProducers = new HashMap();
    private Optional<PropertyProducer<double[]>> maybeRelationshipPropertyProducer = Optional.empty();
    private Aggregation aggregation = Aggregation.NONE;
    private Orientation orientation = Orientation.NATURAL;
    private RandomGraphGeneratorConfig.AllowSelfLoops allowSelfLoops = RandomGraphGeneratorConfig.AllowSelfLoops.NO;
    private RelationshipType relationshipType = RelationshipType.of((String)"REL");

    public RandomGraphGeneratorBuilder nodeCount(long nodeCount) {
        this.nodeCount = nodeCount;
        return this;
    }

    public RandomGraphGeneratorBuilder averageDegree(long averageDegree) {
        this.averageDegree = averageDegree;
        return this;
    }

    public RandomGraphGeneratorBuilder relationshipType(RelationshipType relationshipType) {
        this.relationshipType = relationshipType;
        return this;
    }

    public RandomGraphGeneratorBuilder relationshipDistribution(RelationshipDistribution relationshipDistribution) {
        this.relationshipDistribution = relationshipDistribution;
        return this;
    }

    public RandomGraphGeneratorBuilder seed(long seed) {
        this.seed = seed;
        return this;
    }

    public RandomGraphGeneratorBuilder nodeLabelProducer(NodeLabelProducer nodeLabelProducer) {
        this.maybeNodeLabelProducer = Optional.of(nodeLabelProducer);
        return this;
    }

    public RandomGraphGeneratorBuilder nodePropertyProducer(PropertyProducer<?> nodePropertyProducer) {
        return this.addNodePropertyProducer(NodeLabel.ALL_NODES, nodePropertyProducer);
    }

    public RandomGraphGeneratorBuilder addNodePropertyProducer(NodeLabel nodeLabel, PropertyProducer<?> nodePropertyProducer) {
        if (nodePropertyProducer.getPropertyName() != null) {
            this.nodePropertyProducers.computeIfAbsent(nodeLabel, ignore -> new HashSet()).add(nodePropertyProducer);
        }
        return this;
    }

    public RandomGraphGeneratorBuilder relationshipPropertyProducer(PropertyProducer<double[]> relationshipPropertyProducer) {
        this.maybeRelationshipPropertyProducer = Optional.of(relationshipPropertyProducer);
        return this;
    }

    public RandomGraphGeneratorBuilder aggregation(Aggregation aggregation) {
        this.aggregation = aggregation;
        return this;
    }

    public RandomGraphGeneratorBuilder orientation(Orientation orientation) {
        this.orientation = orientation;
        return this;
    }

    public RandomGraphGeneratorBuilder allowSelfLoops(RandomGraphGeneratorConfig.AllowSelfLoops allowSelfLoops) {
        this.allowSelfLoops = allowSelfLoops;
        return this;
    }

    public RandomGraphGenerator build() {
        this.validate();
        return new RandomGraphGenerator(this.nodeCount, this.averageDegree, this.relationshipType, this.relationshipDistribution, this.seed, this.maybeNodeLabelProducer, this.nodePropertyProducers, this.maybeRelationshipPropertyProducer, this.aggregation, this.orientation, this.allowSelfLoops);
    }

    private void validate() {
        if (this.nodeCount <= 0L) {
            throw new IllegalArgumentException("Must provide positive nodeCount");
        }
        if (this.averageDegree <= 0L) {
            throw new IllegalArgumentException("Must provide positive averageDegree");
        }
        if (this.relationshipDistribution == null) {
            throw new IllegalArgumentException("Must provide a RelationshipDistribution");
        }
    }
}

