/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.generator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.PrimitiveIterator;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.function.LongUnaryOperator;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.Orientation;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.api.DefaultValue;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.api.Relationships;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.api.schema.GraphSchema;
import org.neo4j.gds.api.schema.NodeSchema;
import org.neo4j.gds.api.schema.RelationshipSchema;
import org.neo4j.gds.beta.generator.ImmutableNodePropertiesAndSchema;
import org.neo4j.gds.beta.generator.NodeLabelProducer;
import org.neo4j.gds.beta.generator.PropertyProducer;
import org.neo4j.gds.beta.generator.RandomGraphGeneratorBuilder;
import org.neo4j.gds.beta.generator.RelationshipDistribution;
import org.neo4j.gds.config.RandomGraphGeneratorConfig;
import org.neo4j.gds.core.Aggregation;
import org.neo4j.gds.core.huge.HugeGraph;
import org.neo4j.gds.core.loading.construction.GraphFactory;
import org.neo4j.gds.core.loading.construction.NodesBuilder;
import org.neo4j.gds.core.loading.construction.RelationshipsBuilder;
import org.neo4j.gds.core.utils.paged.HugeArray;
import org.neo4j.gds.core.utils.paged.HugeCursor;
import org.neo4j.gds.core.utils.paged.HugeDoubleArray;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.core.utils.paged.HugeObjectArray;
import org.neo4j.gds.utils.StringFormatting;

public final class RandomGraphGenerator {
    private final long nodeCount;
    private final long averageDegree;
    private final Random random;
    private final RelationshipType relationshipType;
    private final RelationshipDistribution relationshipDistribution;
    private final Aggregation aggregation;
    private final Orientation orientation;
    private final RandomGraphGeneratorConfig.AllowSelfLoops allowSelfLoops;
    private final Optional<NodeLabelProducer> maybeNodeLabelProducer;
    private final Optional<PropertyProducer<double[]>> maybeRelationshipPropertyProducer;
    private final Map<NodeLabel, Set<PropertyProducer<?>>> nodePropertyProducers;

    RandomGraphGenerator(long nodeCount, long averageDegree, RelationshipType relationshipType, RelationshipDistribution relationshipDistribution, @Nullable Long seed, Optional<NodeLabelProducer> maybeNodeLabelProducer, Map<NodeLabel, Set<PropertyProducer<?>>> nodePropertyProducers, Optional<PropertyProducer<double[]>> maybeRelationshipPropertyProducer, Aggregation aggregation, Orientation orientation, RandomGraphGeneratorConfig.AllowSelfLoops allowSelfLoops) {
        this.relationshipType = relationshipType;
        this.relationshipDistribution = relationshipDistribution;
        this.maybeNodeLabelProducer = maybeNodeLabelProducer;
        this.nodePropertyProducers = nodePropertyProducers;
        this.maybeRelationshipPropertyProducer = maybeRelationshipPropertyProducer;
        this.nodeCount = nodeCount;
        this.averageDegree = averageDegree;
        this.aggregation = aggregation;
        this.orientation = orientation;
        this.allowSelfLoops = allowSelfLoops;
        this.random = new Random();
        if (seed != null) {
            this.random.setSeed(seed);
        } else {
            this.random.setSeed(1L);
        }
    }

    public static RandomGraphGeneratorBuilder builder() {
        return new RandomGraphGeneratorBuilder();
    }

    public HugeGraph generate() {
        NodesBuilder nodesBuilder = GraphFactory.initNodesBuilder().maxOriginalId(this.nodeCount).hasLabelInformation(this.maybeNodeLabelProducer.isPresent()).build();
        if (this.maybeNodeLabelProducer.isPresent()) {
            this.generateNodes(nodesBuilder, this.maybeNodeLabelProducer.get());
        } else {
            this.generateNodes(nodesBuilder);
        }
        IdMap idMap = nodesBuilder.build().idMap();
        NodePropertiesAndSchema nodePropertiesAndSchema = this.generateNodeProperties(idMap);
        RelationshipsBuilder relationshipsBuilder = GraphFactory.initRelationshipsBuilder().nodes(idMap).orientation(this.orientation).addAllPropertyConfigs(this.maybeRelationshipPropertyProducer.isPresent() ? List.of(GraphFactory.PropertyConfig.of(this.aggregation, DefaultValue.forDouble())) : List.of()).aggregation(this.aggregation).build();
        this.generateRelationships(relationshipsBuilder);
        Relationships relationships = relationshipsBuilder.build();
        RelationshipSchema relationshipSchema = this.relationshipSchema();
        GraphSchema graphSchema = GraphSchema.of((NodeSchema)nodePropertiesAndSchema.nodeSchema(), (RelationshipSchema)relationshipSchema, Map.of());
        return GraphFactory.create(graphSchema, idMap, nodePropertiesAndSchema.nodeProperties(), relationships);
    }

    private RelationshipSchema relationshipSchema() {
        RelationshipSchema.Builder relationshipSchemaBuilder = RelationshipSchema.builder();
        relationshipSchemaBuilder.addRelationshipType(this.relationshipType, this.orientation);
        this.maybeRelationshipPropertyProducer.ifPresent(pp -> relationshipSchemaBuilder.addProperty(this.relationshipType, this.orientation, pp.getPropertyName(), pp.propertyType()));
        return relationshipSchemaBuilder.build();
    }

    public RelationshipDistribution getRelationshipDistribution() {
        return this.relationshipDistribution;
    }

    public Optional<PropertyProducer<double[]>> getMaybeRelationshipPropertyProducer() {
        return this.maybeRelationshipPropertyProducer;
    }

    private void generateNodes(NodesBuilder nodesBuilder, NodeLabelProducer nodeLabelProducer) {
        for (long i = 0L; i < this.nodeCount; ++i) {
            nodesBuilder.addNode(i, nodeLabelProducer.labels(i));
        }
    }

    private void generateNodes(NodesBuilder nodesBuilder) {
        for (long i = 0L; i < this.nodeCount; ++i) {
            nodesBuilder.addNode(i);
        }
    }

    private void generateRelationships(RelationshipsBuilder relationshipsImporter) {
        LongUnaryOperator degreeProducer = this.relationshipDistribution.degreeProducer(this.nodeCount, this.averageDegree, this.random);
        LongUnaryOperator relationshipProducer = this.relationshipDistribution.relationshipProducer(this.nodeCount, this.averageDegree, this.random);
        PropertyProducer relationshipPropertyProducer = this.maybeRelationshipPropertyProducer.orElseGet(PropertyProducer.EmptyPropertyProducer::new);
        double[] property = new double[1];
        for (long nodeId = 0L; nodeId < this.nodeCount; ++nodeId) {
            long degree = degreeProducer.applyAsLong(nodeId);
            int j = 0;
            while ((long)j < degree) {
                long targetId = relationshipProducer.applyAsLong(nodeId);
                if (!this.allowSelfLoops.value()) {
                    while (targetId == nodeId) {
                        targetId = relationshipProducer.applyAsLong(nodeId);
                    }
                }
                assert (targetId < this.nodeCount);
                relationshipPropertyProducer.setProperty(nodeId, property, 0, this.random);
                if (this.relationshipDistribution == RelationshipDistribution.POWER_LAW) {
                    relationshipsImporter.addFromInternal(targetId, nodeId, property[0]);
                } else {
                    relationshipsImporter.addFromInternal(nodeId, targetId, property[0]);
                }
                ++j;
            }
        }
    }

    private NodePropertiesAndSchema generateNodeProperties(IdMap idMap) {
        if (this.nodePropertyProducers.isEmpty()) {
            NodeSchema.Builder nodeSchemaBuilder = NodeSchema.builder();
            idMap.availableNodeLabels().forEach(arg_0 -> ((NodeSchema.Builder)nodeSchemaBuilder).addLabel(arg_0));
            return ImmutableNodePropertiesAndSchema.builder().nodeSchema(nodeSchemaBuilder.build()).nodeProperties(Map.of()).build();
        }
        HashMap propertyNameToLabels = new HashMap();
        HashMap propertyNameToProducers = new HashMap();
        this.nodePropertyProducers.forEach((nodeLabel, propertyProducers) -> {
            if (nodeLabel != NodeLabel.ALL_NODES && !idMap.availableNodeLabels().contains(nodeLabel)) {
                return;
            }
            propertyProducers.forEach(propertyProducer -> {
                propertyNameToLabels.computeIfAbsent(propertyProducer.getPropertyName(), ignore -> new ArrayList()).add(nodeLabel);
                propertyNameToProducers.merge(propertyProducer.getPropertyName(), propertyProducer, (first, second) -> {
                    if (!first.equals(second)) {
                        throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Duplicate node properties with name [%s]. The first property producer is [%s], the second one is [%s].", (Object[])new Object[]{first.getPropertyName(), first, second}));
                    }
                    return first;
                });
            });
        });
        Map<String, NodePropertyValues> generatedProperties = propertyNameToProducers.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            HashSet<NodeLabel> nodeLabels = new HashSet<NodeLabel>((Collection)propertyNameToLabels.get(entry.getKey()));
            PrimitiveIterator.OfLong nodes = idMap.nodeIterator(nodeLabels);
            return this.generateProperties(nodes, (PropertyProducer)entry.getValue());
        }));
        NodeSchema.Builder nodeSchemaBuilder = NodeSchema.builder();
        generatedProperties.forEach((propertyKey, property) -> ((List)propertyNameToLabels.get(propertyKey)).forEach(nodeLabel -> {
            if (nodeLabel == NodeLabel.ALL_NODES) {
                idMap.availableNodeLabels().forEach(actualNodeLabel -> nodeSchemaBuilder.addProperty(actualNodeLabel, propertyKey, property.valueType()));
            } else {
                nodeSchemaBuilder.addProperty(nodeLabel, propertyKey, property.valueType());
            }
        }));
        return ImmutableNodePropertiesAndSchema.builder().nodeProperties(generatedProperties).nodeSchema(nodeSchemaBuilder.build()).build();
    }

    private NodePropertyValues generateProperties(PrimitiveIterator.OfLong nodes, PropertyProducer<?> propertyProducer) {
        switch (propertyProducer.propertyType()) {
            case LONG: {
                HugeLongArray longValues = HugeLongArray.newArray(this.nodeCount);
                longValues.fill(DefaultValue.forLong().longValue());
                return this.generateProperties(nodes, longValues, propertyProducer, HugeLongArray::asNodeProperties);
            }
            case DOUBLE: {
                HugeDoubleArray doubleValues = HugeDoubleArray.newArray(this.nodeCount);
                doubleValues.fill(DefaultValue.forDouble().doubleValue());
                return this.generateProperties(nodes, doubleValues, propertyProducer, HugeDoubleArray::asNodeProperties);
            }
            case DOUBLE_ARRAY: {
                return this.generateProperties(nodes, HugeObjectArray.newArray(double[].class, this.nodeCount), propertyProducer, HugeObjectArray::asNodeProperties);
            }
            case FLOAT_ARRAY: {
                return this.generateProperties(nodes, HugeObjectArray.newArray(float[].class, this.nodeCount), propertyProducer, HugeObjectArray::asNodeProperties);
            }
            case LONG_ARRAY: {
                return this.generateProperties(nodes, HugeObjectArray.newArray(long[].class, this.nodeCount), propertyProducer, HugeObjectArray::asNodeProperties);
            }
        }
        throw new UnsupportedOperationException("properties producer must return a known value type");
    }

    private <T, A extends HugeArray<T, ?, A>> NodePropertyValues generateProperties(PrimitiveIterator.OfLong nodes, A values, PropertyProducer<T> propertyProducer, Function<A, NodePropertyValues> toProperties) {
        HugeCursor cursor = values.initCursor(values.newCursor());
        while (nodes.hasNext()) {
            long nodeId = nodes.nextLong();
            int i = this.seek(nodeId, cursor);
            propertyProducer.setProperty(nodeId, cursor.array, i, this.random);
        }
        return toProperties.apply(values);
    }

    private <T> int seek(long targetNode, HugeCursor<T> cursor) {
        while (cursor.base < targetNode && cursor.base + (long)cursor.limit < targetNode) {
            if (cursor.next()) continue;
            throw new IllegalStateException("");
        }
        return Math.toIntExact(targetNode - cursor.base);
    }

    @ValueClass
    static interface NodePropertiesAndSchema {
        public NodeSchema nodeSchema();

        public Map<String, NodePropertyValues> nodeProperties();
    }
}

