/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.generator;

import java.util.Objects;
import java.util.Random;
import org.neo4j.gds.api.nodeproperties.ValueType;

public interface PropertyProducer<PROPERTY_SLICE> {
    public static PropertyProducer<double[]> fixedDouble(String propertyName, double value) {
        return new FixedDoubleProducer(propertyName, value);
    }

    public static PropertyProducer<double[]> randomDouble(String propertyName, double min, double max) {
        return new RandomDoubleProducer(propertyName, min, max);
    }

    public static PropertyProducer<float[][]> randomEmbedding(String propertyName, int embeddingSize, float min, float max) {
        return new RandomEmbeddingProducer(propertyName, embeddingSize, min, max);
    }

    public static PropertyProducer<long[]> nodeIdAsLong(String propertyName) {
        return new NodeIdProducer(propertyName);
    }

    public static PropertyProducer<long[]> randomLong(String propertyName, long min, long max) {
        return new RandomLongProducer(propertyName, min, max);
    }

    public static PropertyProducer<long[][]> randomLongArray(String propertyName, int length, long min, long max) {
        return new RandomLongArrayProducer(propertyName, length, min, max);
    }

    public static PropertyProducer<double[][]> randomDoubleArray(String propertyName, int length, double min, double max) {
        return new RandomDoubleArrayProducer(propertyName, length, min, max);
    }

    public String getPropertyName();

    public ValueType propertyType();

    public void setProperty(long var1, PROPERTY_SLICE var3, int var4, Random var5);

    public static class EmptyPropertyProducer
    implements PropertyProducer<double[]> {
        @Override
        public String getPropertyName() {
            return null;
        }

        @Override
        public ValueType propertyType() {
            return ValueType.DOUBLE;
        }

        @Override
        public void setProperty(long nodeId, double[] doubles, int index, Random random) {
        }
    }

    public static class RandomDoubleArrayProducer
    implements PropertyProducer<double[][]> {
        private final String propertyName;
        private final int length;
        private final double min;
        private final double max;

        RandomDoubleArrayProducer(String propertyName, int length, double min, double max) {
            this.propertyName = propertyName;
            this.length = length;
            this.min = min;
            this.max = max;
            if (max <= min) {
                throw new IllegalArgumentException("Max value must be greater than min value");
            }
        }

        @Override
        public String getPropertyName() {
            return this.propertyName;
        }

        @Override
        public ValueType propertyType() {
            return ValueType.DOUBLE_ARRAY;
        }

        @Override
        public void setProperty(long nodeId, double[][] embeddings, int index, Random random) {
            double[] value = new double[this.length];
            for (int i = 0; i < this.length; ++i) {
                value[i] = this.min + random.nextDouble() * (this.max - this.min);
            }
            embeddings[index] = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RandomDoubleArrayProducer random = (RandomDoubleArrayProducer)o;
            return random.length == this.length && Double.compare(random.min, this.min) == 0 && Double.compare(random.max, this.max) == 0 && Objects.equals(this.propertyName, random.propertyName);
        }

        public int hashCode() {
            return Objects.hash(this.propertyName, this.length, this.min, this.max);
        }

        public String toString() {
            return "RandomDoubleProducer{propertyName='" + this.propertyName + "', length=" + this.length + ", min=" + this.min + ", max=" + this.max + "}";
        }
    }

    public static class RandomLongArrayProducer
    implements PropertyProducer<long[][]> {
        private final String propertyName;
        private final int length;
        private final long min;
        private final long max;

        RandomLongArrayProducer(String propertyName, int length, long min, long max) {
            this.propertyName = propertyName;
            this.length = length;
            this.min = min;
            this.max = max;
            if (max <= min) {
                throw new IllegalArgumentException("Max value must be greater than min value");
            }
        }

        @Override
        public String getPropertyName() {
            return this.propertyName;
        }

        @Override
        public ValueType propertyType() {
            return ValueType.LONG_ARRAY;
        }

        @Override
        public void setProperty(long nodeId, long[][] longs, int index, Random random) {
            long[] value = new long[this.length];
            for (int i = 0; i < this.length; ++i) {
                long modulo = random.nextLong() % (this.max - this.min);
                value[i] = modulo >= 0L ? modulo + this.min : modulo + this.max;
            }
            longs[index] = value;
        }
    }

    public static class RandomLongProducer
    implements PropertyProducer<long[]> {
        private final String propertyName;
        private final long min;
        private final long max;

        RandomLongProducer(String propertyName, long min, long max) {
            this.propertyName = propertyName;
            this.min = min;
            this.max = max;
            if (max <= min) {
                throw new IllegalArgumentException("Max value must be greater than min value");
            }
        }

        @Override
        public String getPropertyName() {
            return this.propertyName;
        }

        @Override
        public ValueType propertyType() {
            return ValueType.LONG;
        }

        @Override
        public void setProperty(long nodeId, long[] longs, int index, Random random) {
            long modulo = random.nextLong() % (this.max - this.min);
            longs[index] = modulo >= 0L ? modulo + this.min : modulo + this.max;
        }
    }

    public static class NodeIdProducer
    implements PropertyProducer<long[]> {
        private final String propertyName;

        NodeIdProducer(String propertyName) {
            this.propertyName = propertyName;
        }

        @Override
        public String getPropertyName() {
            return this.propertyName;
        }

        @Override
        public ValueType propertyType() {
            return ValueType.LONG;
        }

        @Override
        public void setProperty(long nodeId, long[] longs, int index, Random random) {
            longs[index] = nodeId;
        }
    }

    public static class RandomEmbeddingProducer
    implements PropertyProducer<float[][]> {
        private final String propertyName;
        private final int embeddingSize;
        private final float min;
        private final float max;

        public RandomEmbeddingProducer(String propertyName, int embeddingSize, float min, float max) {
            this.propertyName = propertyName;
            this.embeddingSize = embeddingSize;
            this.min = min;
            this.max = max;
            if (max <= min) {
                throw new IllegalArgumentException("Max value must be greater than min value");
            }
        }

        @Override
        public String getPropertyName() {
            return this.propertyName;
        }

        @Override
        public ValueType propertyType() {
            return ValueType.FLOAT_ARRAY;
        }

        @Override
        public void setProperty(long nodeId, float[][] embeddings, int index, Random random) {
            float[] nodeEmbeddings = new float[this.embeddingSize];
            for (int i = 0; i < this.embeddingSize; ++i) {
                nodeEmbeddings[i] = this.min + random.nextFloat() * (this.max - this.min);
            }
            embeddings[index] = nodeEmbeddings;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RandomEmbeddingProducer random = (RandomEmbeddingProducer)o;
            return random.embeddingSize == this.embeddingSize && Double.compare(random.min, this.min) == 0 && Double.compare(random.max, this.max) == 0 && Objects.equals(this.propertyName, random.propertyName);
        }

        public int hashCode() {
            return Objects.hash(this.propertyName, this.embeddingSize, Float.valueOf(this.min), Float.valueOf(this.max));
        }

        public String toString() {
            return "RandomDoubleProducer{propertyName='" + this.propertyName + "', embeddingSize=" + this.embeddingSize + ", min=" + this.min + ", max=" + this.max + "}";
        }
    }

    public static class RandomDoubleProducer
    implements PropertyProducer<double[]> {
        private final String propertyName;
        private final double min;
        private final double max;

        public RandomDoubleProducer(String propertyName, double min, double max) {
            this.propertyName = propertyName;
            this.min = min;
            this.max = max;
            if (max <= min) {
                throw new IllegalArgumentException("Max value must be greater than min value");
            }
        }

        @Override
        public String getPropertyName() {
            return this.propertyName;
        }

        @Override
        public ValueType propertyType() {
            return ValueType.DOUBLE;
        }

        @Override
        public void setProperty(long nodeId, double[] doubles, int index, Random random) {
            doubles[index] = this.min + random.nextDouble() * (this.max - this.min);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RandomDoubleProducer random = (RandomDoubleProducer)o;
            return Double.compare(random.min, this.min) == 0 && Double.compare(random.max, this.max) == 0 && Objects.equals(this.propertyName, random.propertyName);
        }

        public int hashCode() {
            return Objects.hash(this.propertyName, this.min, this.max);
        }

        public String toString() {
            return "RandomDoubleProducer{propertyName='" + this.propertyName + "', min=" + this.min + ", max=" + this.max + "}";
        }
    }

    public static class FixedDoubleProducer
    implements PropertyProducer<double[]> {
        private final String propertyName;
        private final double value;

        public FixedDoubleProducer(String propertyName, double value) {
            this.propertyName = propertyName;
            this.value = value;
        }

        @Override
        public String getPropertyName() {
            return this.propertyName;
        }

        @Override
        public ValueType propertyType() {
            return ValueType.DOUBLE;
        }

        @Override
        public void setProperty(long nodeId, double[] doubles, int index, Random random) {
            doubles[index] = this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FixedDoubleProducer fixedDoubleProducer = (FixedDoubleProducer)o;
            return Double.compare(fixedDoubleProducer.value, this.value) == 0 && Objects.equals(this.propertyName, fixedDoubleProducer.propertyName);
        }

        public int hashCode() {
            return Objects.hash(this.propertyName, this.value);
        }

        public String toString() {
            return "FixedDoubleProducer{propertyName='" + this.propertyName + "', value=" + this.value + "}";
        }
    }
}

