/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.generator;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.api.schema.NodeSchema;
import org.neo4j.gds.beta.generator.RandomGraphGenerator;

@ParametersAreNonnullByDefault
@Generated(from="RandomGraphGenerator.NodePropertiesAndSchema", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableNodePropertiesAndSchema
implements RandomGraphGenerator.NodePropertiesAndSchema {
    private final NodeSchema nodeSchema;
    private final Map<String, NodePropertyValues> nodeProperties;

    private ImmutableNodePropertiesAndSchema(NodeSchema nodeSchema, Map<String, ? extends NodePropertyValues> nodeProperties) {
        this.nodeSchema = Objects.requireNonNull(nodeSchema, "nodeSchema");
        this.nodeProperties = ImmutableNodePropertiesAndSchema.createUnmodifiableMap(true, false, nodeProperties);
    }

    private ImmutableNodePropertiesAndSchema(ImmutableNodePropertiesAndSchema original, NodeSchema nodeSchema, Map<String, NodePropertyValues> nodeProperties) {
        this.nodeSchema = nodeSchema;
        this.nodeProperties = nodeProperties;
    }

    @Override
    public NodeSchema nodeSchema() {
        return this.nodeSchema;
    }

    @Override
    public Map<String, NodePropertyValues> nodeProperties() {
        return this.nodeProperties;
    }

    public final ImmutableNodePropertiesAndSchema withNodeSchema(NodeSchema value) {
        if (this.nodeSchema == value) {
            return this;
        }
        NodeSchema newValue = Objects.requireNonNull(value, "nodeSchema");
        return new ImmutableNodePropertiesAndSchema(this, newValue, this.nodeProperties);
    }

    public final ImmutableNodePropertiesAndSchema withNodeProperties(Map<String, ? extends NodePropertyValues> entries) {
        if (this.nodeProperties == entries) {
            return this;
        }
        Map<String, NodePropertyValues> newValue = ImmutableNodePropertiesAndSchema.createUnmodifiableMap(true, false, entries);
        return new ImmutableNodePropertiesAndSchema(this, this.nodeSchema, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNodePropertiesAndSchema && this.equalTo((ImmutableNodePropertiesAndSchema)another);
    }

    private boolean equalTo(ImmutableNodePropertiesAndSchema another) {
        return this.nodeSchema.equals(another.nodeSchema) && this.nodeProperties.equals(another.nodeProperties);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.nodeSchema.hashCode();
        h += (h << 5) + this.nodeProperties.hashCode();
        return h;
    }

    public String toString() {
        return "NodePropertiesAndSchema{nodeSchema=" + this.nodeSchema + ", nodeProperties=" + this.nodeProperties + "}";
    }

    public static RandomGraphGenerator.NodePropertiesAndSchema of(NodeSchema nodeSchema, Map<String, ? extends NodePropertyValues> nodeProperties) {
        return new ImmutableNodePropertiesAndSchema(nodeSchema, nodeProperties);
    }

    static RandomGraphGenerator.NodePropertiesAndSchema copyOf(RandomGraphGenerator.NodePropertiesAndSchema instance) {
        if (instance instanceof ImmutableNodePropertiesAndSchema) {
            return (ImmutableNodePropertiesAndSchema)instance;
        }
        return ImmutableNodePropertiesAndSchema.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="RandomGraphGenerator.NodePropertiesAndSchema", generator="Immutables")
    @NotThreadSafe
    static final class Builder {
        private static final long INIT_BIT_NODE_SCHEMA = 1L;
        private long initBits = 1L;
        @Nullable
        private NodeSchema nodeSchema;
        private Map<String, NodePropertyValues> nodeProperties = null;

        private Builder() {
        }

        public final Builder from(ImmutableNodePropertiesAndSchema instance) {
            return this.from((RandomGraphGenerator.NodePropertiesAndSchema)instance);
        }

        final Builder from(RandomGraphGenerator.NodePropertiesAndSchema instance) {
            Objects.requireNonNull(instance, "instance");
            this.nodeSchema(instance.nodeSchema());
            this.putAllNodeProperties(instance.nodeProperties());
            return this;
        }

        public final Builder nodeSchema(NodeSchema nodeSchema) {
            this.nodeSchema = Objects.requireNonNull(nodeSchema, "nodeSchema");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder putNodeProperty(String key, NodePropertyValues value) {
            if (this.nodeProperties == null) {
                this.nodeProperties = new LinkedHashMap<String, NodePropertyValues>();
            }
            this.nodeProperties.put(Objects.requireNonNull(key, "nodeProperties key"), Objects.requireNonNull(value, "nodeProperties value"));
            return this;
        }

        public final Builder putNodeProperty(Map.Entry<String, ? extends NodePropertyValues> entry) {
            if (this.nodeProperties == null) {
                this.nodeProperties = new LinkedHashMap<String, NodePropertyValues>();
            }
            String k = entry.getKey();
            NodePropertyValues v = entry.getValue();
            this.nodeProperties.put(Objects.requireNonNull(k, "nodeProperties key"), Objects.requireNonNull(v, "nodeProperties value"));
            return this;
        }

        public final Builder nodeProperties(Map<String, ? extends NodePropertyValues> entries) {
            this.nodeProperties = new LinkedHashMap<String, NodePropertyValues>();
            return this.putAllNodeProperties(entries);
        }

        public final Builder putAllNodeProperties(Map<String, ? extends NodePropertyValues> entries) {
            if (this.nodeProperties == null) {
                this.nodeProperties = new LinkedHashMap<String, NodePropertyValues>();
            }
            for (Map.Entry<String, ? extends NodePropertyValues> e : entries.entrySet()) {
                String k = e.getKey();
                NodePropertyValues v = e.getValue();
                this.nodeProperties.put(Objects.requireNonNull(k, "nodeProperties key"), Objects.requireNonNull(v, "nodeProperties value"));
            }
            return this;
        }

        public Builder clear() {
            this.initBits = 1L;
            this.nodeSchema = null;
            if (this.nodeProperties != null) {
                this.nodeProperties.clear();
            }
            return this;
        }

        public RandomGraphGenerator.NodePropertiesAndSchema build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNodePropertiesAndSchema(null, this.nodeSchema, this.nodeProperties == null ? Collections.emptyMap() : ImmutableNodePropertiesAndSchema.createUnmodifiableMap(false, false, this.nodeProperties));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("nodeSchema");
            }
            return "Cannot build NodePropertiesAndSchema, some of required attributes are not set " + attributes;
        }
    }
}

