/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.api.properties.nodes;

import java.util.OptionalDouble;
import java.util.OptionalLong;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.api.nodeproperties.ValueType;
import org.neo4j.gds.api.properties.PropertyValues;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.values.storable.Value;

public interface NodePropertyValues
extends PropertyValues {
    default public double doubleValue(long nodeId) {
        throw this.unsupportedTypeException(ValueType.DOUBLE);
    }

    default public long longValue(long nodeId) {
        throw this.unsupportedTypeException(ValueType.LONG);
    }

    @Nullable
    default public double[] doubleArrayValue(long nodeId) {
        throw this.unsupportedTypeException(ValueType.DOUBLE_ARRAY);
    }

    @Nullable
    default public float[] floatArrayValue(long nodeId) {
        throw this.unsupportedTypeException(ValueType.FLOAT_ARRAY);
    }

    @Nullable
    default public long[] longArrayValue(long nodeId) {
        throw this.unsupportedTypeException(ValueType.LONG_ARRAY);
    }

    @Nullable
    public Object getObject(long var1);

    public Value value(long var1);

    default public OptionalLong getMaxLongPropertyValue() {
        if (this.valueType() == ValueType.LONG) {
            throw new UnsupportedOperationException(StringFormatting.formatWithLocale((String)"%s does not overwrite `getMaxLongPropertyValue`", (Object[])new Object[]{this.getClass().getSimpleName()}));
        }
        throw this.unsupportedTypeException(ValueType.LONG);
    }

    default public OptionalDouble getMaxDoublePropertyValue() {
        if (this.valueType() == ValueType.DOUBLE) {
            throw new UnsupportedOperationException(StringFormatting.formatWithLocale((String)"%s does not overwrite `getMaxDoublePropertyValue`", (Object[])new Object[]{this.getClass().getSimpleName()}));
        }
        throw this.unsupportedTypeException(ValueType.DOUBLE);
    }
}

