/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.api.properties.nodes;

import java.util.Collections;
import org.immutables.builder.Builder;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.api.properties.PropertyStore;
import org.neo4j.gds.api.properties.nodes.ImmutableNodePropertyStore;
import org.neo4j.gds.api.properties.nodes.NodeProperty;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;

@ValueClass
public interface NodePropertyStore
extends PropertyStore<NodePropertyValues, NodeProperty> {
    public static NodePropertyStore empty() {
        return ImmutableNodePropertyStore.of(Collections.emptyMap());
    }

    public static Builder builder() {
        return new Builder().properties(Collections.emptyMap());
    }

    @Builder.AccessibleFields
    public static final class Builder
    extends ImmutableNodePropertyStore.Builder {
        public Builder putIfAbsent(String propertyKey, NodeProperty nodeProperty) {
            this.properties.putIfAbsent(propertyKey, nodeProperty);
            return this;
        }

        public Builder removeProperty(String propertyKey) {
            this.properties.remove(propertyKey);
            return this;
        }
    }
}

