/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.api.properties.nodes;

import java.util.OptionalLong;
import java.util.stream.LongStream;
import org.neo4j.gds.api.ValueConversion;
import org.neo4j.gds.api.nodeproperties.ValueType;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public interface LongNodePropertyValues
extends NodePropertyValues {
    @Override
    public long longValue(long var1);

    @Override
    default public Object getObject(long nodeId) {
        return this.longValue(nodeId);
    }

    @Override
    default public Value value(long nodeId) {
        return Values.longValue((long)this.longValue(nodeId));
    }

    @Override
    default public ValueType valueType() {
        return ValueType.LONG;
    }

    @Override
    default public double doubleValue(long nodeId) {
        long value = this.longValue(nodeId);
        if (value == Long.MIN_VALUE) {
            return Double.NaN;
        }
        return ValueConversion.exactLongToDouble((long)value);
    }

    @Override
    default public OptionalLong getMaxLongPropertyValue() {
        return LongStream.range(0L, this.size()).parallel().map(this::longValue).max();
    }
}

