/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.api.properties.nodes;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.api.properties.nodes.NodeProperty;
import org.neo4j.gds.api.properties.nodes.NodePropertyStore;

@ParametersAreNonnullByDefault
@Generated(from="NodePropertyStore", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableNodePropertyStore
implements NodePropertyStore {
    private final Map<String, NodeProperty> properties;
    private final transient Set<String> keySet;

    private ImmutableNodePropertyStore(Map<String, ? extends NodeProperty> properties) {
        this.properties = ImmutableNodePropertyStore.createUnmodifiableMap(true, false, properties);
        this.keySet = Objects.requireNonNull(NodePropertyStore.super.keySet(), "keySet");
    }

    private ImmutableNodePropertyStore(ImmutableNodePropertyStore original, Map<String, NodeProperty> properties) {
        this.properties = properties;
        this.keySet = Objects.requireNonNull(NodePropertyStore.super.keySet(), "keySet");
    }

    @Override
    public Map<String, NodeProperty> properties() {
        return this.properties;
    }

    @Override
    public Set<String> keySet() {
        return this.keySet;
    }

    public final ImmutableNodePropertyStore withProperties(Map<String, ? extends NodeProperty> entries) {
        if (this.properties == entries) {
            return this;
        }
        Map<String, NodeProperty> newValue = ImmutableNodePropertyStore.createUnmodifiableMap(true, false, entries);
        return new ImmutableNodePropertyStore(this, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNodePropertyStore && this.equalTo((ImmutableNodePropertyStore)another);
    }

    private boolean equalTo(ImmutableNodePropertyStore another) {
        return this.properties.equals(another.properties) && this.keySet.equals(another.keySet);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.properties.hashCode();
        h += (h << 5) + this.keySet.hashCode();
        return h;
    }

    public String toString() {
        return "NodePropertyStore{properties=" + this.properties + ", keySet=" + this.keySet + "}";
    }

    public static NodePropertyStore of(Map<String, ? extends NodeProperty> properties) {
        return new ImmutableNodePropertyStore(properties);
    }

    public static NodePropertyStore copyOf(NodePropertyStore instance) {
        if (instance instanceof ImmutableNodePropertyStore) {
            return (ImmutableNodePropertyStore)instance;
        }
        return new NodePropertyStore.Builder().from(instance).build();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="NodePropertyStore", generator="Immutables")
    @NotThreadSafe
    public static class Builder {
        protected Map<String, NodeProperty> properties = null;

        public Builder() {
            if (!(this instanceof NodePropertyStore.Builder)) {
                throw new UnsupportedOperationException("Use: new NodePropertyStore.Builder()");
            }
        }

        public final NodePropertyStore.Builder from(NodePropertyStore instance) {
            Objects.requireNonNull(instance, "instance");
            this.putAllProperties(instance.properties());
            return (NodePropertyStore.Builder)this;
        }

        public final NodePropertyStore.Builder putProperty(String key, NodeProperty value) {
            if (this.properties == null) {
                this.properties = new LinkedHashMap<String, NodeProperty>();
            }
            this.properties.put(Objects.requireNonNull(key, "properties key"), Objects.requireNonNull(value, "properties value"));
            return (NodePropertyStore.Builder)this;
        }

        public final NodePropertyStore.Builder putProperty(Map.Entry<String, ? extends NodeProperty> entry) {
            if (this.properties == null) {
                this.properties = new LinkedHashMap<String, NodeProperty>();
            }
            String k = entry.getKey();
            NodeProperty v = entry.getValue();
            this.properties.put(Objects.requireNonNull(k, "properties key"), Objects.requireNonNull(v, "properties value"));
            return (NodePropertyStore.Builder)this;
        }

        public final NodePropertyStore.Builder properties(Map<String, ? extends NodeProperty> entries) {
            this.properties = new LinkedHashMap<String, NodeProperty>();
            return this.putAllProperties(entries);
        }

        public final NodePropertyStore.Builder putAllProperties(Map<String, ? extends NodeProperty> entries) {
            if (this.properties == null) {
                this.properties = new LinkedHashMap<String, NodeProperty>();
            }
            for (Map.Entry<String, ? extends NodeProperty> e : entries.entrySet()) {
                String k = e.getKey();
                NodeProperty v = e.getValue();
                this.properties.put(Objects.requireNonNull(k, "properties key"), Objects.requireNonNull(v, "properties value"));
            }
            return (NodePropertyStore.Builder)this;
        }

        public NodePropertyStore.Builder clear() {
            if (this.properties != null) {
                this.properties.clear();
            }
            return (NodePropertyStore.Builder)this;
        }

        public NodePropertyStore build() {
            return new ImmutableNodePropertyStore(null, this.properties == null ? Collections.emptyMap() : ImmutableNodePropertyStore.createUnmodifiableMap(false, false, this.properties));
        }
    }
}

