/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.api.properties.nodes;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.api.properties.nodes.NodeProperty;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.api.schema.PropertySchema;

@ParametersAreNonnullByDefault
@Generated(from="NodeProperty", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableNodeProperty
implements NodeProperty {
    private final NodePropertyValues values;
    private final PropertySchema propertySchema;

    private ImmutableNodeProperty(NodePropertyValues values, PropertySchema propertySchema) {
        this.values = Objects.requireNonNull(values, "values");
        this.propertySchema = Objects.requireNonNull(propertySchema, "propertySchema");
    }

    private ImmutableNodeProperty(ImmutableNodeProperty original, NodePropertyValues values, PropertySchema propertySchema) {
        this.values = values;
        this.propertySchema = propertySchema;
    }

    @Override
    public NodePropertyValues values() {
        return this.values;
    }

    @Override
    public PropertySchema propertySchema() {
        return this.propertySchema;
    }

    public final ImmutableNodeProperty withValues(NodePropertyValues value) {
        if (this.values == value) {
            return this;
        }
        NodePropertyValues newValue = Objects.requireNonNull(value, "values");
        return new ImmutableNodeProperty(this, newValue, this.propertySchema);
    }

    public final ImmutableNodeProperty withPropertySchema(PropertySchema value) {
        if (this.propertySchema == value) {
            return this;
        }
        PropertySchema newValue = Objects.requireNonNull(value, "propertySchema");
        return new ImmutableNodeProperty(this, this.values, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNodeProperty && this.equalTo((ImmutableNodeProperty)another);
    }

    private boolean equalTo(ImmutableNodeProperty another) {
        return this.values.equals(another.values) && this.propertySchema.equals(another.propertySchema);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.values.hashCode();
        h += (h << 5) + this.propertySchema.hashCode();
        return h;
    }

    public String toString() {
        return "NodeProperty{values=" + this.values + ", propertySchema=" + this.propertySchema + "}";
    }

    public static NodeProperty of(NodePropertyValues values, PropertySchema propertySchema) {
        return new ImmutableNodeProperty(values, propertySchema);
    }

    public static NodeProperty copyOf(NodeProperty instance) {
        if (instance instanceof ImmutableNodeProperty) {
            return (ImmutableNodeProperty)instance;
        }
        return ImmutableNodeProperty.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="NodeProperty", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_VALUES = 1L;
        private static final long INIT_BIT_PROPERTY_SCHEMA = 2L;
        private long initBits = 3L;
        @Nullable
        private NodePropertyValues values;
        @Nullable
        private PropertySchema propertySchema;

        private Builder() {
        }

        public final Builder from(NodeProperty instance) {
            Objects.requireNonNull(instance, "instance");
            this.values((NodePropertyValues)instance.values());
            this.propertySchema(instance.propertySchema());
            return this;
        }

        public final Builder values(NodePropertyValues values) {
            this.values = Objects.requireNonNull(values, "values");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder propertySchema(PropertySchema propertySchema) {
            this.propertySchema = Objects.requireNonNull(propertySchema, "propertySchema");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder clear() {
            this.initBits = 3L;
            this.values = null;
            this.propertySchema = null;
            return this;
        }

        public NodeProperty build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNodeProperty(null, this.values, this.propertySchema);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("values");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("propertySchema");
            }
            return "Cannot build NodeProperty, some of required attributes are not set " + attributes;
        }
    }
}

