/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.api.properties.nodes;

import java.util.OptionalDouble;
import java.util.stream.LongStream;
import org.neo4j.gds.api.nodeproperties.ValueType;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public interface DoubleNodePropertyValues
extends NodePropertyValues {
    @Override
    public double doubleValue(long var1);

    @Override
    default public Object getObject(long nodeId) {
        return this.doubleValue(nodeId);
    }

    @Override
    default public Value value(long nodeId) {
        double value = this.doubleValue(nodeId);
        return Double.isNaN(value) ? null : Values.doubleValue((double)value);
    }

    @Override
    default public ValueType valueType() {
        return ValueType.DOUBLE;
    }

    @Override
    default public OptionalDouble getMaxDoublePropertyValue() {
        return LongStream.range(0L, this.size()).parallel().mapToDouble(this::doubleValue).max();
    }
}

