/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.api.properties.graph;

import java.util.stream.DoubleStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.neo4j.gds.api.ValueConversion;
import org.neo4j.gds.api.nodeproperties.ValueType;
import org.neo4j.gds.api.properties.graph.GraphPropertyValues;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public interface LongGraphPropertyValues
extends GraphPropertyValues {
    @Override
    public LongStream longValues();

    default public Stream<Long> objects() {
        return this.longValues().boxed();
    }

    @Override
    default public Stream<Value> values() {
        return this.longValues().mapToObj(Values::longValue);
    }

    @Override
    default public ValueType valueType() {
        return ValueType.LONG;
    }

    @Override
    default public DoubleStream doubleValues() {
        return this.longValues().mapToDouble(value -> {
            if (value == Long.MIN_VALUE) {
                return Double.NaN;
            }
            return ValueConversion.exactLongToDouble((long)value);
        });
    }

    public static LongGraphPropertyValues ofLongStream(final LongStream longStream) {
        return new LongGraphPropertyValues(){

            @Override
            public LongStream longValues() {
                return longStream;
            }

            @Override
            public long size() {
                return -1L;
            }
        };
    }
}

