/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.api.properties.graph;

import java.util.stream.Stream;
import org.neo4j.gds.api.nodeproperties.ValueType;
import org.neo4j.gds.api.properties.graph.GraphPropertyValues;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public interface LongArrayGraphPropertyValues
extends GraphPropertyValues {
    @Override
    public Stream<long[]> longArrayValues();

    default public Stream<long[]> objects() {
        return this.longArrayValues();
    }

    @Override
    default public Stream<Value> values() {
        return this.longArrayValues().map(value -> value == null ? null : Values.longArray((long[])value));
    }

    @Override
    default public ValueType valueType() {
        return ValueType.LONG_ARRAY;
    }

    public static LongArrayGraphPropertyValues ofLongArrayStream(final Stream<long[]> longArrayStream) {
        return new LongArrayGraphPropertyValues(){

            @Override
            public Stream<long[]> longArrayValues() {
                return longArrayStream;
            }

            @Override
            public long size() {
                return -1L;
            }
        };
    }
}

