/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.api.properties.graph;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.api.properties.graph.GraphProperty;
import org.neo4j.gds.api.properties.graph.GraphPropertyStore;

@ParametersAreNonnullByDefault
@Generated(from="GraphPropertyStore", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableGraphPropertyStore
implements GraphPropertyStore {
    private final Map<String, GraphProperty> properties;
    private final transient Set<String> keySet;

    private ImmutableGraphPropertyStore(Map<String, ? extends GraphProperty> properties) {
        this.properties = ImmutableGraphPropertyStore.createUnmodifiableMap(true, false, properties);
        this.keySet = Objects.requireNonNull(GraphPropertyStore.super.keySet(), "keySet");
    }

    private ImmutableGraphPropertyStore(ImmutableGraphPropertyStore original, Map<String, GraphProperty> properties) {
        this.properties = properties;
        this.keySet = Objects.requireNonNull(GraphPropertyStore.super.keySet(), "keySet");
    }

    @Override
    public Map<String, GraphProperty> properties() {
        return this.properties;
    }

    @Override
    public Set<String> keySet() {
        return this.keySet;
    }

    public final ImmutableGraphPropertyStore withProperties(Map<String, ? extends GraphProperty> entries) {
        if (this.properties == entries) {
            return this;
        }
        Map<String, GraphProperty> newValue = ImmutableGraphPropertyStore.createUnmodifiableMap(true, false, entries);
        return new ImmutableGraphPropertyStore(this, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGraphPropertyStore && this.equalTo((ImmutableGraphPropertyStore)another);
    }

    private boolean equalTo(ImmutableGraphPropertyStore another) {
        return this.properties.equals(another.properties) && this.keySet.equals(another.keySet);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.properties.hashCode();
        h += (h << 5) + this.keySet.hashCode();
        return h;
    }

    public String toString() {
        return "GraphPropertyStore{properties=" + this.properties + ", keySet=" + this.keySet + "}";
    }

    public static GraphPropertyStore of(Map<String, ? extends GraphProperty> properties) {
        return new ImmutableGraphPropertyStore(properties);
    }

    public static GraphPropertyStore copyOf(GraphPropertyStore instance) {
        if (instance instanceof ImmutableGraphPropertyStore) {
            return (ImmutableGraphPropertyStore)instance;
        }
        return new GraphPropertyStore.Builder().from(instance).build();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="GraphPropertyStore", generator="Immutables")
    @NotThreadSafe
    public static class Builder {
        protected Map<String, GraphProperty> properties = null;

        public Builder() {
            if (!(this instanceof GraphPropertyStore.Builder)) {
                throw new UnsupportedOperationException("Use: new GraphPropertyStore.Builder()");
            }
        }

        public final GraphPropertyStore.Builder from(GraphPropertyStore instance) {
            Objects.requireNonNull(instance, "instance");
            this.putAllProperties(instance.properties());
            return (GraphPropertyStore.Builder)this;
        }

        public final GraphPropertyStore.Builder putProperty(String key, GraphProperty value) {
            if (this.properties == null) {
                this.properties = new LinkedHashMap<String, GraphProperty>();
            }
            this.properties.put(Objects.requireNonNull(key, "properties key"), Objects.requireNonNull(value, "properties value"));
            return (GraphPropertyStore.Builder)this;
        }

        public final GraphPropertyStore.Builder putProperty(Map.Entry<String, ? extends GraphProperty> entry) {
            if (this.properties == null) {
                this.properties = new LinkedHashMap<String, GraphProperty>();
            }
            String k = entry.getKey();
            GraphProperty v = entry.getValue();
            this.properties.put(Objects.requireNonNull(k, "properties key"), Objects.requireNonNull(v, "properties value"));
            return (GraphPropertyStore.Builder)this;
        }

        public final GraphPropertyStore.Builder properties(Map<String, ? extends GraphProperty> entries) {
            this.properties = new LinkedHashMap<String, GraphProperty>();
            return this.putAllProperties(entries);
        }

        public final GraphPropertyStore.Builder putAllProperties(Map<String, ? extends GraphProperty> entries) {
            if (this.properties == null) {
                this.properties = new LinkedHashMap<String, GraphProperty>();
            }
            for (Map.Entry<String, ? extends GraphProperty> e : entries.entrySet()) {
                String k = e.getKey();
                GraphProperty v = e.getValue();
                this.properties.put(Objects.requireNonNull(k, "properties key"), Objects.requireNonNull(v, "properties value"));
            }
            return (GraphPropertyStore.Builder)this;
        }

        public GraphPropertyStore.Builder clear() {
            if (this.properties != null) {
                this.properties.clear();
            }
            return (GraphPropertyStore.Builder)this;
        }

        public GraphPropertyStore build() {
            return new ImmutableGraphPropertyStore(null, this.properties == null ? Collections.emptyMap() : ImmutableGraphPropertyStore.createUnmodifiableMap(false, false, this.properties));
        }
    }
}

