/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.api.properties.graph;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.api.properties.graph.GraphProperty;
import org.neo4j.gds.api.properties.graph.GraphPropertyValues;
import org.neo4j.gds.api.schema.PropertySchema;

@ParametersAreNonnullByDefault
@Generated(from="GraphProperty", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableGraphProperty
implements GraphProperty {
    private final GraphPropertyValues values;
    private final PropertySchema propertySchema;

    private ImmutableGraphProperty(GraphPropertyValues values, PropertySchema propertySchema) {
        this.values = Objects.requireNonNull(values, "values");
        this.propertySchema = Objects.requireNonNull(propertySchema, "propertySchema");
    }

    private ImmutableGraphProperty(ImmutableGraphProperty original, GraphPropertyValues values, PropertySchema propertySchema) {
        this.values = values;
        this.propertySchema = propertySchema;
    }

    @Override
    public GraphPropertyValues values() {
        return this.values;
    }

    @Override
    public PropertySchema propertySchema() {
        return this.propertySchema;
    }

    public final ImmutableGraphProperty withValues(GraphPropertyValues value) {
        if (this.values == value) {
            return this;
        }
        GraphPropertyValues newValue = Objects.requireNonNull(value, "values");
        return new ImmutableGraphProperty(this, newValue, this.propertySchema);
    }

    public final ImmutableGraphProperty withPropertySchema(PropertySchema value) {
        if (this.propertySchema == value) {
            return this;
        }
        PropertySchema newValue = Objects.requireNonNull(value, "propertySchema");
        return new ImmutableGraphProperty(this, this.values, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGraphProperty && this.equalTo((ImmutableGraphProperty)another);
    }

    private boolean equalTo(ImmutableGraphProperty another) {
        return this.values.equals(another.values) && this.propertySchema.equals(another.propertySchema);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.values.hashCode();
        h += (h << 5) + this.propertySchema.hashCode();
        return h;
    }

    public String toString() {
        return "GraphProperty{values=" + this.values + ", propertySchema=" + this.propertySchema + "}";
    }

    public static GraphProperty of(GraphPropertyValues values, PropertySchema propertySchema) {
        return new ImmutableGraphProperty(values, propertySchema);
    }

    public static GraphProperty copyOf(GraphProperty instance) {
        if (instance instanceof ImmutableGraphProperty) {
            return (ImmutableGraphProperty)instance;
        }
        return ImmutableGraphProperty.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="GraphProperty", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_VALUES = 1L;
        private static final long INIT_BIT_PROPERTY_SCHEMA = 2L;
        private long initBits = 3L;
        @Nullable
        private GraphPropertyValues values;
        @Nullable
        private PropertySchema propertySchema;

        private Builder() {
        }

        public final Builder from(GraphProperty instance) {
            Objects.requireNonNull(instance, "instance");
            this.values((GraphPropertyValues)instance.values());
            this.propertySchema(instance.propertySchema());
            return this;
        }

        public final Builder values(GraphPropertyValues values) {
            this.values = Objects.requireNonNull(values, "values");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder propertySchema(PropertySchema propertySchema) {
            this.propertySchema = Objects.requireNonNull(propertySchema, "propertySchema");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder clear() {
            this.initBits = 3L;
            this.values = null;
            this.propertySchema = null;
            return this;
        }

        public GraphProperty build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGraphProperty(null, this.values, this.propertySchema);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("values");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("propertySchema");
            }
            return "Cannot build GraphProperty, some of required attributes are not set " + attributes;
        }
    }
}

