/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.api.properties.graph;

import java.util.Collections;
import org.immutables.builder.Builder;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.api.properties.PropertyStore;
import org.neo4j.gds.api.properties.graph.GraphProperty;
import org.neo4j.gds.api.properties.graph.GraphPropertyValues;
import org.neo4j.gds.api.properties.graph.ImmutableGraphPropertyStore;

@ValueClass
public interface GraphPropertyStore
extends PropertyStore<GraphPropertyValues, GraphProperty> {
    public static GraphPropertyStore empty() {
        return ImmutableGraphPropertyStore.of(Collections.emptyMap());
    }

    public static Builder builder() {
        return new Builder().properties(Collections.emptyMap());
    }

    @Builder.AccessibleFields
    public static final class Builder
    extends ImmutableGraphPropertyStore.Builder {
        public Builder putIfAbsent(String propertyKey, GraphProperty graphProperty) {
            this.properties.putIfAbsent(propertyKey, graphProperty);
            return this;
        }

        public Builder removeProperty(String propertyKey) {
            this.properties.remove(propertyKey);
            return this;
        }
    }
}

