/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.api.properties.graph;

import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.api.nodeproperties.ValueType;
import org.neo4j.gds.api.properties.graph.GraphPropertyValues;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public interface FloatArrayGraphPropertyValues
extends GraphPropertyValues {
    @Override
    public Stream<float[]> floatArrayValues();

    default public Stream<float[]> objects() {
        return this.floatArrayValues();
    }

    @Override
    default public Stream<Value> values() {
        return this.floatArrayValues().map(value -> value == null ? null : Values.floatArray((float[])value));
    }

    @Override
    @Nullable
    default public Stream<double[]> doubleArrayValues() {
        return this.floatArrayValues().map(floatArray -> {
            if (floatArray == null) {
                return null;
            }
            double[] doubleArray = new double[((float[])floatArray).length];
            for (int i = 0; i < ((float[])floatArray).length; ++i) {
                doubleArray[i] = floatArray[i];
            }
            return doubleArray;
        });
    }

    @Override
    default public ValueType valueType() {
        return ValueType.FLOAT_ARRAY;
    }

    public static FloatArrayGraphPropertyValues ofFloatArrayStream(final Stream<float[]> floatArrayStream) {
        return new FloatArrayGraphPropertyValues(){

            @Override
            public Stream<float[]> floatArrayValues() {
                return floatArrayStream;
            }

            @Override
            public long size() {
                return -1L;
            }
        };
    }
}

