/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.api.properties.graph;

import java.util.stream.DoubleStream;
import java.util.stream.Stream;
import org.neo4j.gds.api.nodeproperties.ValueType;
import org.neo4j.gds.api.properties.graph.GraphPropertyValues;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public interface DoubleGraphPropertyValues
extends GraphPropertyValues {
    @Override
    public DoubleStream doubleValues();

    default public Stream<Double> objects() {
        return this.doubleValues().boxed();
    }

    @Override
    default public Stream<Value> values() {
        return this.doubleValues().mapToObj(value -> Double.isNaN(value) ? null : Values.doubleValue((double)value));
    }

    @Override
    default public ValueType valueType() {
        return ValueType.DOUBLE;
    }

    public static DoubleGraphPropertyValues ofDoubleStream(final DoubleStream doubleStream) {
        return new DoubleGraphPropertyValues(){

            @Override
            public DoubleStream doubleValues() {
                return doubleStream;
            }

            @Override
            public long size() {
                return -1L;
            }
        };
    }
}

