/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.api.properties.graph;

import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.api.nodeproperties.ValueType;
import org.neo4j.gds.api.properties.graph.GraphPropertyValues;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public interface DoubleArrayGraphPropertyValues
extends GraphPropertyValues {
    @Override
    public Stream<double[]> doubleArrayValues();

    default public Stream<double[]> objects() {
        return this.doubleArrayValues();
    }

    @Override
    default public Stream<Value> values() {
        return this.doubleArrayValues().map(value -> value == null ? null : Values.doubleArray((double[])value));
    }

    @Override
    @Nullable
    default public Stream<float[]> floatArrayValues() {
        return this.doubleArrayValues().map(doubleArray -> {
            if (doubleArray == null) {
                return null;
            }
            float[] floatArray = new float[((double[])doubleArray).length];
            for (int i = 0; i < ((double[])doubleArray).length; ++i) {
                floatArray[i] = (float)doubleArray[i];
            }
            return floatArray;
        });
    }

    @Override
    default public ValueType valueType() {
        return ValueType.DOUBLE_ARRAY;
    }

    public static DoubleArrayGraphPropertyValues ofDoubleArrayStream(final Stream<double[]> doubleArrayStream) {
        return new DoubleArrayGraphPropertyValues(){

            @Override
            public Stream<double[]> doubleArrayValues() {
                return doubleArrayStream;
            }

            @Override
            public long size() {
                return -1L;
            }
        };
    }
}

