/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.api.properties;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.immutables.value.Value;
import org.neo4j.gds.api.properties.Property;
import org.neo4j.gds.api.properties.PropertyValues;

public interface PropertyStore<VALUE extends PropertyValues, PROPERTY extends Property<VALUE>> {
    public Map<String, PROPERTY> properties();

    default public Map<String, VALUE> propertyValues() {
        return this.properties().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Property)entry.getValue()).values()));
    }

    default public PROPERTY get(String propertyKey) {
        return (PROPERTY)((Property)this.properties().get(propertyKey));
    }

    default public boolean isEmpty() {
        return this.properties().isEmpty();
    }

    @Value.Derived
    default public Set<String> keySet() {
        return Collections.unmodifiableSet(this.properties().keySet());
    }

    default public boolean containsKey(String propertyKey) {
        return this.properties().containsKey(propertyKey);
    }
}

